/*
 * Decompiled with CFR 0.152.
 */
package mythruna.event;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import mythruna.event.EventListener;
import mythruna.event.EventType;
import org.progeeks.util.log.Log;

public class EventDispatcher {
    static Log log = Log.getLog();
    private static EventDispatcher instance = new EventDispatcher();
    private Map<EventType, List<EventListener>> listenerMap = new ConcurrentHashMap<EventType, List<EventListener>>();

    protected EventDispatcher() {
    }

    public static EventDispatcher getInstance() {
        return instance;
    }

    protected List<EventListener> getListeners(EventType type) {
        List<EventListener> list = this.listenerMap.get(type);
        if (list == null) {
            list = new CopyOnWriteArrayList<EventListener>();
            this.listenerMap.put(type, list);
        }
        return list;
    }

    public <E> void addListener(EventType<E> type, EventListener<E> listener) {
        this.getListeners(type).add(listener);
    }

    public <E> void removeListener(EventType<E> type, EventListener<E> listener) {
        this.getListeners(type).remove(listener);
    }

    public <E> void publishEvent(EventType<E> type, E event) {
        for (EventListener l : this.getListeners(type)) {
            try {
                l.newEvent(type, event);
            }
            catch (Throwable t) {
                log.error((Object)("Error handling event:" + event + " for type:" + type + "  in handler:" + l), t);
            }
        }
    }
}

