/*
 * Decompiled with CFR 0.152.
 */
package mythruna.geom;

import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import mythruna.BlockType;
import mythruna.BoundaryShape;
import mythruna.Direction;
import mythruna.ShapeIndex;
import mythruna.geom.CubeFactory;
import mythruna.geom.GeomFactory;
import mythruna.geom.GeomPart;
import mythruna.geom.GeomPartBuffer;

public class AngleFactory
implements GeomFactory {
    private static final int SIDE_EMPTY = 0;
    private static final int SIDE_SOLID = 1;
    private static final int SIDE_TRI_TOP = 2;
    private static final int SIDE_TRI_BOTTOM = 3;
    private static final float[][] triangles = new float[][]{{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f}, {1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f}, {1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f}, {0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f}};
    private static final float[][] texCoords = new float[][]{{0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f}, {1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f}, {1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f}};
    private static final float[][] unstretchedTexCoords = new float[][]{{0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f}, {0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f}, {1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f}};
    private static final float COS45 = FastMath.cos((float)0.7853982f);
    private static final float[][] normals = new float[][]{{COS45, 0.0f, COS45}, {-COS45, 0.0f, -COS45}, {-COS45, 0.0f, COS45}, {COS45, 0.0f, -COS45}};
    private static final float[][] tangents = new float[][]{{COS45, 0.0f, -COS45}, {-COS45, 0.0f, COS45}, {COS45, 0.0f, COS45}, {-COS45, 0.0f, -COS45}};
    private int[] types = new int[6];
    private int interiorType;
    private int[] sides = new int[6];
    private int solidDir1;
    private int solidDir2;
    private BoundaryShape[] shapes = new BoundaryShape[6];
    private CubeFactory solid;
    private boolean unstretched = true;

    public AngleFactory(int solidSide1, int solidSide2, int materialType) {
        this.solid = new CubeFactory(materialType);
        this.solidDir1 = solidSide1;
        this.solidDir2 = solidSide2;
        this.sides[solidSide1] = 1;
        this.sides[solidSide2] = 1;
        this.sides[4] = 2;
        this.sides[5] = 3;
        for (int i = 0; i < this.types.length; ++i) {
            this.types[i] = materialType;
        }
        this.interiorType = materialType;
        this.setupShapes(solidSide1, solidSide2);
    }

    public AngleFactory(int solidSide1, int solidSide2, int materialType, int interiorMaterial) {
        this.solid = new CubeFactory(materialType);
        this.solidDir1 = solidSide1;
        this.solidDir2 = solidSide2;
        this.sides[solidSide1] = 1;
        this.sides[solidSide2] = 1;
        this.sides[4] = 2;
        this.sides[5] = 3;
        for (int i = 0; i < this.types.length; ++i) {
            this.types[i] = materialType;
        }
        this.interiorType = interiorMaterial;
        this.setupShapes(solidSide1, solidSide2);
    }

    public AngleFactory(int solidSide1, int solidSide2, int materialType, int topMaterial, int bottomMaterial, int interiorType) {
        this.solid = new CubeFactory(materialType);
        this.solidDir1 = solidSide1;
        this.solidDir2 = solidSide2;
        this.sides[solidSide1] = 1;
        this.sides[solidSide2] = 1;
        this.sides[4] = 2;
        this.sides[5] = 3;
        for (int i = 0; i < this.types.length; ++i) {
            this.types[i] = materialType;
        }
        this.types[4] = topMaterial;
        this.types[5] = bottomMaterial;
        this.interiorType = interiorType;
        this.setupShapes(solidSide1, solidSide2);
    }

    public int getDirection() {
        return this.solidDir1;
    }

    @Override
    public boolean isSameShape(GeomFactory f) {
        if (f == this) {
            return true;
        }
        if (f == null || f.getClass() != this.getClass()) {
            return false;
        }
        AngleFactory other = (AngleFactory)f;
        if (other.solidDir1 != this.solidDir1) {
            return false;
        }
        return other.solidDir2 == this.solidDir2;
    }

    protected void setupShapes(int solidSide1, int solidSide2) {
        for (int d = 0; d < this.shapes.length; ++d) {
            this.shapes[d] = ShapeIndex.NULL_SHAPE;
        }
        this.shapes[solidSide1] = CubeFactory.UNIT_SQUARE;
        this.shapes[solidSide2] = CubeFactory.UNIT_SQUARE;
        float[] normal = normals[solidSide1];
        this.shapes[4] = ShapeIndex.getTriangle(0.0f, 0.0f, 1.0f, 1.0f, normal[0], normal[2]);
        this.shapes[5] = this.shapes[4];
    }

    @Override
    public int createGeometry(GeomPartBuffer buffer, int x, int y, int z, int xWorld, int yWorld, int zWorld, float sun, float light, BlockType block, int dir) {
        if (this.sides[dir] == 1) {
            return this.solid.createGeometry(buffer, x, y, z, xWorld, yWorld, zWorld, sun, light, block, dir);
        }
        if (this.sides[dir] == 0) {
            return 0;
        }
        GeomPart part = new GeomPart(this.types[dir], dir);
        part.setSun(sun);
        part.setLight(light);
        float yFace = 0.0f;
        if (dir == 4) {
            yFace = 1.0f;
        }
        float[] tri = triangles[this.solidDir1];
        float[] tex = this.unstretched ? unstretchedTexCoords[this.solidDir1] : texCoords[this.solidDir1];
        float[] norms = Direction.NORMALS[dir];
        float[] tangents = Direction.TANGENTS[dir];
        part.setCoords((float)x + tri[0], (float)z + yFace, (float)y + tri[2], (float)x + tri[3], (float)z + yFace, (float)y + tri[5], (float)x + tri[6], (float)z + yFace, (float)y + tri[8]);
        part.setTexCoords(tex);
        if (dir == 4) {
            part.setIndexes(0, 1, 2);
        } else {
            part.setIndexes(0, 2, 1);
        }
        buffer.add(part);
        return 1;
    }

    @Override
    public int createInternalGeometry(GeomPartBuffer buffer, int x, int y, int z, int xWorld, int yWorld, int zWorld, float sun, float light, BlockType block) {
        float[] tri = triangles[this.solidDir1];
        GeomPart part = new GeomPart(this.interiorType, -1);
        part.setSun(sun);
        part.setLight(light);
        float n = FastMath.cos((float)0.7853982f);
        part.setCoords((float)x + tri[3], z, (float)y + tri[5], (float)x + tri[6], z, (float)y + tri[8], (float)x + tri[6], z + 1, (float)y + tri[8], (float)x + tri[3], z + 1, (float)y + tri[5]);
        part.setTexCoords(0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f);
        float[] normal = normals[this.solidDir1];
        float[] tangent = tangents[this.solidDir1];
        part.setNormals(normal[0], normal[1], normal[2], normal[0], normal[1], normal[2], normal[0], normal[1], normal[2], normal[0], normal[1], normal[2]);
        part.setTangents(tangent[0], tangent[1], tangent[2], tangent[0], tangent[1], tangent[2], tangent[0], tangent[1], tangent[2], tangent[0], tangent[1], tangent[2]);
        part.setIndexes(0, 1, 2, 0, 2, 3);
        buffer.add(part);
        return 0;
    }

    @Override
    public boolean isSolid(int direction) {
        return this.sides[direction] == 1;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public boolean isBoundary(int direction) {
        return this.sides[direction] != 0;
    }

    @Override
    public BoundaryShape getBoundaryShape(int direction) {
        return this.shapes[direction];
    }

    @Override
    public final float getTransparency(int axis) {
        return 0.0f;
    }

    @Override
    public Vector3f getMin() {
        return Vector3f.ZERO;
    }

    @Override
    public Vector3f getMax() {
        return CubeFactory.UNIT_CUBE;
    }

    @Override
    public double getMassPortion() {
        double x = this.getMax().x - this.getMin().x;
        double y = this.getMax().y - this.getMin().y;
        double z = this.getMax().z - this.getMin().z;
        return x * y * z * 0.5;
    }

    private float dot(Vector3f origin, float[] triOrigin, float[] dir, float x, float y) {
        x -= origin.x;
        y -= origin.y;
        return dir[0] * (x -= triOrigin[0]) + dir[2] * (y -= triOrigin[2]);
    }

    @Override
    public boolean isClipped() {
        return true;
    }
}

