/*
 * Decompiled with CFR 0.152.
 */
package mythruna.geom;

import com.jme3.math.Vector3f;
import mythruna.BlockType;
import mythruna.BoundaryShape;
import mythruna.ShapeIndex;
import mythruna.geom.GeomFactory;
import mythruna.geom.GeomPartBuffer;
import mythruna.geom.GeomUtils;

public class CubeFactory
implements GeomFactory {
    public static final Vector3f UNIT_CUBE = new Vector3f(1.0f, 1.0f, 1.0f);
    public static final BoundaryShape UNIT_SQUARE = ShapeIndex.getRect(0.0f, 0.0f, 1.0f, 1.0f);
    private int[] types = new int[6];
    private float[] transparency = new float[]{0.0f, 0.0f, 0.0f};
    private boolean includeNormals = false;

    public CubeFactory(int materialType) {
        for (int i = 0; i < this.types.length; ++i) {
            this.types[i] = materialType;
        }
    }

    public CubeFactory(int sideType, int topType, int bottomType) {
        this(sideType);
        this.types[4] = topType;
        this.types[5] = bottomType;
    }

    public CubeFactory(int topType, int bottomType, int ... sides) {
        this(topType);
        for (int i = 0; i < sides.length; ++i) {
            this.types[i] = sides[i];
        }
    }

    public CubeFactory(float[] light, int topType, int bottomType, int ... sides) {
        this(topType);
        for (int i = 0; i < sides.length; ++i) {
            this.types[i] = sides[i];
        }
        if (light != null) {
            this.transparency = light;
        }
    }

    @Override
    public boolean isSameShape(GeomFactory f) {
        if (f == this) {
            return true;
        }
        return f != null && f.getClass() == this.getClass();
    }

    @Override
    public int createGeometry(GeomPartBuffer buffer, int x, int y, int z, int xWorld, int yWorld, int zWorld, float sun, float light, BlockType block, int dir) {
        int type = this.types[dir];
        buffer.add(GeomUtils.createQuad(x, y, z, Vector3f.ZERO, UNIT_CUBE, this.includeNormals, dir, type, sun, light));
        return 1;
    }

    @Override
    public int createInternalGeometry(GeomPartBuffer buffer, int x, int y, int z, int xWorld, int yWorld, int zWorld, float sun, float light, BlockType block) {
        return 0;
    }

    @Override
    public final float getTransparency(int axis) {
        return this.transparency[axis];
    }

    @Override
    public final boolean isSolid(int direction) {
        return true;
    }

    @Override
    public final boolean isSolid() {
        return true;
    }

    @Override
    public final boolean isBoundary(int direction) {
        return true;
    }

    @Override
    public final BoundaryShape getBoundaryShape(int direction) {
        return UNIT_SQUARE;
    }

    @Override
    public final Vector3f getMin() {
        return Vector3f.ZERO;
    }

    @Override
    public final Vector3f getMax() {
        return UNIT_CUBE;
    }

    @Override
    public final double getMassPortion() {
        double x = this.getMax().x - this.getMin().x;
        double y = this.getMax().y - this.getMin().y;
        double z = this.getMax().z - this.getMin().z;
        return x * y * z;
    }

    @Override
    public final boolean isClipped() {
        return true;
    }
}

