/*
 * Decompiled with CFR 0.152.
 */
package mythruna.geom;

import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import mythruna.BlockType;
import mythruna.BoundaryShape;
import mythruna.ShapeIndex;
import mythruna.geom.GeomFactory;
import mythruna.geom.GeomPart;
import mythruna.geom.GeomPartBuffer;

public class CylinderFactory2
implements GeomFactory {
    private static float[][] RADIALS = new float[][]{CylinderFactory2.cosAndSin(0.0f), CylinderFactory2.cosAndSin(0.7853982f), CylinderFactory2.cosAndSin(1.5707964f), CylinderFactory2.cosAndSin(2.3561945f), CylinderFactory2.cosAndSin((float)Math.PI), CylinderFactory2.cosAndSin(3.926991f), CylinderFactory2.cosAndSin(4.712389f), CylinderFactory2.cosAndSin(5.4977875f), CylinderFactory2.cosAndSin(0.0f)};
    private static float[] texCoord = new float[]{0.0f, 0.5f, 1.0f, 1.5f, 2.0f, 2.5f, 3.0f, 3.5f, 4.0f};
    private Vector3f[] axes = new Vector3f[]{new Vector3f(1.0f, 1.0f, 0.0f).normalizeLocal(), new Vector3f(-1.0f, 1.0f, 0.0f).normalizeLocal(), new Vector3f(0.0f, 0.0f, 1.0f)};
    private int sideMaterialType;
    private int topMaterialType;
    private int dir = -1;
    private float radius;
    private boolean generateTangents = true;
    private float textureScale = 1.0f;
    private TextureType mapping = TextureType.RADIAL;
    private float height = FastMath.sqrt((float)2.0f) * 0.5f;
    private Vector3f offset;
    private Quaternion rotation = new Quaternion();

    public CylinderFactory2(int sideMaterialType, int topMaterialType, float radius, int dir) {
        this(sideMaterialType, topMaterialType, radius, radius / 0.5f, true, TextureType.RADIAL, dir);
    }

    public CylinderFactory2(int sideMaterialType, int topMaterialType, float radius, float height, Quaternion rotation) {
        this(sideMaterialType, topMaterialType, radius, radius / 0.5f, true, TextureType.RADIAL, height, rotation);
    }

    public CylinderFactory2(int sideMaterialType, int topMaterialType, float radius, float height, Quaternion rotation, Vector3f offset) {
        this(sideMaterialType, topMaterialType, radius, radius / 0.5f, true, TextureType.RADIAL, height, rotation, offset);
    }

    public CylinderFactory2(int sideMaterialType, int topMaterialType, float radius, float textureScale, boolean generateTangents, TextureType mapping, int dir) {
        this.sideMaterialType = sideMaterialType;
        this.topMaterialType = topMaterialType;
        this.radius = radius;
        this.textureScale = textureScale;
        this.generateTangents = generateTangents;
        this.mapping = mapping;
        this.dir = dir;
        switch (dir) {
            case 2: {
                this.rotation.fromAngles(0.0f, 0.0f, -0.7853982f);
                this.offset = new Vector3f(-radius, 0.0f, 0.0f);
                break;
            }
            case 3: {
                this.rotation.fromAngles(0.0f, 0.0f, 0.7853982f);
                this.offset = new Vector3f(radius, 0.0f, 0.0f);
                break;
            }
            case 1: {
                this.rotation.fromAngles(0.7853982f, 0.0f, 0.0f);
                this.offset = new Vector3f(0.0f, 0.0f, -radius);
                break;
            }
            case 0: {
                this.rotation.fromAngles(-0.7853982f, 0.0f, 0.0f);
                this.offset = new Vector3f(0.0f, 0.0f, radius);
            }
        }
    }

    public CylinderFactory2(int sideMaterialType, int topMaterialType, float radius, float textureScale, boolean generateTangents, TextureType mapping, float height, Quaternion rotation) {
        this(sideMaterialType, topMaterialType, radius, textureScale, generateTangents, mapping, height, rotation, new Vector3f(0.0f, 0.0f, 0.0f));
    }

    public CylinderFactory2(int sideMaterialType, int topMaterialType, float radius, float textureScale, boolean generateTangents, TextureType mapping, float height, Quaternion rotation, Vector3f offset) {
        this.sideMaterialType = sideMaterialType;
        this.topMaterialType = topMaterialType;
        this.radius = radius;
        this.textureScale = textureScale;
        this.generateTangents = generateTangents;
        this.mapping = mapping;
        this.dir = this.dir;
        this.rotation.set(rotation);
        this.height = height;
        this.offset = new Vector3f(offset.x, offset.z, offset.y);
    }

    public static float[] cosAndSin(float angle) {
        return new float[]{FastMath.cos((float)(-angle)), FastMath.sin((float)(-angle))};
    }

    @Override
    public boolean isSameShape(GeomFactory f) {
        if (f == this) {
            return true;
        }
        if (f == null || f.getClass() != this.getClass()) {
            return false;
        }
        CylinderFactory2 other = (CylinderFactory2)f;
        if (other.radius != this.radius) {
            return false;
        }
        if (other.dir != this.dir) {
            return false;
        }
        if (other.height != this.height) {
            return false;
        }
        if (!this.offset.equals((Object)other.offset)) {
            return false;
        }
        return this.rotation.equals((Object)other.rotation);
    }

    public float getRadius() {
        return this.radius;
    }

    public int getDir() {
        return this.dir;
    }

    public float getHeight() {
        return this.height;
    }

    public Vector3f getOffset() {
        return this.offset;
    }

    public Quaternion getRotation() {
        return this.rotation;
    }

    @Override
    public int createGeometry(GeomPartBuffer buffer, int x, int y, int z, int xWorld, int yWorld, int zWorld, float sun, float light, BlockType block, int dir) {
        return 0;
    }

    protected int createEndCaps(GeomPartBuffer buffer, int x, int y, int z, int xWorld, int yWorld, int zWorld, float sun, float light, BlockType block, int dir) {
        float xCenter = (float)x + 0.5f + this.offset.x;
        float yCenter = (float)z + 0.5f + this.offset.y;
        float zCenter = (float)y + 0.5f + this.offset.z;
        float ySurface = -this.height;
        float normalDir = -1.0f;
        if (dir == 4) {
            ySurface = this.height;
            normalDir = 1.0f;
        }
        GeomPart part = new GeomPart(this.topMaterialType, dir);
        part.setSun(sun);
        part.setLight(light);
        if (this.mapping != TextureType.RADIAL) {
            float[] coords = new float[24];
            float[] normals = new float[24];
            float[] tangents = new float[24];
            for (int i = 0; i < 8; ++i) {
                int v = i * 3;
                float[] radial = RADIALS[i];
                coords[v] = xCenter + radial[0] * this.radius;
                coords[v + 1] = ySurface;
                coords[v + 2] = zCenter + radial[1] * this.radius;
                normals[v] = 0.0f;
                normals[v + 1] = normalDir;
                normals[v + 2] = 0.0f;
                tangents[v] = normalDir;
                tangents[v + 1] = 0.0f;
                tangents[v + 2] = 0.0f;
            }
            part.setCoords(coords);
            part.setNormals(normals);
            part.setTangents(tangents);
            if (this.mapping == TextureType.DECAL_STRETCHED) {
                part.setTexCoords(1.0f, 0.5f, 1.0f, 1.0f, 0.5f, 1.0f, 0.0f, 1.0f, 0.0f, 0.5f, 0.0f, 0.0f, 0.5f, 0.0f, 1.0f, 0.0f);
            } else {
                float[] tc = new float[16];
                int index = 0;
                for (int i = 0; i < 8; ++i) {
                    tc[index++] = 0.5f + RADIALS[i][0] * 0.5f;
                    tc[index++] = 0.5f + RADIALS[i][1] * 0.5f;
                }
                part.setTexCoords(tc);
            }
            if (dir == 4) {
                part.setIndexes(1, 2, 3, 0, 1, 3, 0, 3, 4, 0, 4, 7, 7, 4, 5, 7, 5, 6);
            } else {
                part.setIndexes(1, 3, 2, 0, 3, 1, 0, 4, 3, 0, 7, 4, 7, 5, 4, 7, 6, 5);
            }
            buffer.add(part);
            return 1;
        }
        float[] coords = new float[30];
        float[] normals = new float[30];
        float[] tangents = new float[30];
        for (int i = 0; i < 9; ++i) {
            int v = i * 3;
            float[] radial = RADIALS[i];
            Vector3f coord = new Vector3f(radial[0] * this.radius, ySurface, radial[1] * this.radius);
            coord = this.rotation.mult(coord);
            coords[v] = xCenter + coord.x;
            coords[v + 1] = yCenter + coord.y;
            coords[v + 2] = zCenter + coord.z;
            Vector3f norm = new Vector3f(0.0f, normalDir, 0.0f);
            norm = this.rotation.mult(norm);
            normals[v] = norm.x;
            normals[v + 1] = norm.y;
            normals[v + 2] = norm.z;
            Vector3f tangent = new Vector3f(normalDir, 0.0f, 0.0f);
            tangent = this.rotation.mult(tangent);
            tangents[v] = tangent.x;
            tangents[v + 1] = tangent.y;
            tangents[v + 2] = tangent.z;
        }
        int v = 27;
        Vector3f coord = new Vector3f(0.0f, ySurface, 0.0f);
        coord = this.rotation.mult(coord);
        coords[v] = xCenter + coord.x;
        coords[v + 1] = yCenter + coord.y;
        coords[v + 2] = zCenter + coord.z;
        Vector3f norm = new Vector3f(0.0f, normalDir, 0.0f);
        norm = this.rotation.mult(norm);
        normals[v] = norm.x;
        normals[v + 1] = norm.y;
        normals[v + 2] = norm.z;
        Vector3f tangent = new Vector3f(normalDir, 0.0f, 0.0f);
        tangent = this.rotation.mult(tangent);
        tangents[v] = tangent.x;
        tangents[v + 1] = tangent.y;
        tangents[v + 2] = tangent.z;
        part.setCoords(coords);
        part.setNormals(normals);
        part.setTangents(tangents);
        part.setTexCoords(1.0f, 0.5f, 1.0f, 1.0f, 0.5f, 1.0f, 0.0f, 1.0f, 0.0f, 0.5f, 0.0f, 0.0f, 0.5f, 0.0f, 1.0f, 0.0f, 1.0f, 0.5f, 0.5f, 0.5f);
        if (dir == 4) {
            part.setIndexes(0, 1, 9, 1, 2, 9, 2, 3, 9, 3, 4, 9, 4, 5, 9, 5, 6, 9, 6, 7, 9, 7, 8, 9);
        } else {
            part.setIndexes(0, 9, 1, 1, 9, 2, 2, 9, 3, 3, 9, 4, 4, 9, 5, 5, 9, 6, 6, 9, 7, 7, 9, 8);
        }
        buffer.add(part);
        return 1;
    }

    @Override
    public int createInternalGeometry(GeomPartBuffer buffer, int x, int y, int z, int xWorld, int yWorld, int zWorld, float sun, float light, BlockType block) {
        this.createEndCaps(buffer, x, y, z, xWorld, yWorld, zWorld, sun, light, block, 4);
        this.createEndCaps(buffer, x, y, z, xWorld, yWorld, zWorld, sun, light, block, 5);
        float xCenter = (float)x + 0.5f + this.offset.x;
        float yCenter = (float)z + 0.5f + this.offset.y;
        float zCenter = (float)y + 0.5f + this.offset.z;
        float yBase = -this.height;
        float yTop = this.height;
        float[] coords = new float[RADIALS.length * 3 * 2];
        float[] normals = new float[RADIALS.length * 3 * 2];
        float[] tangents = new float[RADIALS.length * 3 * 2];
        float[] texCoords = new float[RADIALS.length * 2 * 2];
        short[] indexes = new short[(RADIALS.length - 1) * 3 * 2];
        int vIndex = 0;
        int tIndex = 0;
        int iIndex = 0;
        for (int i = 0; i < RADIALS.length; ++i) {
            float[] radial = i < RADIALS.length ? RADIALS[i] : RADIALS[0];
            float s = texCoord[i];
            Vector3f coord = new Vector3f(radial[0] * this.radius, yBase, radial[1] * this.radius);
            coord = this.rotation.mult(coord);
            coords[vIndex] = xCenter + coord.x;
            coords[vIndex + 1] = yCenter + coord.y;
            coords[vIndex + 2] = zCenter + coord.z;
            Vector3f norm = new Vector3f(radial[0], 0.0f, radial[1]);
            norm = this.rotation.mult(norm);
            normals[vIndex] = norm.x;
            normals[vIndex + 1] = norm.y;
            normals[vIndex + 2] = norm.z;
            Vector3f tangent = new Vector3f(radial[1], 0.0f, -radial[0]);
            tangent = this.rotation.mult(tangent);
            tangents[vIndex] = tangent.x;
            tangents[vIndex + 1] = tangent.y;
            tangents[vIndex + 2] = tangent.z;
            texCoords[tIndex] = s * this.textureScale;
            texCoords[tIndex + 1] = 0.0f;
            tIndex += 2;
            coord = new Vector3f(radial[0] * this.radius, yTop, radial[1] * this.radius);
            coord = this.rotation.mult(coord);
            coords[vIndex += 3] = xCenter + coord.x;
            coords[vIndex + 1] = yCenter + coord.y;
            coords[vIndex + 2] = zCenter + coord.z;
            normals[vIndex] = norm.x;
            normals[vIndex + 1] = norm.y;
            normals[vIndex + 2] = norm.z;
            tangents[vIndex] = tangent.x;
            tangents[vIndex + 1] = tangent.y;
            tangents[vIndex + 2] = tangent.z;
            texCoords[tIndex] = s * this.textureScale;
            texCoords[tIndex + 1] = 1.0f;
            vIndex += 3;
            tIndex += 2;
            if (i >= RADIALS.length - 1) continue;
            int baseVertex = i * 2;
            indexes[iIndex++] = (short)baseVertex;
            indexes[iIndex++] = (short)(baseVertex + 2);
            indexes[iIndex++] = (short)(baseVertex + 3);
            indexes[iIndex++] = (short)baseVertex;
            indexes[iIndex++] = (short)(baseVertex + 3);
            indexes[iIndex++] = (short)(baseVertex + 1);
        }
        GeomPart part = new GeomPart(this.sideMaterialType, 4);
        part.setSun(sun);
        part.setLight(light);
        part.setCoords(coords);
        part.setNormals(normals);
        part.setTangents(tangents);
        part.setTexCoords(texCoords);
        part.setIndexes(indexes);
        buffer.add(part);
        return 0;
    }

    @Override
    public boolean isSolid(int direction) {
        return false;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public boolean isBoundary(int direction) {
        return false;
    }

    @Override
    public BoundaryShape getBoundaryShape(int direction) {
        return ShapeIndex.NULL_SHAPE;
    }

    @Override
    public final float getTransparency(int axis) {
        return 0.0f;
    }

    @Override
    public Vector3f getMin() {
        return Vector3f.ZERO;
    }

    @Override
    public Vector3f getMax() {
        return Vector3f.UNIT_XYZ;
    }

    @Override
    public double getMassPortion() {
        double area = (double)(this.radius * this.radius) * Math.PI;
        return area * (double)(this.height * 2.0f);
    }

    private Vector3f toWorld(Vector3f origin, float x, float y, float z) {
        Vector3f result = this.rotation.mult(new Vector3f(x, z, y));
        result.x = origin.x + result.x;
        result.y = origin.z + result.y;
        result.z = origin.y + result.z;
        float temp = result.y;
        result.y = result.z;
        result.z = temp;
        return result;
    }

    @Override
    public boolean isClipped() {
        return true;
    }

    public static enum TextureType {
        DECAL,
        DECAL_STRETCHED,
        RADIAL;

    }
}

