/*
 * Decompiled with CFR 0.152.
 */
package mythruna.geom;

import com.jme3.math.Vector3f;
import mythruna.BlockType;
import mythruna.BoundaryShape;
import mythruna.geom.GeomPart;
import mythruna.geom.GeomPartBuffer;
import mythruna.geom.PartFactory;

public class DefaultPartFactory
implements PartFactory {
    private GeomPart[] templates;
    private BoundaryShape shape;
    private Vector3f min;
    private Vector3f max;

    public DefaultPartFactory(GeomPart ... templates) {
        this((BoundaryShape)null, templates);
    }

    public DefaultPartFactory(BoundaryShape shape, GeomPart ... templates) {
        this.templates = templates;
        this.shape = shape;
        this.min = new Vector3f(1.0f, 1.0f, 1.0f);
        this.max = new Vector3f(0.0f, 0.0f, 0.0f);
        for (GeomPart p : templates) {
            float[] coords = p.getCoords();
            for (int i = 0; i < coords.length; i += 3) {
                float x = coords[i] + 0.5f;
                float z = coords[i + 1] + 0.5f;
                float y = coords[i + 2] + 0.5f;
                Vector3f pos = new Vector3f(x, y, z);
                this.min.minLocal(pos);
                this.max.maxLocal(pos);
            }
        }
    }

    @Override
    public BoundaryShape getBoundaryShape() {
        return this.shape;
    }

    @Override
    public Vector3f getMin() {
        return this.min;
    }

    @Override
    public Vector3f getMax() {
        return this.max;
    }

    @Override
    public int addParts(GeomPartBuffer buffer, int x, int y, int z, int xWorld, int yWorld, int zWorld, float sun, float light, BlockType block, int dir) {
        float xCenter = (float)x + 0.5f;
        float yCenter = (float)y + 0.5f;
        float zCenter = (float)z + 0.5f;
        int count = 0;
        for (GeomPart t : this.templates) {
            GeomPart part = new GeomPart(t.getMaterialType(), t.getDirection());
            part.setSun(sun);
            part.setLight(light);
            float[] pos = (float[])t.getCoords().clone();
            int xIndex = 0;
            int yIndex = 1;
            for (int zIndex = 2; zIndex < pos.length; zIndex += 3) {
                int n = xIndex;
                pos[n] = pos[n] + xCenter;
                int n2 = yIndex;
                pos[n2] = pos[n2] + zCenter;
                int n3 = zIndex;
                pos[n3] = pos[n3] + yCenter;
                xIndex += 3;
                yIndex += 3;
            }
            part.setCoords(pos);
            if (t.getNormals() != null) {
                part.setNormals(t.getNormals());
            }
            if (t.getNormals() != null) {
                part.setNormals(t.getNormals());
            }
            if (t.getTangents() != null) {
                part.setTangents(t.getTangents());
            }
            if (t.getTexCoords() != null) {
                part.setTexCoords(t.getTexCoords());
            }
            if (t.getIndexes() != null) {
                part.setIndexes(t.getIndexes());
            }
            if (t.getColors() != null) {
                part.setColors(t.getColors());
            }
            if (t.getSizes() != null) {
                part.setSizes(t.getSizes());
            }
            buffer.add(part);
            ++count;
        }
        return count;
    }
}

