/*
 * Decompiled with CFR 0.152.
 */
package mythruna.geom;

import com.jme3.math.Vector3f;
import mythruna.BlockType;
import mythruna.BoundaryShape;
import mythruna.ShapeIndex;
import mythruna.geom.GeomFactory;
import mythruna.geom.GeomPart;
import mythruna.geom.GeomPartBuffer;

public class FlameFactory
implements GeomFactory {
    private int materialType;
    private int count = 1;
    private float height = 1.0f;
    private Vector3f min;
    private Vector3f max;

    public FlameFactory(int materialType) {
        this(materialType, 1.0f);
    }

    public FlameFactory(int materialType, float height) {
        this.materialType = materialType;
        this.height = height;
        float offset = height * 0.25f;
        this.min = new Vector3f(0.5f - offset, 0.5f - offset, 0.0f);
        this.max = new Vector3f(0.5f + offset, 0.5f + offset, height);
    }

    public FlameFactory(int materialType, int count) {
        this.materialType = materialType;
        this.count = count;
        this.min = new Vector3f(0.0f, 0.0f, 0.0f);
        this.max = new Vector3f(1.0f, 1.0f, 1.0f);
    }

    @Override
    public boolean isSameShape(GeomFactory f) {
        if (f == this) {
            return true;
        }
        return f != null && f.getClass() == this.getClass();
    }

    @Override
    public int createGeometry(GeomPartBuffer buffer, int x, int y, int z, int xWorld, int yWorld, int zWorld, float sun, float light, BlockType block, int dir) {
        return 0;
    }

    @Override
    public int createInternalGeometry(GeomPartBuffer buffer, int x, int y, int z, int xWorld, int yWorld, int zWorld, float sun, float light, BlockType block) {
        if (this.count <= 1) {
            GeomPart part = this.createFlame((float)x + 0.5f, (float)y + 0.5f, z, this.height);
            buffer.add(part);
            return 1;
        }
        for (int i = 0; i < this.count; ++i) {
            float xOffset = (float)buffer.nextRandom() - 0.5f;
            float yOffset = (float)buffer.nextRandom() - 0.5f;
            float scale = (float)buffer.nextRandom() * (0.5f * this.height) + 0.5f * this.height;
            GeomPart part = this.createFlame((float)x + 0.5f + xOffset, (float)y + 0.5f + yOffset, z, scale);
            buffer.add(part);
        }
        return this.count;
    }

    protected GeomPart createFlame(float x, float y, float z, float scale) {
        GeomPart part = new GeomPart(this.materialType, -1, 1);
        float[] pos = new float[12];
        float[] sizes = new float[12];
        float h = 0.25f;
        float delta = 0.15f;
        float s = 20.0f;
        for (int i = 0; i < pos.length; ++i) {
            pos[i] = h * scale;
            sizes[i] = s * scale;
            s *= 0.75f;
            h += delta;
            delta *= 0.75f;
        }
        part.setCoords(x, z + pos[11], y, x, z + pos[10], y, x, z + pos[9], y, x, z + pos[8], y, x, z + pos[7], y, x, z + pos[6], y, x, z + pos[5], y, x, z + pos[4], y, x, z + pos[3], y, x, z + pos[2], y, x, z + pos[1], y, x, z + pos[0], y);
        part.setSizes(sizes[11] * 1.1f, sizes[10], sizes[9], sizes[8], sizes[7], sizes[6], sizes[5], sizes[4], sizes[3], sizes[2], sizes[1], sizes[0]);
        boolean tapered = false;
        if (tapered) {
            part.setColors(1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.1f, 0.1f, 1.0f, 1.0f, 0.1f, 0.1f, 1.0f, 1.0f, 0.2f, 0.2f, 1.0f, 1.0f, 0.2f, 0.2f, 1.0f, 1.0f, 0.3f, 0.3f, 1.0f, 1.0f, 0.3f, 0.3f, 1.0f, 1.0f, 0.4f, 0.4f, 1.0f, 1.0f, 0.5f, 0.5f, 1.0f, 1.0f, 0.7f, 0.7f, 1.0f, 1.0f, 0.9f, 0.9f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            float red = 0.45f;
            float green = 0.6f;
            float blue = 0.45f;
            float alpha = 1.0f;
            part.setColors(red, 0.0f, 0.0f, alpha, red, green, blue, alpha, red, green, blue, alpha, red, green, blue, alpha, red, green, blue, alpha, red, green, blue, alpha, red, green, blue, alpha, red, green, blue, alpha, red, green, blue, alpha, red, green, blue, alpha, red, green, blue, alpha, red, green, blue, alpha);
        }
        part.setTexCoords(0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f);
        return part;
    }

    @Override
    public boolean isSolid(int direction) {
        return false;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public boolean isBoundary(int direction) {
        return false;
    }

    @Override
    public final float getTransparency(int axis) {
        return 1.0f;
    }

    @Override
    public BoundaryShape getBoundaryShape(int direction) {
        return ShapeIndex.NULL_SHAPE;
    }

    @Override
    public Vector3f getMin() {
        return this.min;
    }

    @Override
    public Vector3f getMax() {
        return this.max;
    }

    @Override
    public double getMassPortion() {
        return 0.0;
    }

    @Override
    public boolean isClipped() {
        return false;
    }
}

