/*
 * Decompiled with CFR 0.152.
 */
package mythruna.geom;

import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import mythruna.BlockType;
import mythruna.BoundaryShape;
import mythruna.ShapeIndex;
import mythruna.geom.CubeFactory;
import mythruna.geom.GeomFactory;
import mythruna.geom.GeomPart;
import mythruna.geom.GeomPartBuffer;

public class OuterCornerFactory
implements GeomFactory {
    private static final int SIDE_EMPTY = 0;
    private static final int SIDE_SOLID = 1;
    private static final int SIDE_TRI_LEFT = 2;
    private static final int SIDE_TRI_RIGHT = 3;
    private static final BoundaryShape TRI_UP = ShapeIndex.getTriangle(0.0f, 0.0f, 1.0f, 1.0f, -FastMath.sqrt((float)2.0f), FastMath.sqrt((float)2.0f));
    private static final BoundaryShape TRI_DOWN = ShapeIndex.getTriangle(0.0f, 0.0f, 1.0f, 1.0f, FastMath.sqrt((float)2.0f), FastMath.sqrt((float)2.0f));
    private static Vector3f[] baseVerts = new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 1.0f)};
    private static Vector3f[] baseNormals = new Vector3f[]{new Vector3f(1.0f, 1.0f, 0.0f).normalizeLocal(), new Vector3f(0.0f, 1.0f, -1.0f).normalizeLocal()};
    private static Vector3f[] baseTangents = new Vector3f[]{new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(-1.0f, 0.0f, 0.0f)};
    private Vector3f[] verts;
    private Vector3f[] normals;
    private Vector3f[] tangents;
    private int[] sides = new int[6];
    private int triLeftDir;
    private int triRightDir;
    private Quaternion rotation;
    private int type1;
    private int type2;
    private int topType1;
    private int topType2;
    private BoundaryShape[] shapes = new BoundaryShape[6];

    public OuterCornerFactory(int dir, int topType1, int topType2, int type1, int type2) {
        int i;
        this.type1 = type1;
        this.type2 = type2;
        this.topType1 = topType1;
        this.topType2 = topType2;
        for (int d = 0; d < this.shapes.length; ++d) {
            this.shapes[d] = ShapeIndex.NULL_SHAPE;
        }
        this.shapes[5] = CubeFactory.UNIT_SQUARE;
        switch (dir) {
            case 2: {
                this.triLeftDir = 1;
                this.triRightDir = 3;
                this.shapes[this.triLeftDir] = TRI_DOWN;
                this.shapes[this.triRightDir] = TRI_DOWN;
                break;
            }
            case 0: {
                this.triLeftDir = 2;
                this.triRightDir = 1;
                this.shapes[this.triLeftDir] = TRI_UP;
                this.shapes[this.triRightDir] = TRI_UP;
                break;
            }
            case 3: {
                this.triLeftDir = 0;
                this.triRightDir = 2;
                this.shapes[this.triLeftDir] = TRI_UP;
                this.shapes[this.triRightDir] = TRI_UP;
                break;
            }
            case 1: {
                this.triLeftDir = 3;
                this.triRightDir = 0;
                this.shapes[this.triLeftDir] = TRI_DOWN;
                this.shapes[this.triRightDir] = TRI_DOWN;
            }
        }
        this.rotation = new Quaternion();
        float xOffset = 0.0f;
        float zOffset = 0.0f;
        switch (dir) {
            default: {
                break;
            }
            case 3: {
                this.rotation.fromAngles(0.0f, (float)Math.PI, 0.0f);
                xOffset = 1.0f;
                zOffset = 1.0f;
                break;
            }
            case 0: {
                this.rotation.fromAngles(0.0f, 1.5707964f, 0.0f);
                zOffset = 1.0f;
                break;
            }
            case 1: {
                this.rotation.fromAngles(0.0f, 4.712389f, 0.0f);
                xOffset = 1.0f;
            }
        }
        this.verts = new Vector3f[baseVerts.length];
        for (i = 0; i < this.verts.length; ++i) {
            this.verts[i] = this.rotation.mult(baseVerts[i]);
            this.verts[i].x += xOffset;
            this.verts[i].z += zOffset;
        }
        this.normals = new Vector3f[baseNormals.length];
        for (i = 0; i < this.normals.length; ++i) {
            this.normals[i] = this.rotation.mult(baseNormals[i]);
        }
        this.tangents = new Vector3f[baseTangents.length];
        for (i = 0; i < this.tangents.length; ++i) {
            this.tangents[i] = this.rotation.mult(baseTangents[i]);
        }
        this.sides[5] = 1;
        this.sides[this.triLeftDir] = 2;
        this.sides[this.triRightDir] = 3;
    }

    @Override
    public boolean isSameShape(GeomFactory f) {
        if (f == this) {
            return true;
        }
        if (f == null || f.getClass() != this.getClass()) {
            return false;
        }
        OuterCornerFactory other = (OuterCornerFactory)f;
        return this.rotation.equals((Object)other.rotation);
    }

    @Override
    public int createGeometry(GeomPartBuffer buffer, int x, int y, int z, int xWorld, int yWorld, int zWorld, float sun, float light, BlockType block, int dir) {
        if (this.sides[dir] == 0) {
            return 0;
        }
        if (dir == 5) {
            GeomPart part = new GeomPart(this.type2, dir);
            part.setSun(sun);
            part.setLight(light);
            part.setCoords(this.verts[1].x + (float)x, this.verts[1].y + (float)z, this.verts[1].z + (float)y, this.verts[0].x + (float)x, this.verts[0].y + (float)z, this.verts[0].z + (float)y, this.verts[3].x + (float)x, this.verts[3].y + (float)z, this.verts[3].z + (float)y);
            part.setTexCoords(1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
            part.setIndexes(0, 1, 2);
            buffer.add(part);
            part = new GeomPart(this.type2, dir);
            part.setSun(sun);
            part.setLight(light);
            part.setCoords(this.verts[1].x + (float)x, this.verts[1].y + (float)z, this.verts[1].z + (float)y, this.verts[3].x + (float)x, this.verts[3].y + (float)z, this.verts[3].z + (float)y, this.verts[2].x + (float)x, this.verts[2].y + (float)z, this.verts[2].z + (float)y);
            part.setTexCoords(0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
            part.setIndexes(0, 1, 2);
            buffer.add(part);
            return 2;
        }
        if (dir == this.triLeftDir) {
            GeomPart part = new GeomPart(this.type1, dir);
            part.setSun(sun);
            part.setLight(light);
            part.setCoords(this.verts[1].x + (float)x, this.verts[1].y + (float)z, this.verts[1].z + (float)y, this.verts[2].x + (float)x, this.verts[2].y + (float)z, this.verts[2].z + (float)y, this.verts[4].x + (float)x, this.verts[4].y + (float)z, this.verts[4].z + (float)y);
            part.setTexCoords(0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f);
            part.setIndexes(0, 1, 2);
            buffer.add(part);
            return 1;
        }
        if (dir == this.triRightDir) {
            GeomPart part = new GeomPart(this.type2, dir);
            part.setSun(sun);
            part.setLight(light);
            part.setCoords(this.verts[1].x + (float)x, this.verts[1].y + (float)z, this.verts[1].z + (float)y, this.verts[0].x + (float)x, this.verts[0].y + (float)z, this.verts[0].z + (float)y, this.verts[4].x + (float)x, this.verts[4].y + (float)z, this.verts[4].z + (float)y);
            part.setTexCoords(0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f);
            part.setIndexes(0, 2, 1);
            buffer.add(part);
            return 1;
        }
        return 0;
    }

    @Override
    public int createInternalGeometry(GeomPartBuffer buffer, int x, int y, int z, int xWorld, int yWorld, int zWorld, float sun, float light, BlockType block) {
        GeomPart part = new GeomPart(this.topType2, -1);
        part.setSun(sun);
        part.setLight(light);
        part.setCoords(this.verts[4].x + (float)x, this.verts[4].y + (float)z, this.verts[4].z + (float)y, this.verts[3].x + (float)x, this.verts[3].y + (float)z, this.verts[3].z + (float)y, this.verts[0].x + (float)x, this.verts[0].y + (float)z, this.verts[0].z + (float)y);
        part.setNormals(this.normals[1].x, this.normals[1].y, this.normals[1].z, this.normals[1].x, this.normals[1].y, this.normals[1].z, this.normals[1].x, this.normals[1].y, this.normals[1].z);
        part.setTangents(this.tangents[1].x, this.tangents[1].y, this.tangents[1].z, this.tangents[1].x, this.tangents[1].y, this.tangents[1].z, this.tangents[1].x, this.tangents[1].y, this.tangents[1].z);
        part.setTexCoords(1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        part.setIndexes(0, 1, 2);
        buffer.add(part);
        part = new GeomPart(this.topType2, -1);
        part.setSun(sun);
        part.setLight(light);
        part.setCoords(this.verts[4].x + (float)x, this.verts[4].y + (float)z, this.verts[4].z + (float)y, this.verts[2].x + (float)x, this.verts[2].y + (float)z, this.verts[2].z + (float)y, this.verts[3].x + (float)x, this.verts[3].y + (float)z, this.verts[3].z + (float)y);
        part.setNormals(this.normals[0].x, this.normals[0].y, this.normals[0].z, this.normals[0].x, this.normals[0].y, this.normals[0].z, this.normals[0].x, this.normals[0].y, this.normals[0].z);
        part.setTangents(this.tangents[0].x, this.tangents[0].y, this.tangents[0].z, this.tangents[0].x, this.tangents[0].y, this.tangents[0].z, this.tangents[0].x, this.tangents[0].y, this.tangents[0].z);
        part.setTexCoords(0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        part.setIndexes(0, 1, 2);
        buffer.add(part);
        return 0;
    }

    @Override
    public boolean isSolid(int direction) {
        return this.sides[direction] == 1;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public boolean isBoundary(int direction) {
        return this.sides[direction] != 0;
    }

    @Override
    public BoundaryShape getBoundaryShape(int direction) {
        return this.shapes[direction];
    }

    @Override
    public final float getTransparency(int axis) {
        return 0.0f;
    }

    @Override
    public Vector3f getMin() {
        return Vector3f.ZERO;
    }

    @Override
    public Vector3f getMax() {
        return CubeFactory.UNIT_CUBE;
    }

    @Override
    public double getMassPortion() {
        double x = this.getMax().x - this.getMin().x;
        double y = this.getMax().y - this.getMin().y;
        double z = this.getMax().z - this.getMin().z;
        return x * y * z * 0.5;
    }

    @Override
    public boolean isClipped() {
        return true;
    }
}

