/*
 * Decompiled with CFR 0.152.
 */
package mythruna.geom;

import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import mythruna.BlockType;
import mythruna.BoundaryShape;
import mythruna.ShapeIndex;
import mythruna.geom.GeomFactory;
import mythruna.geom.GeomPart;
import mythruna.geom.GeomPartBuffer;

public class PineTopFactory
implements GeomFactory {
    private static Vector3f min = new Vector3f(0.25f, 0.25f, 0.0f);
    private static Vector3f max = new Vector3f(0.75f, 0.75f, 1.0f);
    private static float TIP = -0.3f;
    private static float T_OFFSET = 0.3f;
    private static float BRANCH_OFFSET = 0.04f;
    private static float TOP_SCALE = 1.3f;
    private static float BRANCH_LENGTH = (1.7f + -TIP + 0.5f + 0.5f + 0.25f + 0.2f) * TOP_SCALE;
    private static float BRANCH_WIDTH = (1.0f + T_OFFSET) * TOP_SCALE;
    private static float NEEDLE_OFFSET = BRANCH_WIDTH * TOP_SCALE;
    private static Vector3f[] baseVerts = new Vector3f[]{new Vector3f(0.0f, 0.0f, BRANCH_OFFSET), new Vector3f(BRANCH_WIDTH, 0.0f, -NEEDLE_OFFSET), new Vector3f(0.0f, BRANCH_LENGTH, 0.0f), new Vector3f(-BRANCH_WIDTH, 0.0f, -NEEDLE_OFFSET), new Vector3f(0.0f, 0.0f, BRANCH_OFFSET), new Vector3f(0.0f, BRANCH_LENGTH, 0.0f), new Vector3f(0.0f, 0.0f, -BRANCH_OFFSET), new Vector3f(BRANCH_WIDTH, 0.0f, NEEDLE_OFFSET), new Vector3f(0.0f, BRANCH_LENGTH, 0.0f), new Vector3f(-BRANCH_WIDTH, 0.0f, NEEDLE_OFFSET), new Vector3f(0.0f, 0.0f, -BRANCH_OFFSET), new Vector3f(0.0f, BRANCH_LENGTH, 0.0f)};
    private static Vector3f[] baseNorms = new Vector3f[]{new Vector3f(0.0f, 0.0f, 1.0f).normalizeLocal(), new Vector3f(1.0f, 0.0f, -1.0f).normalizeLocal(), new Vector3f(0.0f, 1.0f, 0.0f).normalizeLocal(), new Vector3f(-1.0f, 0.0f, -1.0f).normalizeLocal(), new Vector3f(0.0f, 0.0f, 1.0f).normalizeLocal(), new Vector3f(0.0f, 1.0f, 0.0f).normalizeLocal(), new Vector3f(0.0f, 0.0f, -1.0f).normalizeLocal(), new Vector3f(1.0f, 0.0f, 1.0f).normalizeLocal(), new Vector3f(0.0f, 1.0f, 0.0f).normalizeLocal(), new Vector3f(-1.0f, 0.0f, 1.0f).normalizeLocal(), new Vector3f(0.0f, 0.0f, -1.0f).normalizeLocal(), new Vector3f(0.0f, 1.0f, 0.0f).normalizeLocal()};
    private static float[] texCoords = new float[]{0.5f, 1.0f, 1.0f + T_OFFSET, 1.0f, 0.5f, TIP, 0.0f - T_OFFSET, 1.0f, 0.5f, 1.0f, 0.5f, TIP, 0.5f, 1.0f, 1.0f + T_OFFSET, 1.0f, 0.5f, TIP, 0.0f - T_OFFSET, 1.0f, 0.5f, 1.0f, 0.5f, TIP};
    private static short[] indexes = new short[]{0, 2, 1, 3, 5, 4, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 8, 7, 9, 11, 10};
    private static float radius = 0.25f;
    private static float coneHeight = 2.25f;
    private static float cos45 = FastMath.cos((float)0.7853982f);
    private static float sin45 = FastMath.sin((float)0.7853982f);
    private static Vector3f[] cylNorms = new Vector3f[]{new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(cos45, 0.0f, -sin45), new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(-cos45, 0.0f, -sin45), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(-cos45, 0.0f, sin45), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(cos45, 0.0f, sin45), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(cos45, 0.0f, -sin45), new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(-cos45, 0.0f, -sin45), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(-cos45, 0.0f, sin45), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(cos45, 0.0f, sin45), new Vector3f(1.0f, 0.0f, 0.0f)};
    private static Vector3f[] cylTans = new Vector3f[]{new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(-sin45, 0.0f, -cos45), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(-sin45, 0.0f, cos45), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(sin45, 0.0f, cos45), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(sin45, 0.0f, -cos45), new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(-sin45, 0.0f, -cos45), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(-sin45, 0.0f, cos45), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(sin45, 0.0f, cos45), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(sin45, 0.0f, -cos45), new Vector3f(0.0f, 0.0f, -1.0f)};
    private static Vector3f[] cylVerts = new Vector3f[]{cylNorms[0].mult(radius), cylNorms[1].mult(radius), cylNorms[2].mult(radius), cylNorms[3].mult(radius), cylNorms[4].mult(radius), cylNorms[5].mult(radius), cylNorms[6].mult(radius), cylNorms[7].mult(radius), cylNorms[8].mult(radius), new Vector3f(0.0f, coneHeight, 0.0f), new Vector3f(0.0f, coneHeight, 0.0f), new Vector3f(0.0f, coneHeight, 0.0f), new Vector3f(0.0f, coneHeight, 0.0f), new Vector3f(0.0f, coneHeight, 0.0f), new Vector3f(0.0f, coneHeight, 0.0f), new Vector3f(0.0f, coneHeight, 0.0f), new Vector3f(0.0f, coneHeight, 0.0f)};
    private static float[] cylTex = new float[]{0.0f, 0.0f, 0.5f, 0.0f, 1.0f, 0.0f, 1.5f, 0.0f, 2.0f, 0.0f, 2.5f, 0.0f, 3.0f, 0.0f, 3.5f, 0.0f, 4.0f, 0.0f, 0.25f, 3.0f, 0.75f, 3.0f, 1.25f, 3.0f, 1.75f, 3.0f, 2.25f, 3.0f, 2.75f, 3.0f, 3.25f, 3.0f, 3.75f, 3.0f};
    private static short[] cylIndex = new short[]{0, 1, 9, 1, 2, 10, 2, 3, 11, 3, 4, 12, 4, 5, 13, 5, 6, 14, 6, 7, 15, 7, 8, 16};
    private int trunk;
    private int branch;
    private Quaternion rotate;

    public PineTopFactory(int trunkMaterial, int branchMaterial) {
        this.trunk = trunkMaterial;
        this.branch = branchMaterial;
    }

    @Override
    public int createGeometry(GeomPartBuffer buffer, int x, int y, int z, int xWorld, int yWorld, int zWorld, float sun, float light, BlockType block, int dir) {
        return 0;
    }

    @Override
    public boolean isSameShape(GeomFactory f) {
        if (f == this) {
            return true;
        }
        return f != null && f.getClass() == this.getClass();
    }

    @Override
    public int createInternalGeometry(GeomPartBuffer buffer, int x, int y, int z, int xWorld, int yWorld, int zWorld, float sun, float light, BlockType block) {
        float baseYaw;
        float xCenter = (float)x + 0.5f;
        float zCenter = (float)y + 0.5f;
        float yBase = (float)z - 0.25f;
        GeomPart part = new GeomPart(this.trunk, -1);
        part.setSun(sun);
        part.setLight(light);
        part.setCoords(xCenter + PineTopFactory.cylVerts[0].x, (float)z + PineTopFactory.cylVerts[0].y, zCenter + PineTopFactory.cylVerts[0].z, xCenter + PineTopFactory.cylVerts[1].x, (float)z + PineTopFactory.cylVerts[1].y, zCenter + PineTopFactory.cylVerts[1].z, xCenter + PineTopFactory.cylVerts[2].x, (float)z + PineTopFactory.cylVerts[2].y, zCenter + PineTopFactory.cylVerts[2].z, xCenter + PineTopFactory.cylVerts[3].x, (float)z + PineTopFactory.cylVerts[3].y, zCenter + PineTopFactory.cylVerts[3].z, xCenter + PineTopFactory.cylVerts[4].x, (float)z + PineTopFactory.cylVerts[4].y, zCenter + PineTopFactory.cylVerts[4].z, xCenter + PineTopFactory.cylVerts[5].x, (float)z + PineTopFactory.cylVerts[5].y, zCenter + PineTopFactory.cylVerts[5].z, xCenter + PineTopFactory.cylVerts[6].x, (float)z + PineTopFactory.cylVerts[6].y, zCenter + PineTopFactory.cylVerts[6].z, xCenter + PineTopFactory.cylVerts[7].x, (float)z + PineTopFactory.cylVerts[7].y, zCenter + PineTopFactory.cylVerts[7].z, xCenter + PineTopFactory.cylVerts[8].x, (float)z + PineTopFactory.cylVerts[8].y, zCenter + PineTopFactory.cylVerts[8].z, xCenter + PineTopFactory.cylVerts[9].x, (float)z + PineTopFactory.cylVerts[9].y, zCenter + PineTopFactory.cylVerts[9].z, xCenter + PineTopFactory.cylVerts[10].x, (float)z + PineTopFactory.cylVerts[10].y, zCenter + PineTopFactory.cylVerts[10].z, xCenter + PineTopFactory.cylVerts[11].x, (float)z + PineTopFactory.cylVerts[11].y, zCenter + PineTopFactory.cylVerts[11].z, xCenter + PineTopFactory.cylVerts[12].x, (float)z + PineTopFactory.cylVerts[12].y, zCenter + PineTopFactory.cylVerts[12].z, xCenter + PineTopFactory.cylVerts[13].x, (float)z + PineTopFactory.cylVerts[13].y, zCenter + PineTopFactory.cylVerts[13].z, xCenter + PineTopFactory.cylVerts[14].x, (float)z + PineTopFactory.cylVerts[14].y, zCenter + PineTopFactory.cylVerts[14].z, xCenter + PineTopFactory.cylVerts[15].x, (float)z + PineTopFactory.cylVerts[15].y, zCenter + PineTopFactory.cylVerts[15].z, xCenter + PineTopFactory.cylVerts[16].x, (float)z + PineTopFactory.cylVerts[16].y, zCenter + PineTopFactory.cylVerts[16].z);
        part.setNormals(PineTopFactory.cylNorms[0].x, PineTopFactory.cylNorms[0].y, PineTopFactory.cylNorms[0].z, PineTopFactory.cylNorms[1].x, PineTopFactory.cylNorms[1].y, PineTopFactory.cylNorms[1].z, PineTopFactory.cylNorms[2].x, PineTopFactory.cylNorms[2].y, PineTopFactory.cylNorms[2].z, PineTopFactory.cylNorms[3].x, PineTopFactory.cylNorms[3].y, PineTopFactory.cylNorms[3].z, PineTopFactory.cylNorms[4].x, PineTopFactory.cylNorms[4].y, PineTopFactory.cylNorms[4].z, PineTopFactory.cylNorms[5].x, PineTopFactory.cylNorms[5].y, PineTopFactory.cylNorms[5].z, PineTopFactory.cylNorms[6].x, PineTopFactory.cylNorms[6].y, PineTopFactory.cylNorms[6].z, PineTopFactory.cylNorms[7].x, PineTopFactory.cylNorms[7].y, PineTopFactory.cylNorms[7].z, PineTopFactory.cylNorms[8].x, PineTopFactory.cylNorms[8].y, PineTopFactory.cylNorms[8].z, PineTopFactory.cylNorms[9].x, PineTopFactory.cylNorms[9].y, PineTopFactory.cylNorms[9].z, PineTopFactory.cylNorms[10].x, PineTopFactory.cylNorms[10].y, PineTopFactory.cylNorms[10].z, PineTopFactory.cylNorms[11].x, PineTopFactory.cylNorms[11].y, PineTopFactory.cylNorms[11].z, PineTopFactory.cylNorms[12].x, PineTopFactory.cylNorms[12].y, PineTopFactory.cylNorms[12].z, PineTopFactory.cylNorms[13].x, PineTopFactory.cylNorms[13].y, PineTopFactory.cylNorms[13].z, PineTopFactory.cylNorms[14].x, PineTopFactory.cylNorms[14].y, PineTopFactory.cylNorms[14].z, PineTopFactory.cylNorms[15].x, PineTopFactory.cylNorms[15].y, PineTopFactory.cylNorms[15].z, PineTopFactory.cylNorms[16].x, PineTopFactory.cylNorms[16].y, PineTopFactory.cylNorms[16].z);
        part.setTangents(PineTopFactory.cylTans[0].x, PineTopFactory.cylTans[0].y, PineTopFactory.cylTans[0].z, PineTopFactory.cylTans[1].x, PineTopFactory.cylTans[1].y, PineTopFactory.cylTans[1].z, PineTopFactory.cylTans[2].x, PineTopFactory.cylTans[2].y, PineTopFactory.cylTans[2].z, PineTopFactory.cylTans[3].x, PineTopFactory.cylTans[3].y, PineTopFactory.cylTans[3].z, PineTopFactory.cylTans[4].x, PineTopFactory.cylTans[4].y, PineTopFactory.cylTans[4].z, PineTopFactory.cylTans[5].x, PineTopFactory.cylTans[5].y, PineTopFactory.cylTans[5].z, PineTopFactory.cylTans[6].x, PineTopFactory.cylTans[6].y, PineTopFactory.cylTans[6].z, PineTopFactory.cylTans[7].x, PineTopFactory.cylTans[7].y, PineTopFactory.cylTans[7].z, PineTopFactory.cylTans[8].x, PineTopFactory.cylTans[8].y, PineTopFactory.cylTans[8].z, PineTopFactory.cylTans[9].x, PineTopFactory.cylTans[9].y, PineTopFactory.cylTans[9].z, PineTopFactory.cylTans[10].x, PineTopFactory.cylTans[10].y, PineTopFactory.cylTans[10].z, PineTopFactory.cylTans[11].x, PineTopFactory.cylTans[11].y, PineTopFactory.cylTans[11].z, PineTopFactory.cylTans[12].x, PineTopFactory.cylTans[12].y, PineTopFactory.cylTans[12].z, PineTopFactory.cylTans[13].x, PineTopFactory.cylTans[13].y, PineTopFactory.cylTans[13].z, PineTopFactory.cylTans[14].x, PineTopFactory.cylTans[14].y, PineTopFactory.cylTans[14].z, PineTopFactory.cylTans[15].x, PineTopFactory.cylTans[15].y, PineTopFactory.cylTans[15].z, PineTopFactory.cylTans[16].x, PineTopFactory.cylTans[16].y, PineTopFactory.cylTans[16].z);
        part.setTexCoords(cylTex);
        part.setIndexes(cylIndex);
        buffer.add(part);
        float a = baseYaw = 0.0f;
        Quaternion q = new Quaternion().fromAngles(0.0f, a, 0.0f);
        Vector3f[] verts = new Vector3f[baseVerts.length];
        Vector3f[] norms = new Vector3f[baseNorms.length];
        for (int i = 0; i < verts.length; ++i) {
            verts[i] = q.mult(baseVerts[i]);
            norms[i] = q.mult(baseNorms[i]);
        }
        part = new GeomPart(this.branch, -1);
        part.setSun(sun);
        part.setLight(light);
        part.setCoords(verts[0].x + xCenter, verts[0].y + yBase, verts[0].z + zCenter, verts[1].x + xCenter, verts[1].y + yBase, verts[1].z + zCenter, verts[2].x + xCenter, verts[2].y + yBase, verts[2].z + zCenter, verts[3].x + xCenter, verts[3].y + yBase, verts[3].z + zCenter, verts[4].x + xCenter, verts[4].y + yBase, verts[4].z + zCenter, verts[5].x + xCenter, verts[5].y + yBase, verts[5].z + zCenter, verts[6].x + xCenter, verts[6].y + yBase, verts[6].z + zCenter, verts[7].x + xCenter, verts[7].y + yBase, verts[7].z + zCenter, verts[8].x + xCenter, verts[8].y + yBase, verts[8].z + zCenter, verts[9].x + xCenter, verts[9].y + yBase, verts[9].z + zCenter, verts[10].x + xCenter, verts[10].y + yBase, verts[10].z + zCenter, verts[11].x + xCenter, verts[11].y + yBase, verts[11].z + zCenter);
        part.setNormals(norms[0].x, norms[0].y, norms[0].z, norms[1].x, norms[1].y, norms[1].z, norms[2].x, norms[2].y, norms[2].z, norms[3].x, norms[3].y, norms[3].z, norms[4].x, norms[4].y, norms[4].z, norms[5].x, norms[5].y, norms[5].z, norms[6].x, norms[6].y, norms[6].z, norms[7].x, norms[7].y, norms[7].z, norms[8].x, norms[8].y, norms[8].z, norms[9].x, norms[9].y, norms[9].z, norms[10].x, norms[10].y, norms[10].z, norms[11].x, norms[11].y, norms[11].z);
        part.setTexCoords(texCoords);
        part.setIndexes(indexes);
        buffer.add(part);
        return 2;
    }

    @Override
    public boolean isSolid(int direction) {
        return true;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public boolean isBoundary(int direction) {
        return false;
    }

    @Override
    public BoundaryShape getBoundaryShape(int direction) {
        return ShapeIndex.NULL_SHAPE;
    }

    @Override
    public final float getTransparency(int axis) {
        return 0.75f;
    }

    @Override
    public double getMassPortion() {
        double x = this.getMax().x - this.getMin().x;
        double y = this.getMax().y - this.getMin().y;
        double z = this.getMax().z - this.getMin().z;
        return x * y * z * 0.125;
    }

    @Override
    public Vector3f getMin() {
        return min;
    }

    @Override
    public Vector3f getMax() {
        return max;
    }

    @Override
    public boolean isClipped() {
        return true;
    }
}

