/*
 * Decompiled with CFR 0.152.
 */
package mythruna.geom;

import com.jme3.math.Vector3f;
import mythruna.BlockType;
import mythruna.BoundaryShape;
import mythruna.ShapeIndex;
import mythruna.geom.GeomFactory;
import mythruna.geom.GeomPart;
import mythruna.geom.GeomPartBuffer;

public class StaticParticleFactory
implements GeomFactory {
    private int materialType;
    private int count = 1;
    private Vector3f min;
    private Vector3f max;
    private GeomFactory delegate;
    private int[] counts = new int[4];
    private float[] heights = new float[4];

    public StaticParticleFactory(int materialType) {
        this(materialType, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f), null, 2, 3, 3, 3);
    }

    public StaticParticleFactory(int materialType, Vector3f min, Vector3f max, GeomFactory delegate, int ... counts) {
        this.materialType = materialType;
        this.min = min;
        this.max = max;
        this.delegate = delegate;
        this.count = 0;
        for (int i = 0; i < counts.length; ++i) {
            this.counts[i] = counts[i];
            this.heights[i] = 1.0f;
            this.count += counts[i];
        }
    }

    public StaticParticleFactory setHeight(int type, float height) {
        this.heights[type] = height;
        return this;
    }

    @Override
    public boolean isSameShape(GeomFactory f) {
        if (f == this) {
            return true;
        }
        if (f == null || f.getClass() != this.getClass()) {
            return false;
        }
        StaticParticleFactory other = (StaticParticleFactory)f;
        if (!this.min.equals((Object)other.min)) {
            return false;
        }
        return this.max.equals((Object)other.max);
    }

    @Override
    public int createGeometry(GeomPartBuffer buffer, int x, int y, int z, int xWorld, int yWorld, int zWorld, float sun, float light, BlockType block, int dir) {
        if (this.delegate != null) {
            return this.delegate.createGeometry(buffer, x, y, z, xWorld, yWorld, zWorld, sun, light, block, dir);
        }
        return 0;
    }

    private float range(double s, float min, float max) {
        return (float)((double)min + s * (double)(max - min));
    }

    private float range(double s, float min, float max, float scale) {
        return (float)((double)min + s * (double)(max - min) * (double)scale);
    }

    @Override
    public int createInternalGeometry(GeomPartBuffer buffer, int x, int y, int z, int xWorld, int yWorld, int zWorld, float sun, float light, BlockType block) {
        if (this.delegate != null) {
            this.delegate.createInternalGeometry(buffer, x, y, z, xWorld, yWorld, zWorld, sun, light, block);
        }
        float[] pos = new float[this.count * 3];
        float[] sizes = new float[this.count];
        float[] colors = new float[this.count * 4];
        float[] texes = new float[this.count * 4];
        int base3 = 0;
        int base4 = 0;
        int index = 0;
        for (int type = 0; type < 4; ++type) {
            int localCount = this.counts[type];
            for (int i = 0; i < localCount; ++i) {
                float xOffset = this.range(buffer.nextRandom(), this.min.x, this.max.x);
                float yOffset = this.range(buffer.nextRandom(), this.min.y, this.max.y);
                float zOffset = this.range(buffer.nextRandom(), this.min.z, this.max.z, this.heights[type]);
                pos[base3] = (float)x + xOffset;
                pos[base3 + 1] = (float)z + zOffset;
                pos[base3 + 2] = (float)y + yOffset;
                sizes[index] = 5.0f;
                colors[base4] = light;
                colors[base4 + 1] = 1.0f;
                colors[base4 + 2] = 1.0f;
                colors[base4 + 3] = sun;
                int s = (int)(buffer.nextRandom() * 4.0);
                int t = type;
                texes[base4] = (float)s * 0.25f;
                texes[base4 + 1] = (float)t * 0.25f + 0.24f;
                texes[base4 + 2] = (float)s * 0.25f + 0.24f;
                texes[base4 + 3] = (float)t * 0.25f;
                ++index;
                base3 += 3;
                base4 += 4;
            }
        }
        GeomPart part = new GeomPart(this.materialType, -1, 1);
        part.setCoords(pos);
        part.setSizes(sizes);
        part.setColors(colors);
        part.setTexCoords(texes);
        buffer.add(part);
        return 1;
    }

    @Override
    public boolean isSolid(int direction) {
        return false;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public boolean isBoundary(int direction) {
        return false;
    }

    @Override
    public final float getTransparency(int axis) {
        return 1.0f;
    }

    @Override
    public BoundaryShape getBoundaryShape(int direction) {
        return ShapeIndex.NULL_SHAPE;
    }

    @Override
    public Vector3f getMin() {
        return this.min;
    }

    @Override
    public Vector3f getMax() {
        return this.max;
    }

    @Override
    public double getMassPortion() {
        return 0.0;
    }

    @Override
    public boolean isClipped() {
        return false;
    }
}

