/*
 * Decompiled with CFR 0.152.
 */
package mythruna.geom;

import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import mythruna.BlockType;
import mythruna.BoundaryShape;
import mythruna.Direction;
import mythruna.ShapeIndex;
import mythruna.geom.CubeFactory;
import mythruna.geom.GeomFactory;
import mythruna.geom.GeomPart;
import mythruna.geom.GeomPartBuffer;

public class WedgeFactory
implements GeomFactory {
    private static final int SIDE_EMPTY = 0;
    private static final int SIDE_SOLID = 1;
    private static final int SIDE_TRI_LEFT = 2;
    private static final int SIDE_TRI_RIGHT = 3;
    private static final BoundaryShape TRI_UP = ShapeIndex.getTriangle(0.0f, 0.0f, 1.0f, 1.0f, -FastMath.sqrt((float)2.0f), FastMath.sqrt((float)2.0f));
    private static final BoundaryShape TRI_DOWN = ShapeIndex.getTriangle(0.0f, 0.0f, 1.0f, 1.0f, FastMath.sqrt((float)2.0f), FastMath.sqrt((float)2.0f));
    private static final BoundaryShape TRI_UP_INV = ShapeIndex.getTriangle(0.0f, 0.0f, 1.0f, 1.0f, FastMath.sqrt((float)2.0f), -FastMath.sqrt((float)2.0f));
    private static final BoundaryShape TRI_DOWN_INV = ShapeIndex.getTriangle(0.0f, 0.0f, 1.0f, 1.0f, -FastMath.sqrt((float)2.0f), -FastMath.sqrt((float)2.0f));
    private int[] types = new int[6];
    private int[] sides = new int[6];
    private BoundaryShape[] shapes = new BoundaryShape[6];
    private int solidDir;
    private boolean facingUp;
    private boolean flipTexture = false;
    private CubeFactory solid;

    public WedgeFactory(int solidSideXY, int solidSideZ, int materialType) {
        this.solid = new CubeFactory(materialType);
        this.solidDir = solidSideXY;
        this.sides[solidSideXY] = 1;
        this.sides[solidSideZ] = 1;
        this.sides[Direction.LEFT[solidSideXY]] = 2;
        this.sides[Direction.INVERSE[Direction.LEFT[solidSideXY]]] = 3;
        this.facingUp = solidSideZ == 5;
        for (int i = 0; i < this.types.length; ++i) {
            this.types[i] = materialType;
            this.shapes[i] = ShapeIndex.NULL_SHAPE;
        }
        this.shapes[solidSideXY] = CubeFactory.UNIT_SQUARE;
        this.shapes[solidSideZ] = CubeFactory.UNIT_SQUARE;
        switch (solidSideXY) {
            case 0: {
                if (solidSideZ == 5) {
                    this.shapes[2] = TRI_DOWN;
                    this.shapes[3] = TRI_DOWN;
                    break;
                }
                this.shapes[2] = TRI_UP_INV;
                this.shapes[3] = TRI_UP_INV;
                break;
            }
            case 1: {
                if (solidSideZ == 5) {
                    this.shapes[2] = TRI_UP;
                    this.shapes[3] = TRI_UP;
                    break;
                }
                this.shapes[2] = TRI_DOWN_INV;
                this.shapes[3] = TRI_DOWN_INV;
                break;
            }
            case 2: {
                if (solidSideZ == 5) {
                    this.shapes[0] = TRI_UP;
                    this.shapes[1] = TRI_UP;
                    break;
                }
                this.shapes[0] = TRI_DOWN_INV;
                this.shapes[1] = TRI_DOWN_INV;
                break;
            }
            case 3: {
                if (solidSideZ == 5) {
                    this.shapes[0] = TRI_DOWN;
                    this.shapes[1] = TRI_DOWN;
                    break;
                }
                this.shapes[0] = TRI_UP_INV;
                this.shapes[1] = TRI_UP_INV;
            }
        }
    }

    public WedgeFactory(int solidSideXY, int solidSideZ, int sideType, int topType, int bottomType) {
        this(solidSideXY, solidSideZ, sideType, topType, bottomType, false);
    }

    public WedgeFactory(int solidSideXY, int solidSideZ, int sideType, int topType, int bottomType, boolean yFlip) {
        this(solidSideXY, solidSideZ, sideType);
        this.types[4] = topType;
        this.types[5] = bottomType;
        this.solid = new CubeFactory(sideType, topType, bottomType);
        this.flipTexture = yFlip;
    }

    @Override
    public boolean isSameShape(GeomFactory f) {
        if (f == this) {
            return true;
        }
        if (f == null || f.getClass() != this.getClass()) {
            return false;
        }
        WedgeFactory other = (WedgeFactory)f;
        if (other.facingUp != this.facingUp) {
            return false;
        }
        return other.solidDir == this.solidDir;
    }

    public int getSolidDir() {
        return this.solidDir;
    }

    public boolean isFacingUp() {
        return this.facingUp;
    }

    @Override
    public int createGeometry(GeomPartBuffer buffer, int x, int y, int z, int xWorld, int yWorld, int zWorld, float sun, float light, BlockType block, int dir) {
        if (this.sides[dir] == 1) {
            return this.solid.createGeometry(buffer, x, y, z, xWorld, yWorld, zWorld, sun, light, block, dir);
        }
        if (dir == 5 || dir == 4) {
            return 0;
        }
        if (this.sides[dir] == 0) {
            return 0;
        }
        boolean up = this.sides[4] != 1;
        GeomPart part = new GeomPart(this.types[dir], dir);
        part.setSun(sun);
        part.setLight(light);
        float x1 = 0.0f;
        float x2 = 1.0f;
        float yPoint = up ? 0.0f : 1.0f;
        float z1 = 0.0f;
        float z2 = 0.0f;
        float n1 = 0.0f;
        float n2 = 0.0f;
        switch (dir) {
            case 0: {
                x1 = 1.0f;
                x2 = 0.0f;
                n1 = 0.0f;
                n2 = -1.0f;
                break;
            }
            case 1: {
                x1 = 0.0f;
                x2 = 1.0f;
                z1 = 1.0f;
                z2 = 1.0f;
                n1 = 0.0f;
                n2 = 1.0f;
                break;
            }
            case 2: {
                x1 = 1.0f;
                x2 = 1.0f;
                z1 = 1.0f;
                z2 = 0.0f;
                n1 = 1.0f;
                n2 = 0.0f;
                break;
            }
            case 3: {
                x1 = 0.0f;
                x2 = 0.0f;
                z1 = 0.0f;
                z2 = 1.0f;
                n1 = -1.0f;
                n2 = 0.0f;
            }
        }
        if (this.sides[dir] == 2) {
            part.setCoords((float)x + x1, z, (float)y + z1, (float)x + x2, (float)z + yPoint, (float)y + z2, (float)x + x1, z + 1, (float)y + z1);
            part.setTexCoords(0.0f, 0.0f, 1.0f, 1.0f - yPoint, 0.0f, 1.0f);
        } else if (this.sides[dir] == 3) {
            part.setCoords((float)x + x1, (float)z + yPoint, (float)y + z1, (float)x + x2, z, (float)y + z2, (float)x + x2, z + 1, (float)y + z2);
            part.setTexCoords(0.0f, 1.0f - yPoint, 1.0f, 0.0f, 1.0f, 1.0f);
        }
        float[] tangents = Direction.TANGENTS[dir];
        part.setIndexes(0, 1, 2);
        buffer.add(part);
        return 1;
    }

    @Override
    public int createInternalGeometry(GeomPartBuffer buffer, int x, int y, int z, int xWorld, int yWorld, int zWorld, float sun, float light, BlockType block) {
        boolean up = this.sides[4] != 1;
        int type = this.types[up ? 4 : 5];
        GeomPart part = new GeomPart(type, -1);
        part.setSun(sun);
        part.setLight(light);
        float y1 = 0.0f;
        float y2 = 0.0f;
        float y3 = 0.0f;
        float y4 = 0.0f;
        float n = FastMath.cos((float)0.7853982f);
        float nx = 0.0f;
        float nz = 0.0f;
        float xTangent = 0.0f;
        float yTangent = 0.0f;
        float zTangent = 0.0f;
        switch (this.solidDir) {
            case 0: {
                y3 = 1.0f;
                y4 = 1.0f;
                nx = 0.0f;
                nz = n;
                xTangent = 1.0f;
                break;
            }
            case 1: {
                y1 = 1.0f;
                y2 = 1.0f;
                nx = 0.0f;
                nz = -n;
                xTangent = 1.0f;
                break;
            }
            case 2: {
                y2 = 1.0f;
                y3 = 1.0f;
                nx = -n;
                nz = 0.0f;
                xTangent = n;
                yTangent = n;
                zTangent = 0.0f;
                break;
            }
            case 3: {
                y4 = 1.0f;
                y1 = 1.0f;
                nx = n;
                nz = 0.0f;
                xTangent = n;
                yTangent = -n;
            }
        }
        if (up) {
            part.setCoords(x, (float)z + y1, y + 1, x + 1, (float)z + y2, y + 1, x + 1, (float)z + y3, y, x, (float)z + y4, y);
            part.setNormals(nx, n, nz, nx, n, nz, nx, n, nz, nx, n, nz);
        } else {
            part.setCoords(x + 1, (float)(z + 1) - y2, y + 1, x, (float)(z + 1) - y1, y + 1, x, (float)(z + 1) - y4, y, x + 1, (float)(z + 1) - y3, y);
            part.setNormals(nx, -n, nz, nx, -n, nz, nx, -n, nz, nx, -n, nz);
            yTangent = -yTangent;
            xTangent = -xTangent;
        }
        if (!this.flipTexture) {
            part.setTangents(xTangent, yTangent, zTangent, xTangent, yTangent, zTangent, xTangent, yTangent, zTangent, xTangent, yTangent, zTangent);
            part.setTexCoords(0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f);
            part.setIndexes(0, 1, 2, 0, 2, 3);
        } else {
            part.setTangents(-xTangent, -yTangent, -zTangent, -xTangent, -yTangent, -zTangent, -xTangent, -yTangent, -zTangent, -xTangent, -yTangent, -zTangent);
            part.setTexCoords(1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f);
            part.setIndexes(2, 3, 0, 2, 0, 1);
        }
        buffer.add(part);
        return 0;
    }

    @Override
    public boolean isSolid(int direction) {
        return this.sides[direction] == 1;
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public boolean isBoundary(int direction) {
        return this.sides[direction] != 0;
    }

    @Override
    public BoundaryShape getBoundaryShape(int direction) {
        return this.shapes[direction];
    }

    @Override
    public final float getTransparency(int axis) {
        return 0.0f;
    }

    @Override
    public Vector3f getMin() {
        return Vector3f.ZERO;
    }

    @Override
    public Vector3f getMax() {
        return CubeFactory.UNIT_CUBE;
    }

    @Override
    public double getMassPortion() {
        double x = this.getMax().x - this.getMin().x;
        double y = this.getMax().y - this.getMin().y;
        double z = this.getMax().z - this.getMin().z;
        return x * y * z * 0.5;
    }

    @Override
    public boolean isClipped() {
        return true;
    }
}

