/*
 * Decompiled with CFR 0.152.
 */
package mythruna.phys;

import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import mythruna.Coordinates;
import mythruna.Vector3i;
import mythruna.World;
import mythruna.db.BlueprintData;
import mythruna.es.Entity;
import mythruna.es.EntityData;
import mythruna.es.EntityId;
import mythruna.es.EntityProcessor;
import mythruna.es.EntitySet;
import mythruna.es.FieldFilter;
import mythruna.es.ModelInfo;
import mythruna.es.Position;
import mythruna.mathd.Vec3d;
import mythruna.phys.CollisionMesh;
import mythruna.phys.Mass;
import org.progeeks.util.log.Log;

public class ActiveObjects
implements Iterable<CollisionMesh> {
    static Log log = Log.getLog();
    public static final BlueprintData BLOCK = new BlueprintData();
    private World world;
    private EntityData ed;
    private Map<EntityId, CollisionMesh> meshes = new HashMap<EntityId, CollisionMesh>();
    private Map<CollisionMesh, Integer> usageCounts = new HashMap<CollisionMesh, Integer>();
    private Map<Vector3i, ActiveSet> active = new HashMap<Vector3i, ActiveSet>();
    private ConcurrentLinkedQueue<MeshBuilder> finishedBuilders = new ConcurrentLinkedQueue();
    private Vector3i lastColumn = null;

    public ActiveObjects(World world, EntityData ed) {
        this.world = world;
        this.ed = ed;
    }

    public void close() {
        for (ActiveSet as : this.active.values()) {
            as.release();
        }
        this.active.clear();
    }

    @Override
    public Iterator<CollisionMesh> iterator() {
        return this.meshes.values().iterator();
    }

    protected void markUsed(CollisionMesh cm) {
        Integer i = this.usageCounts.get(cm);
        i = i == null ? Integer.valueOf(1) : Integer.valueOf(i + 1);
        this.usageCounts.put(cm, i);
    }

    protected boolean unmarkUsed(CollisionMesh cm) {
        Integer i = this.usageCounts.get(cm);
        if (i == null) {
            return true;
        }
        if ((i = Integer.valueOf(i - 1)) == 0) {
            this.usageCounts.remove(cm);
            return true;
        }
        this.usageCounts.put(cm, i);
        return false;
    }

    public void resetActive(CollisionMesh cm) {
        Vec3d pos = cm.position;
        int x = Coordinates.worldToLeaf(pos.x);
        int y = Coordinates.worldToLeaf(pos.z);
        if (this.lastColumn == null) {
            this.lastColumn = new Vector3i(x, y, 0);
        } else {
            if (this.lastColumn.x == x && this.lastColumn.y == y) {
                return;
            }
            this.lastColumn.x = x;
            this.lastColumn.y = y;
        }
        int xMin = this.lastColumn.x - 1;
        int yMin = this.lastColumn.y - 1;
        int xMax = this.lastColumn.x + 1;
        int yMax = this.lastColumn.y + 1;
        this.resetActive(xMin, yMin, xMax, yMax);
    }

    public void resetActive(int xMin, int yMin, int xMax, int yMax) {
        HashSet<Vector3i> toRemove = new HashSet<Vector3i>(this.active.keySet());
        for (int i = xMin; i <= xMax; ++i) {
            for (int j = yMin; j <= yMax; ++j) {
                Vector3i v = new Vector3i(i, j, 0);
                ActiveSet set = this.active.get(v);
                if (set == null) {
                    set = new ActiveSet(v);
                    this.active.put(v, set);
                    this.added(set.entities, set);
                    continue;
                }
                toRemove.remove(v);
            }
        }
        for (Vector3i col : toRemove) {
            ActiveSet set = this.active.remove(col);
            if (set == null) continue;
            set.release();
            this.removed(set.entities, set);
        }
    }

    public boolean applyChanges() {
        boolean changed = false;
        if (!this.finishedBuilders.isEmpty()) {
            MeshBuilder mb = null;
            while ((mb = this.finishedBuilders.poll()) != null) {
                mb.apply();
            }
        }
        for (ActiveSet as : this.active.values()) {
            EntitySet es = as.entities;
            if (!es.applyChanges()) continue;
            changed = true;
            this.removed(es.getRemovedEntities(), as);
            if (!es.getAddedEntities().isEmpty()) {
                this.added(es.getAddedEntities(), as);
            }
            this.updated(es.getChangedEntities(), as);
        }
        return changed;
    }

    public CollisionMesh getCollisionMesh(EntityId entity) {
        CollisionMesh mesh = this.meshes.get(entity);
        return mesh;
    }

    private final void added(Set<Entity> set, ActiveSet as) {
        if (set.isEmpty()) {
            return;
        }
        for (Entity e : set) {
            CollisionMesh mesh = this.meshes.get(e.getId());
            if (mesh == null) {
                ModelInfo mi = e.get(ModelInfo.class);
                BlueprintData bp = this.world.getBlueprint(mi.getBlueprintId(), false);
                if (bp == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Queing up background request for blueprint:" + mi.getBlueprintId() + "  entity:" + e.getId()));
                    }
                    mesh = new CollisionMesh(e.getId(), BLOCK);
                    this.ed.execute(new MeshBuilder(mi.getBlueprintId(), mesh));
                    this.meshes.put(e.getId(), mesh);
                } else {
                    mesh = new CollisionMesh(e.getId(), bp);
                    this.meshes.put(e.getId(), mesh);
                }
            }
            this.markUsed(mesh);
            this.update(e, as);
        }
    }

    private final void update(Entity e, ActiveSet as) {
        CollisionMesh mesh = this.meshes.get(e.getId());
        if (mesh == null) {
            throw new RuntimeException("No mesh found for ID:" + e.getId());
        }
        Position pos = e.get(Position.class);
        Vector3f p = pos.getLocation();
        Quaternion q = pos.getRotation();
        if (p == null) {
            throw new RuntimeException("Position has null location:" + pos);
        }
        mesh.orientation.set(q.getX(), q.getY(), q.getZ(), q.getW());
        mesh.setBasePosition(p.x, p.z, p.y);
        Mass mass = e.get(Mass.class);
        mesh.setIsStatic(mass.getInverseMass() == 0.0);
    }

    private final void updated(Set<Entity> set, ActiveSet as) {
        if (set.isEmpty()) {
            return;
        }
        for (Entity e : set) {
            this.update(e, as);
        }
    }

    private final void removed(Set<Entity> set, ActiveSet as) {
        if (set.isEmpty()) {
            return;
        }
        for (Entity e : set) {
            CollisionMesh mesh = this.meshes.get(e.getId());
            if (!this.unmarkUsed(mesh)) continue;
            this.meshes.remove(e.getId());
        }
    }

    static {
        ActiveObjects.BLOCK.cells = new int[1][1][1];
        ActiveObjects.BLOCK.cells[0][0][0] = 1;
        ActiveObjects.BLOCK.id = -42L;
        ActiveObjects.BLOCK.xSize = 1;
        ActiveObjects.BLOCK.ySize = 1;
        ActiveObjects.BLOCK.zSize = 1;
        ActiveObjects.BLOCK.scale = 2.5f;
    }

    private class MeshBuilder
    implements EntityProcessor {
        long blueprintId;
        CollisionMesh cm;
        BlueprintData data;

        public MeshBuilder(long blueprintId, CollisionMesh mesh) {
            this.blueprintId = blueprintId;
            this.cm = mesh;
        }

        public void apply() {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Applying mesh blueprint for:" + this.blueprintId + "  entity:" + this.cm.getId()));
            }
            if (ActiveObjects.this.meshes.containsKey(this.cm.getId())) {
                this.cm.setMesh(this.data);
            }
        }

        @Override
        public void run(EntityData data) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Requesting mesh blueprint for:" + this.blueprintId + "  entity:" + this.cm.getId()));
            }
            this.data = ActiveObjects.this.world.getBlueprint(this.blueprintId, true);
            ActiveObjects.this.finishedBuilders.add(this);
        }
    }

    private class ActiveSet {
        long colId;
        Vector3i leafPos;
        EntitySet entities;

        public ActiveSet(Vector3i v) {
            this.leafPos = v;
            this.colId = Coordinates.leafToColumnId(v.x, v.y);
            FieldFilter<Position> filter = new FieldFilter<Position>(Position.class, "columnId", this.colId);
            this.entities = ActiveObjects.this.ed.getEntities(filter, Position.class, ModelInfo.class, Mass.class);
        }

        public void release() {
            this.entities.release();
        }
    }
}

