/*
 * Decompiled with CFR 0.152.
 */
package mythruna.phys;

import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import mythruna.BlockType;
import mythruna.BlockTypeIndex;
import mythruna.Direction;
import mythruna.geom.AngleFactory;
import mythruna.geom.CylinderFactory;
import mythruna.geom.CylinderFactory2;
import mythruna.geom.DefaultGeomFactory;
import mythruna.geom.GeomFactory;
import mythruna.geom.ThatchFactory;
import mythruna.geom.WedgeFactory;
import mythruna.mathd.Vec3d;
import mythruna.phys.Collider;
import mythruna.phys.collision.AngleCollider;
import mythruna.phys.collision.CubeCollider;
import mythruna.phys.collision.CylinderCollider;
import mythruna.phys.collision.WedgeCollider;

public class Colliders {
    public static byte[] inverseMask = new byte[64];
    public static Collider UNIT_CUBE;
    public static Collider[] colliders;

    public static void initialize() {
        if (colliders == null) {
            if (!BlockTypeIndex.isInitialized()) {
                throw new RuntimeException("Block types have not been initialized.");
            }
            colliders = new Collider[BlockTypeIndex.types.length];
            for (int i = 0; i < colliders.length; ++i) {
                GeomFactory f;
                GeomFactory geom;
                BlockType type = BlockTypeIndex.types[i];
                if (type == null || !(geom = type.getGeomFactory()).isClipped() || i == 7 || i == 8) continue;
                if (geom instanceof WedgeFactory) {
                    WedgeFactory wf = (WedgeFactory)geom;
                    Colliders.colliders[i] = new WedgeCollider(wf.getSolidDir(), wf.isFacingUp());
                    continue;
                }
                if (geom instanceof ThatchFactory) {
                    f = (ThatchFactory)geom;
                    Colliders.colliders[i] = new WedgeCollider(Direction.INVERSE[((ThatchFactory)f).getDirection()], true);
                    continue;
                }
                if (geom instanceof AngleFactory) {
                    AngleFactory af = (AngleFactory)geom;
                    Colliders.colliders[i] = new AngleCollider(af.getDirection());
                    continue;
                }
                if (geom instanceof CylinderFactory) {
                    f = (CylinderFactory)geom;
                    Colliders.colliders[i] = new CylinderCollider(((CylinderFactory)f).getRadius());
                    continue;
                }
                if (geom instanceof CylinderFactory2) {
                    f = (CylinderFactory2)geom;
                    if (((CylinderFactory2)f).getDir() < 0) {
                        float radius = ((CylinderFactory2)f).getRadius();
                        float length = ((CylinderFactory2)f).getHeight();
                        Vector3f v1 = new Vector3f(0.0f, length, 0.0f);
                        Vector3f v2 = new Vector3f(radius *= 0.8f, 0.0f, 0.0f);
                        Vector3f v3 = new Vector3f(0.0f, 0.0f, radius);
                        Quaternion q = ((CylinderFactory2)f).getRotation();
                        v1 = q.mult(v1);
                        v2 = q.mult(v2);
                        v3 = q.mult(v3);
                        Vector3f min = new Vector3f(0.0f, 0.0f, 0.0f);
                        Vector3f max = new Vector3f(0.0f, 0.0f, 0.0f);
                        min.minLocal(v1);
                        min.minLocal(v2);
                        min.minLocal(v3);
                        min.minLocal(v1.negate());
                        min.minLocal(v2.negate());
                        min.minLocal(v3.negate());
                        max.maxLocal(v1);
                        max.maxLocal(v2);
                        max.maxLocal(v3);
                        max.maxLocal(v1.negate());
                        max.maxLocal(v2.negate());
                        max.maxLocal(v3.negate());
                        min.addLocal(0.5f, 0.5f, 0.5f);
                        max.addLocal(0.5f, 0.5f, 0.5f);
                        min.addLocal(((CylinderFactory2)f).getOffset());
                        max.addLocal(((CylinderFactory2)f).getOffset());
                        if ((double)Math.abs(min.x) < 0.001) {
                            min.x = 0.0f;
                        }
                        if ((double)Math.abs(min.y) < 0.001) {
                            min.y = 0.0f;
                        }
                        if ((double)Math.abs(min.z) < 0.001) {
                            min.z = 0.0f;
                        }
                        if ((double)Math.abs(max.x) < 0.001) {
                            max.x = 0.0f;
                        }
                        if ((double)Math.abs(max.y) < 0.001) {
                            max.y = 0.0f;
                        }
                        if ((double)Math.abs(max.z) < 0.001) {
                            max.z = 0.0f;
                        }
                        Vec3d low = new Vec3d(min.x, min.y, min.z);
                        Vec3d hi = new Vec3d(max.x, max.y, max.z);
                        Colliders.colliders[i] = new CubeCollider(low, hi);
                        continue;
                    }
                    int dir = ((CylinderFactory2)f).getDir();
                    float radius = ((CylinderFactory2)f).getRadius();
                    double length = Math.sqrt(2.0);
                    Vector3f offset = ((CylinderFactory2)f).getOffset();
                    double xOffset = offset.x == 0.0f ? 0.5 : (offset.x > 0.0f ? (double)(offset.x + 1.0f) : (double)offset.x);
                    double yOffset = -0.25;
                    double zOffset = offset.z == 0.0f ? 0.5 : (offset.z > 0.0f ? (double)(offset.z + 1.0f) : (double)offset.z);
                    Colliders.colliders[i] = new CylinderCollider(dir, radius, length += 0.25, xOffset, yOffset -= 0.1, zOffset);
                    continue;
                }
                if (geom instanceof DefaultGeomFactory) {
                    f = (DefaultGeomFactory)geom;
                    if (((DefaultGeomFactory)f).getCollider() != null) {
                        Colliders.colliders[i] = ((DefaultGeomFactory)f).getCollider();
                        continue;
                    }
                    Colliders.colliders[i] = new CubeCollider(geom.getMin(), geom.getMax());
                    continue;
                }
                Colliders.colliders[i] = new CubeCollider(geom.getMin(), geom.getMax());
            }
        }
    }

    static {
        for (int i = 0; i < 64; ++i) {
            int mask = 0;
            if (Direction.hasNorth(i)) {
                mask |= 2;
            }
            if (Direction.hasSouth(i)) {
                mask |= 1;
            }
            if (Direction.hasEast(i)) {
                mask |= 8;
            }
            if (Direction.hasWest(i)) {
                mask |= 4;
            }
            if (Direction.hasUp(i)) {
                mask |= 0x20;
            }
            if (Direction.hasDown(i)) {
                mask |= 0x10;
            }
            Colliders.inverseMask[i] = (byte)mask;
        }
        UNIT_CUBE = new CubeCollider();
    }
}

