/*
 * Decompiled with CFR 0.152.
 */
package mythruna.phys;

import com.jme3.math.Vector3f;
import java.util.HashMap;
import java.util.Map;
import mythruna.World;
import mythruna.es.ChangeQueue;
import mythruna.es.Entity;
import mythruna.es.EntityChange;
import mythruna.es.EntityComponent;
import mythruna.es.EntityData;
import mythruna.es.EntityId;
import mythruna.es.EntitySet;
import mythruna.es.FieldFilter;
import mythruna.es.ObservableEntityData;
import mythruna.mathd.Vec3d;
import mythruna.phys.ForceGenerator;
import mythruna.phys.PhysicalLink;
import mythruna.phys.PhysicsSystem;
import mythruna.phys.RigidBody;
import mythruna.phys.Spring;

public class ForceSystem {
    private World world;
    private ObservableEntityData ed;
    private PhysicsSystem physics;
    private Map<EntityId, ForceGenerator> generators = new HashMap<EntityId, ForceGenerator>();
    private ChangeQueue changes;

    public ForceSystem(PhysicsSystem physics, World world, EntityData ed) {
        this.physics = physics;
        this.world = world;
        this.ed = (ObservableEntityData)ed;
    }

    public void start() {
        this.changes = this.ed.getChangeQueue(Spring.class);
    }

    public void shutdown() {
        this.changes.release();
    }

    protected void updateGenerator(EntityId id, EntityComponent val) {
        System.out.println("************* updateGenerator(" + id + ", " + val + ")");
    }

    protected void addGenerator(EntityId id, EntityComponent val) {
        boolean hasTarget;
        System.out.println("************* addGenerator(" + id + ", " + val + ")");
        PhysicalLink link = this.ed.getComponent(id, PhysicalLink.class);
        System.out.println(" link:" + link);
        RigidBody source = this.physics.activate(link.getSource());
        boolean hasSource = source != null || link.getSource() == null;
        RigidBody target = this.physics.activate(link.getTarget());
        boolean bl = hasTarget = target != null || link.getTarget() == null;
        if (hasSource && hasTarget) {
            this.createSpring(id, source, target, link, (Spring)val);
        }
    }

    protected void addGenerator(RigidBody b, EntityId id, PhysicalLink link, Spring spring) {
        boolean hasTarget;
        RigidBody source = this.physics.activate(link.getSource());
        boolean hasSource = source != null || link.getSource() == null;
        RigidBody target = this.physics.activate(link.getTarget());
        boolean bl = hasTarget = target != null || link.getTarget() == null;
        if (hasSource && hasTarget) {
            this.createSpring(id, source, target, link, spring);
        }
    }

    protected void createSpring(EntityId id, RigidBody source, RigidBody target, PhysicalLink link, Spring info) {
        System.out.println("createSpring(" + id + ", " + source + ", " + target + ", " + link + ", " + info + ")");
        SpringGenerator s = new SpringGenerator(source, target, link, info);
        this.generators.put(id, s);
    }

    protected void applyChanges() {
        EntityChange c = null;
        while ((c = (EntityChange)this.changes.poll()) != null) {
            EntityId id = c.getEntityId();
            EntityComponent val = c.getComponent();
            if (this.generators.containsKey(id)) {
                if (val == null) {
                    this.generators.remove(id);
                    continue;
                }
                this.updateGenerator(id, val);
                continue;
            }
            if (val == null) continue;
            this.addGenerator(id, val);
        }
    }

    public void updateForces(double t) {
        this.applyChanges();
        for (ForceGenerator g : this.generators.values()) {
            g.updateForce(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateBody(RigidBody b) {
        System.out.println("******* activateBody:" + b);
        FieldFilter<PhysicalLink> filter = new FieldFilter<PhysicalLink>(PhysicalLink.class, "source", b.getId());
        EntitySet set = this.ed.getEntities(filter, PhysicalLink.class, Spring.class);
        try {
            for (Entity e : set) {
                this.addGenerator(b, e.getId(), e.get(PhysicalLink.class), e.get(Spring.class));
            }
        }
        finally {
            set.release();
        }
        filter = new FieldFilter<PhysicalLink>(PhysicalLink.class, "target", b.getId());
        set = this.ed.getEntities(filter, PhysicalLink.class, Spring.class);
        try {
            for (Entity e : set) {
                this.addGenerator(b, e.getId(), e.get(PhysicalLink.class), e.get(Spring.class));
            }
        }
        finally {
            set.release();
        }
    }

    public void deactivateBody(RigidBody b) {
        System.out.println("********* deactivateBody:" + b);
    }

    private class SpringGenerator
    implements ForceGenerator {
        private RigidBody source;
        private RigidBody target;
        private Vec3d sourcePoint;
        private Vec3d targetPoint;
        private double length;
        private double strength;

        public SpringGenerator(RigidBody source, RigidBody target, PhysicalLink link, Spring info) {
            System.out.println("New Spring(" + source + ", " + target + ", " + link + ")");
            this.source = source;
            this.target = target;
            this.length = info.getLength();
            this.strength = info.getStrength();
            Vector3f v = link.getSourceOffset();
            this.sourcePoint = new Vec3d(v.x, v.z, v.y);
            v = link.getTargetOffset();
            this.targetPoint = new Vec3d(v.x, v.z, v.y);
        }

        private Vec3d getSourcePoint() {
            if (this.source == null) {
                return this.sourcePoint;
            }
            return this.source.localToWorld(this.sourcePoint);
        }

        private Vec3d getTargetPoint() {
            if (this.target == null) {
                return this.targetPoint;
            }
            return this.target.localToWorld(this.targetPoint);
        }

        @Override
        public void updateForce(double t) {
            Vec3d p2;
            Vec3d p1 = this.getSourcePoint();
            Vec3d force = p1.subtract(p2 = this.getTargetPoint());
            double len = force.length();
            if (len - this.length < 0.0) {
                return;
            }
            double m = (len - this.length) * this.strength;
            if (m == 0.0) {
                return;
            }
            force.multLocal(m / len);
            if (this.source != null) {
                this.source.addForceAtPoint(force.mult(-1.0), p1);
                if (this.source.isSleepy()) {
                    this.source.setTemperature(0.01);
                }
            }
            if (this.target != null) {
                this.target.addForceAtPoint(force, p2);
                if (this.target.isSleepy()) {
                    this.target.setTemperature(0.01);
                }
            }
        }
    }
}

