/*
 * Decompiled with CFR 0.152.
 */
package mythruna.phys;

import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import mythruna.World;
import mythruna.es.Entity;
import mythruna.es.EntityData;
import mythruna.es.EntityId;
import mythruna.es.EntitySet;
import mythruna.es.Position;
import mythruna.mathd.Quatd;
import mythruna.mathd.Vec3d;
import mythruna.phys.BodyState;
import mythruna.phys.CollisionMesh;
import mythruna.phys.CollisionSystem;
import mythruna.phys.Contact;
import mythruna.phys.ContactResolver;
import mythruna.phys.ForceSystem;
import mythruna.phys.Impulse;
import mythruna.phys.Mass;
import mythruna.phys.MassProperties;
import mythruna.phys.RigidBody;
import mythruna.phys.TandemContactResolver;
import mythruna.phys.proto.ContactDebug;
import mythruna.phys.proto.PhysicsDebug;

public class PhysicsSystem {
    private World world;
    private EntityData ed;
    private CollisionSystem collisions;
    private ForceSystem forces;
    private long lastUpdate = 0L;
    private double baseGravity = -20.0;
    private Runner runner = new Runner();
    private long fps = 60L;
    private long physTime = 1000000000L / this.fps;
    private double step = 1.0 / (double)this.fps;
    private long updateDelta = 50000000L;
    private EntitySet entities;
    private Set<Entity> pending = new HashSet<Entity>();
    private EntitySet impulses;
    private Map<EntityId, RigidBody> bodies = new HashMap<EntityId, RigidBody>();
    private List<Contact> contacts = new ArrayList<Contact>();
    private ContactResolver resolver = new TandemContactResolver();
    private static final boolean debugOn = true;
    private List<EntityId> debugContacts = new ArrayList<EntityId>();
    private int debugContactsInUse = 0;

    public PhysicsSystem(World world, EntityData ed) {
        this.collisions = this.collisions;
        this.world = world;
        this.ed = ed;
        this.collisions = new CollisionSystem(world, ed);
        this.forces = new ForceSystem(this, world, ed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() {
        System.out.println("Initializing physics system...");
        this.collisions.start();
        this.forces.start();
        this.collisions.resetActive(-2, -2, 2, 2);
        EntitySet mobiles = this.ed.getEntities(Position.class, Mass.class, MassProperties.class);
        try {
            mobiles.applyChanges();
            for (Entity e : mobiles) {
                Mass m = e.get(Mass.class);
                if (m.getInverseMass() == 0.0) continue;
                e.set(new BodyState());
            }
        }
        finally {
            mobiles.release();
        }
        this.entities = this.ed.getEntities(Mass.class, MassProperties.class, BodyState.class);
        this.added(this.entities);
        this.impulses = this.ed.getEntities(MassProperties.class, Impulse.class);
        this.applyImpulses(this.impulses);
    }

    protected void terminate() {
        this.forces.shutdown();
        this.collisions.shutdown();
    }

    public void start() {
        System.out.println("Starting physics engine.");
        this.runner.start();
    }

    public void shutdown() {
        System.out.println("Shuttong down physics engine.");
        this.runner.close();
    }

    protected void applyImpulses(Set<Entity> set) {
        if (set.isEmpty()) {
            return;
        }
        System.out.println("Current impulses:" + this.impulses);
        for (Entity e : set) {
            RigidBody body = this.bodies.get(e.getId());
            if (body == null) continue;
            Impulse imp = e.get(Impulse.class);
            Vector3f v = imp.getVelocity();
            body.addVelocity(v.x, v.y, v.z);
            this.ed.removeComponent(e.getId(), Impulse.class);
        }
    }

    public RigidBody activate(EntityId e) {
        if (e == null) {
            return null;
        }
        RigidBody result = this.bodies.get(e);
        if (result != null) {
            return result;
        }
        this.ed.setComponent(e, new BodyState(true));
        return null;
    }

    protected void createRigidBody(Entity e, CollisionMesh cm) {
        RigidBody body = this.bodies.get(e.getId());
        if (body == null) {
            body = new RigidBody(cm, e.get(Mass.class), e.get(MassProperties.class));
            body.setAcceleration(0.0, this.baseGravity, 0.0);
            this.bodies.put(e.getId(), body);
            this.forces.activateBody(body);
        }
        this.ed.setComponent(body.getId(), new PhysicsDebug(PhysicsDebug.PhysicsState.AWAKE, body.getTemperature()));
    }

    protected void updateRigidBodyDebug(RigidBody body) {
        this.ed.setComponent(body.getId(), new PhysicsDebug(PhysicsDebug.PhysicsState.AWAKE, body.getTemperature()));
    }

    protected void removeRigidBody(Entity e) {
        RigidBody body = this.bodies.get(e.getId());
        this.forces.deactivateBody(body);
        this.ed.setComponent(body.getId(), new PhysicsDebug(PhysicsDebug.PhysicsState.SLEEPING, body.getTemperature()));
    }

    protected void added(Set<Entity> set) {
        if (set.isEmpty()) {
            return;
        }
        for (Entity e : set) {
            CollisionMesh cm = this.collisions.getCollisionMesh(e.getId());
            if (cm == null) {
                this.pending.add(e);
                continue;
            }
            this.pending.remove(e);
            this.createRigidBody(e, cm);
        }
    }

    protected void removed(Set<Entity> set) {
        if (set.isEmpty()) {
            return;
        }
        for (Entity e : set) {
            this.pending.remove(e);
            this.removeRigidBody(e);
        }
    }

    protected void updated(Set<Entity> set) {
        if (set.isEmpty()) {
            return;
        }
    }

    protected void generateContacts() {
        this.contacts.clear();
        for (RigidBody b : this.bodies.values()) {
            if (b.isSleepy()) continue;
            int start = this.contacts.size();
            this.collisions.generateWorldCollisions(b.getCollisionMesh(), this.contacts);
            int end = this.contacts.size();
        }
        this.collisions.generateObjectCollisions(this.contacts);
    }

    protected void test2(RigidBody b, List<Contact> list) {
        Vec3d vDelta1 = new Vec3d();
        Vec3d rotDelta1 = new Vec3d();
        Vec3d linear1 = new Vec3d();
        Vec3d angular1 = new Vec3d();
        Vec3d vMin = new Vec3d();
        Vec3d vMax = new Vec3d();
        Vec3d rotMin = new Vec3d();
        Vec3d rotMax = new Vec3d();
        Vec3d linMin = new Vec3d();
        Vec3d linMax = new Vec3d();
        Vec3d angMin = new Vec3d();
        Vec3d angMax = new Vec3d();
        double maxPen = 0.0;
        for (Contact c : list) {
            RigidBody b1 = null;
            RigidBody b2 = null;
            double localTemperature = 1.0;
            if (c.mesh1 != null && (b1 = this.bodies.get(c.mesh1.getId())).getTemperature() < localTemperature) {
                localTemperature = b1.getTemperature();
            }
            if (c.mesh2 != null && (b2 = this.bodies.get(c.mesh2.getId())).getTemperature() < localTemperature) {
                localTemperature = b2.getTemperature();
            }
            c.setBodyData(b1, b2);
            c.calculateInternals(this.step * localTemperature);
            c.calculatePositionChange(linear1, null, angular1, null, c.penetration);
            linMin.minLocal(linear1);
            linMax.maxLocal(linear1);
            angMin.minLocal(angular1);
            angMax.maxLocal(angular1);
            maxPen = Math.max(c.penetration, maxPen);
        }
        Vec3d l = linMin.addLocal(linMax);
        Vec3d a = angMin.addLocal(angMax);
        b.getCollisionMesh().position.addLocal(l);
        b.getCollisionMesh().orientation.addScaledVectorLocal(a, 1.0);
        b.calculateDerivedData();
        Vec3d deltaPos = new Vec3d();
        for (Contact c : list) {
            c.calculateVelocityChange(vDelta1, null, rotDelta1, null);
            vMin.minLocal(vDelta1);
            vMax.maxLocal(vDelta1);
            rotMin.minLocal(rotDelta1);
            rotMax.maxLocal(rotDelta1);
        }
        Vec3d v = vMin.addLocal(vMax);
        Vec3d r = rotMin.addLocal(rotMax);
        b.addVelocity(v);
        b.addRotation(r);
        list.clear();
    }

    protected void resolveContacts() {
        for (Contact c : this.contacts) {
            RigidBody b1 = null;
            RigidBody b2 = null;
            if (c.mesh1 != null) {
                b1 = this.bodies.get(c.mesh1.getId());
            }
            if (c.mesh2 != null) {
                b2 = this.bodies.get(c.mesh2.getId());
            }
            c.setBodyData(b1, b2);
        }
        this.resolver.resolveContacts(this.contacts, this.step);
    }

    protected final void publishContacts() {
        EntityId e;
        int i;
        for (i = 0; i < this.contacts.size(); ++i) {
            Contact c = this.contacts.get(i);
            e = null;
            if (i < this.debugContacts.size()) {
                e = this.debugContacts.get(i);
            } else {
                e = this.ed.createEntity();
                this.debugContacts.add(e);
            }
            ContactDebug cb = new ContactDebug(c);
            this.ed.setComponent(e, cb);
        }
        int inUse = i;
        while (i < this.debugContacts.size()) {
            e = this.debugContacts.get(i);
            this.ed.setComponent(e, new ContactDebug(false));
            ++i;
        }
        this.debugContactsInUse = inUse;
    }

    protected void step() {
        if (this.collisions.applyChanges()) {
            this.added(this.pending);
        }
        if (this.entities.applyChanges()) {
            this.removed(this.entities.getRemovedEntities());
            this.added(this.entities.getAddedEntities());
            this.updated(this.entities.getChangedEntities());
        }
        this.impulses.applyChanges();
        this.applyImpulses(this.impulses);
        this.forces.updateForces(this.step);
        if (this.bodies.isEmpty()) {
            return;
        }
        long time = System.nanoTime();
        long delta = time - this.lastUpdate;
        boolean publish = false;
        if (delta > this.updateDelta) {
            this.lastUpdate = time;
            publish = true;
        }
        for (RigidBody body : this.bodies.values()) {
            if (body.getCollisionMesh().position.y <= 50.0) {
                this.ed.removeComponent(body.getId(), BodyState.class);
                continue;
            }
            if (!body.isSleepy()) {
                body.integrate(this.step);
            }
            if (!body.isSleepy()) continue;
            this.ed.removeComponent(body.getId(), BodyState.class);
        }
        this.generateContacts();
        if (publish) {
            this.publishContacts();
        }
        this.resolveContacts();
        if (publish) {
            for (RigidBody body : this.bodies.values()) {
                Vec3d v = body.getCollisionMesh().getBasePosition();
                Quatd q = body.getCollisionMesh().orientation;
                Position pos = new Position(new Vector3f((float)v.x, (float)v.z, (float)v.y), new Quaternion((float)q.x, (float)q.y, (float)q.z, (float)q.w));
                this.ed.setComponent(body.getId(), pos);
                this.updateRigidBodyDebug(body);
            }
        }
    }

    private class Runner
    extends Thread {
        private AtomicBoolean go = new AtomicBoolean(true);

        public Runner() {
            this.setName("PhysicsThread");
        }

        public void close() {
            this.go.set(false);
            try {
                this.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted while waiting for physic thread to complete.", e);
            }
        }

        @Override
        public void run() {
            PhysicsSystem.this.initialize();
            long lastTime = System.nanoTime();
            while (this.go.get()) {
                long time = System.nanoTime();
                long delta = time - lastTime;
                if (delta < PhysicsSystem.this.physTime) continue;
                lastTime = time;
                try {
                    PhysicsSystem.this.step();
                    long end = System.nanoTime();
                    delta = end - time;
                    if (delta > PhysicsSystem.this.physTime) {
                        System.out.println("Physics processing time exceeded time step size:" + (double)delta / 1000000.0 + " ms");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Interrupted sleeping", e);
                }
            }
            PhysicsSystem.this.terminate();
        }
    }
}

