/*
 * Decompiled with CFR 0.152.
 */
package mythruna.phys.collision;

import mythruna.Direction;
import mythruna.mathd.Vec3d;
import mythruna.phys.Collider;
import mythruna.phys.Contact;

public class WedgeCollider
implements Collider {
    private static final double HALF_SQRT2 = Math.sqrt(2.0) * 0.5;
    private int solidDir;
    private boolean facingUp;
    private Vec3d rising;
    private Vec3d up;
    private Vec3d side;
    private Vec3d normal;
    private Vec3d rampNormal;
    private double slope;
    private Vec3d origin;
    private int rampMask;

    public WedgeCollider(int solidDir, boolean facingUp) {
        this.solidDir = solidDir;
        this.facingUp = facingUp;
        this.rising = new Vec3d(Direction.DIRS[solidDir][0], Direction.DIRS[solidDir][2], Direction.DIRS[solidDir][1]);
        this.up = facingUp ? new Vec3d(0.0, 1.0, 0.0) : new Vec3d(0.0, -1.0, 0.0);
        this.normal = new Vec3d(-this.rising.x, this.up.y, -this.rising.z).normalizeLocal();
        this.slope = 1.0;
        this.rampNormal = new Vec3d(-1.0, this.up.y, 0.0).normalizeLocal();
        this.rampMask = Direction.MASKS[solidDir];
        this.rampMask = facingUp ? (this.rampMask |= 0x10) : (this.rampMask |= 0x20);
        switch (solidDir) {
            case 0: {
                this.origin = new Vec3d(0.0, 0.0, 1.0);
                this.side = new Vec3d(1.0, 0.0, 0.0);
                break;
            }
            case 1: {
                this.origin = new Vec3d(0.0, 0.0, 0.0);
                this.side = new Vec3d(1.0, 0.0, 0.0);
                break;
            }
            case 2: {
                this.origin = new Vec3d(0.0, 0.0, 0.0);
                this.side = new Vec3d(0.0, 0.0, 1.0);
                break;
            }
            case 3: {
                this.origin = new Vec3d(1.0, 0.0, 0.0);
                this.side = new Vec3d(0.0, 0.0, 1.0);
            }
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        WedgeCollider other = (WedgeCollider)o;
        if (other.solidDir != this.solidDir) {
            return false;
        }
        return other.facingUp == this.facingUp;
    }

    public int hashCode() {
        return this.solidDir;
    }

    @Override
    public String getName() {
        return "wedge" + (this.facingUp ? "" : "-up");
    }

    @Override
    public Collider rotate(int dirDelta) {
        return new WedgeCollider(Direction.rotate(this.solidDir, dirDelta), this.facingUp);
    }

    private static final double clamp(double v, double min, double max) {
        return v < min ? min : (v > max ? max : v);
    }

    @Override
    public Contact getContact(Vec3d cellPos, Vec3d pos, double radius, int dirMask, int srcInvMask) {
        double p;
        Vec3d temp = pos.clone();
        temp.x -= cellPos.x + this.origin.x;
        temp.y -= cellPos.y + this.origin.y;
        temp.z -= cellPos.z + this.origin.z;
        double x = this.rising.dot(temp);
        if (x + radius <= 0.0 || x - radius >= 1.0) {
            return null;
        }
        if (temp.y + radius < 0.0 || temp.y - radius > 1.0) {
            return null;
        }
        double z = this.side.dot(temp);
        double y = temp.y - radius * this.up.y;
        double h = (x + radius) * this.slope;
        if (this.up.y < 0.0) {
            h = 1.0 - h;
        }
        if (this.up.y > 0.0 && temp.y - radius > h) {
            return null;
        }
        if (this.up.y < 0.0 && temp.y + radius < h) {
            return null;
        }
        Vec3d cp = new Vec3d();
        Vec3d cn = new Vec3d();
        double pen = 10.0;
        int hitMask = 0;
        if (x + radius < 1.0 && (srcInvMask & this.rampMask) == this.rampMask) {
            double penDot;
            double p2;
            double contact;
            double ry = y;
            if (this.up.y < 0.0) {
                ry = y - 1.0;
            }
            if ((contact = x + radius + this.rampNormal.x * (p2 = HALF_SQRT2 - (penDot = (1.0 - (x + radius)) * -this.rampNormal.x + ry * this.rampNormal.y))) > 0.0 && contact < 1.0 && p2 > 0.0 && p2 < pen) {
                pen = p2;
                double cx = x + radius - this.rampNormal.x * p2;
                double cy = y + this.rampNormal.y * p2;
                double cz = z;
                cp.set(this.origin);
                cp.addLocal(this.rising.x * cx, this.rising.y * cx, this.rising.z * cx);
                cp.addLocal(this.side.x * cz, this.side.y * cz, this.side.z * cz);
                cp.y = cy;
                cn.set(this.normal);
                hitMask = this.rampMask;
            }
        }
        x = pos.x - cellPos.x;
        y = pos.y - cellPos.y;
        z = pos.z - cellPos.z;
        if (Direction.hasEast(srcInvMask) && (p = 1.0 + radius - x) > 0.0 && p < pen) {
            pen = p;
            cn.set(1.0, 0.0, 0.0);
            cp.set(1.0, WedgeCollider.clamp(y, 0.0, 1.0), WedgeCollider.clamp(z, 0.0, 1.0));
            hitMask = 4;
        }
        if (Direction.hasWest(srcInvMask) && (p = x + radius) > 0.0 && p < pen) {
            pen = p;
            cn.set(-1.0, 0.0, 0.0);
            cp.set(0.0, WedgeCollider.clamp(y, 0.0, 1.0), WedgeCollider.clamp(z, 0.0, 1.0));
            hitMask = 8;
        }
        if (Direction.hasNorth(srcInvMask) && (p = z + radius) > 0.0 && p < pen) {
            pen = p;
            cn.set(0.0, 0.0, -1.0);
            cp.set(WedgeCollider.clamp(x, 0.0, 1.0), WedgeCollider.clamp(y, 0.0, 1.0), 0.0);
            hitMask = 1;
        }
        if (Direction.hasSouth(srcInvMask) && (p = 1.0 + radius - z) > 0.0 && p < pen) {
            pen = p;
            cn.set(0.0, 0.0, 1.0);
            cp.set(WedgeCollider.clamp(x, 0.0, 1.0), WedgeCollider.clamp(y, 0.0, 1.0), 1.0);
            hitMask = 2;
        }
        if (Direction.hasUp(srcInvMask) && (p = 1.0 + radius - y) > 0.0 && p < pen) {
            pen = p;
            cn.set(0.0, 1.0, 0.0);
            cp.set(WedgeCollider.clamp(x, 0.0, 1.0), 1.0, WedgeCollider.clamp(z, 0.0, 1.0));
            hitMask = 16;
        }
        if (Direction.hasDown(srcInvMask) && (p = y + radius) > 0.0 && p < pen) {
            pen = p;
            cn.set(0.0, -1.0, 0.0);
            cp.set(WedgeCollider.clamp(x, 0.0, 1.0), 0.0, WedgeCollider.clamp(z, 0.0, 1.0));
            hitMask = 32;
        }
        if ((hitMask & dirMask) == 0) {
            return null;
        }
        Contact result = new Contact();
        result.contactPoint = cp.addLocal(cellPos);
        result.contactNormal = cn;
        result.penetration = pen;
        return result;
    }
}

