/*
 * Decompiled with CFR 0.152.
 */
package mythruna.phys.proto;

import mythruna.mathd.Matrix3d;
import mythruna.mathd.Quatd;
import mythruna.mathd.Vec3d;
import mythruna.phys.proto.RigidBody;

public class Contact {
    private static final double VELOCITY_LIMIT = 0.1;
    public RigidBody body1;
    public RigidBody body2;
    public double friction;
    public double restitution;
    public Vec3d contactPoint;
    public Vec3d contactNormal;
    public double penetration;
    public boolean alwaysAwake = false;
    protected Matrix3d contactToWorld = new Matrix3d();
    protected Vec3d contactVelocity;
    protected double desiredDeltaVelocity;
    protected Vec3d relativeContactPosition1;
    protected Vec3d relativeContactPosition2;

    public String toString() {
        return "Contact[" + this.body1 + " -> " + this.body2 + "]";
    }

    public void setBodyData(RigidBody b1, RigidBody b2, double friction, double restitution) {
        this.body1 = b1;
        this.body2 = b2;
        this.friction = friction;
        this.restitution = restitution;
    }

    protected void calculateInternals(double t) {
        if (this.body1 == null) {
            this.swapBodies();
        }
        this.calculateContactBasis();
        this.relativeContactPosition1 = this.contactPoint.subtract(this.body1.getPosition());
        if (this.body2 != null) {
            this.relativeContactPosition2 = this.contactPoint.subtract(this.body2.getPosition());
        }
        this.contactVelocity = this.calculateLocalVelocity(0, t);
        if (this.body2 != null) {
            this.contactVelocity.subtractLocal(this.calculateLocalVelocity(1, t));
        }
        this.calculateDesiredDeltaVelocity(t);
    }

    protected void swapBodies() {
        this.contactNormal.multLocal(-1.0);
        RigidBody temp = this.body1;
        this.body1 = this.body2;
        this.body2 = temp;
    }

    protected void matchAwakeState() {
        boolean awake2;
        if (this.body2 == null) {
            if (this.alwaysAwake) {
                this.body1.setAwake(true);
            }
            return;
        }
        boolean awake1 = this.body1.isAwake();
        if (awake1 == (awake2 = this.body2.isAwake())) {
            return;
        }
        if (awake1) {
            this.body2.setAwake(true);
        } else {
            this.body1.setAwake(true);
        }
    }

    protected void calculateDesiredDeltaVelocity(double t) {
        double velocityLimit = 0.1;
        double vFromAcc = 0.0;
        if (this.body1.isAwake()) {
            vFromAcc = this.body1.getLastFrameAcceleration().mult(t).dot(this.contactNormal);
        }
        if (this.body2 != null && this.body2.isAwake()) {
            vFromAcc -= this.body2.getLastFrameAcceleration().mult(t).dot(this.contactNormal);
        }
        double r = this.restitution;
        if (Math.abs(this.contactVelocity.x) < velocityLimit) {
            r = 0.0;
        }
        this.desiredDeltaVelocity = -this.contactVelocity.x - r * (this.contactVelocity.x - vFromAcc);
    }

    protected Vec3d calculateLocalVelocity(int index, double t) {
        Vec3d relContactPos;
        RigidBody b;
        if (index == 0) {
            b = this.body1;
            relContactPos = this.relativeContactPosition1;
        } else {
            b = this.body2;
            relContactPos = this.relativeContactPosition2;
        }
        Vec3d v = b.getRotation().cross(relContactPos);
        v.addLocal(b.getVelocity());
        Vec3d vContact = this.contactToWorld.transpose().mult(v);
        Vec3d vAcc = b.getLastFrameAcceleration().mult(t);
        vAcc = this.contactToWorld.transpose().mult(vAcc);
        vAcc.x = 0.0;
        vContact.addLocal(vAcc);
        return vContact;
    }

    protected void calculateContactBasis() {
        Vec3d contactTangent0 = new Vec3d();
        Vec3d contactTangent1 = new Vec3d();
        if (Math.abs(this.contactNormal.x) > Math.abs(this.contactNormal.y)) {
            double s = 1.0 / Math.sqrt(this.contactNormal.z * this.contactNormal.z + this.contactNormal.x * this.contactNormal.x);
            contactTangent0.x = this.contactNormal.z * s;
            contactTangent0.y = 0.0;
            contactTangent0.z = -this.contactNormal.x * s;
            contactTangent1.x = this.contactNormal.y * contactTangent0.x;
            contactTangent1.y = this.contactNormal.z * contactTangent0.x - this.contactNormal.x * contactTangent0.z;
            contactTangent1.z = -this.contactNormal.y * contactTangent0.x;
        } else {
            double s = 1.0 / Math.sqrt(this.contactNormal.z * this.contactNormal.z + this.contactNormal.y * this.contactNormal.y);
            contactTangent0.x = 0.0;
            contactTangent0.y = -this.contactNormal.z * s;
            contactTangent0.z = this.contactNormal.y * s;
            contactTangent1.x = this.contactNormal.y * contactTangent0.z - this.contactNormal.z * contactTangent0.y;
            contactTangent1.y = -this.contactNormal.x * contactTangent0.z;
            contactTangent1.z = this.contactNormal.x * contactTangent0.y;
        }
        this.contactToWorld.setColumn(0, this.contactNormal);
        this.contactToWorld.setColumn(1, contactTangent0);
        this.contactToWorld.setColumn(2, contactTangent1);
    }

    public static void addScaledVector(Vec3d target, Vec3d v, double scale) {
        target.x += v.x * scale;
        target.y += v.y * scale;
        target.z += v.z * scale;
    }

    public static void addScaledVector(Quatd quat, Vec3d v, double scale) {
        Quatd q = new Quatd(v.x * scale, v.y * scale, v.z * scale, 0.0);
        q.multLocal(quat);
        double x = quat.x + q.x * 0.5;
        double y = quat.y + q.y * 0.5;
        double z = quat.z + q.z * 0.5;
        double w = quat.w + q.w * 0.5;
        quat.set(x, y, z, w);
    }

    protected void applyImpulse(Vec3d impulse, RigidBody b, Vec3d vDelta, Vec3d rotDelta) {
    }

    protected void applyVelocityChange(Vec3d vDelta1, Vec3d vDelta2, Vec3d rotDelta1, Vec3d rotDelta2) {
        Matrix3d iit1 = null;
        Matrix3d iit2 = null;
        iit1 = this.body1.getInverseInertiaTensorWorld();
        if (this.body2 != null) {
            iit2 = this.body2.getInverseInertiaTensorWorld();
        }
        Vec3d impContact = this.friction == 0.0 ? this.calculateFrictionlessImpulse(iit1, iit2) : this.calculateFrictionImpulse(iit1, iit2);
        Vec3d imp = this.contactToWorld.mult(impContact);
        Vec3d impTorque = this.relativeContactPosition1.cross(imp);
        if (!this.body1.isStatic()) {
            rotDelta1.set(iit1.mult(impTorque));
        } else {
            rotDelta1.set(0.0, 0.0, 0.0);
        }
        vDelta1.set(0.0, 0.0, 0.0);
        if (!this.body1.isStatic()) {
            Contact.addScaledVector(vDelta1, imp, this.body1.getInverseMass());
            this.body1.addVelocity(vDelta1);
            this.body1.addRotation(rotDelta1);
        }
        if (this.body2 != null && !this.body2.isStatic()) {
            impTorque = imp.cross(this.relativeContactPosition2);
            rotDelta2.set(iit2.mult(impTorque));
            vDelta2.set(0.0, 0.0, 0.0);
            Contact.addScaledVector(vDelta2, imp, -this.body2.getInverseMass());
            this.body2.addVelocity(vDelta2);
            this.body2.addRotation(rotDelta2);
        }
    }

    protected void applyPositionChange(Vec3d linear1, Vec3d linear2, Vec3d angular1, Vec3d angular2, double penetration) {
        Quatd q;
        Vec3d pos;
        Matrix3d iit;
        double maxMagnitude;
        Vec3d projection;
        Vec3d angularInertiaWorld;
        Matrix3d iit2;
        double angularLimit = 0.001;
        double totalInertia = 0.0;
        double linearInertia1 = 0.0;
        double linearInertia2 = 0.0;
        double angularInertia1 = 0.0;
        double angularInertia2 = 0.0;
        if (this.body1 != null && !this.body1.isStatic()) {
            iit2 = this.body1.getInverseInertiaTensorWorld();
            angularInertiaWorld = this.relativeContactPosition1.cross(this.contactNormal);
            angularInertiaWorld = iit2.mult(angularInertiaWorld);
            angularInertiaWorld = angularInertiaWorld.cross(this.relativeContactPosition1);
            angularInertia1 = angularInertiaWorld.dot(this.contactNormal);
            linearInertia1 = this.body1.getInverseMass();
            totalInertia += linearInertia1 + angularInertia1;
        }
        if (this.body2 != null && !this.body2.isStatic()) {
            iit2 = this.body2.getInverseInertiaTensorWorld();
            angularInertiaWorld = this.relativeContactPosition2.cross(this.contactNormal);
            angularInertiaWorld = iit2.mult(angularInertiaWorld);
            angularInertiaWorld = angularInertiaWorld.cross(this.relativeContactPosition2);
            angularInertia2 = angularInertiaWorld.dot(this.contactNormal);
            linearInertia2 = this.body2.getInverseMass();
            totalInertia += linearInertia2 + angularInertia2;
        }
        if (this.body1 != null && !this.body1.isStatic()) {
            double totalMove;
            double sign = 1.0;
            double angularMove1 = sign * penetration * (angularInertia1 / totalInertia);
            double linearMove1 = sign * penetration * (linearInertia1 / totalInertia);
            projection = this.relativeContactPosition1.clone();
            Contact.addScaledVector(projection, this.contactNormal, -this.relativeContactPosition1.dot(this.contactNormal));
            maxMagnitude = angularLimit * projection.length();
            if (angularMove1 < -maxMagnitude) {
                totalMove = angularMove1 + linearMove1;
                angularMove1 = -maxMagnitude;
                linearMove1 = totalMove - angularMove1;
            } else if (angularMove1 > maxMagnitude) {
                totalMove = angularMove1 + linearMove1;
                angularMove1 = maxMagnitude;
                linearMove1 = totalMove - angularMove1;
            } else {
                angularMove1 = 0.0;
            }
            if (angularMove1 == 0.0) {
                angular1.set(0.0, 0.0, 0.0);
            } else {
                Vec3d targetAngularDirection = this.relativeContactPosition1.cross(this.contactNormal);
                iit = this.body1.getInverseInertiaTensorWorld();
                angular1.set(iit.mult(targetAngularDirection).multLocal(angularMove1 / angularInertia1));
            }
            double vLimit = 15.0;
            if (linearMove1 > vLimit) {
                linearMove1 = vLimit;
            }
            linear1.set(this.contactNormal.mult(linearMove1));
            pos = this.body1.getPosition().clone();
            Contact.addScaledVector(pos, this.contactNormal, linearMove1);
            this.body1.setPosition(pos);
            if (angularMove1 != 0.0) {
                q = this.body1.getOrientation();
                Contact.addScaledVector(q, angular1, 1.0);
                this.body1.setOrientation(q);
            }
            if (!this.body1.isAwake()) {
                this.body1.calculateDerivedData();
            }
        }
        if (this.body2 != null && !this.body2.isStatic()) {
            double totalMove;
            double sign = -1.0;
            double angularMove2 = sign * penetration * (angularInertia2 / totalInertia);
            double linearMove2 = sign * penetration * (linearInertia2 / totalInertia);
            projection = this.relativeContactPosition2.clone();
            Contact.addScaledVector(projection, this.contactNormal, -this.relativeContactPosition2.dot(this.contactNormal));
            maxMagnitude = angularLimit * projection.length();
            if (angularMove2 < -maxMagnitude) {
                totalMove = angularMove2 + linearMove2;
                angularMove2 = -maxMagnitude;
                linearMove2 = totalMove - angularMove2;
            } else if (angularMove2 > maxMagnitude) {
                totalMove = angularMove2 + linearMove2;
                angularMove2 = maxMagnitude;
                linearMove2 = totalMove - angularMove2;
            }
            if (angularMove2 == 0.0) {
                angular2.set(0.0, 0.0, 0.0);
            } else {
                Vec3d targetAngularDirection = this.relativeContactPosition2.cross(this.contactNormal);
                iit = this.body2.getInverseInertiaTensorWorld();
                angular2.set(iit.mult(targetAngularDirection).multLocal(angularMove2 / angularInertia2));
            }
            double vLimit = 15.0;
            if (linearMove2 > vLimit) {
                linearMove2 = vLimit;
            }
            linear2.set(this.contactNormal.mult(linearMove2));
            pos = this.body2.getPosition().clone();
            Contact.addScaledVector(pos, this.contactNormal, linearMove2);
            this.body2.setPosition(pos);
            q = this.body2.getOrientation();
            Contact.addScaledVector(q, angular2, 1.0);
            this.body2.setOrientation(q);
            if (!this.body2.isAwake()) {
                this.body2.calculateDerivedData();
            }
        }
    }

    protected Vec3d calculateFrictionlessImpulse(Matrix3d iit1, Matrix3d iit2) {
        Vec3d impContact = new Vec3d();
        Vec3d vDeltaWorld = this.relativeContactPosition1.cross(this.contactNormal);
        vDeltaWorld = iit1.mult(vDeltaWorld);
        vDeltaWorld = vDeltaWorld.cross(this.relativeContactPosition1);
        double vDelta = vDeltaWorld.dot(this.contactNormal);
        vDelta += this.body1.getInverseMass();
        if (this.body2 != null) {
            vDeltaWorld = this.relativeContactPosition2.cross(this.contactNormal);
            vDeltaWorld = iit2.mult(vDeltaWorld);
            vDeltaWorld = vDeltaWorld.cross(this.relativeContactPosition2);
            vDelta += vDeltaWorld.dot(this.contactNormal);
            vDelta += this.body2.getInverseMass();
        }
        impContact.x = this.desiredDeltaVelocity / vDelta;
        return impContact;
    }

    public static void setSkewSymmetric(Matrix3d target, Vec3d v) {
        target.m00 = 0.0;
        target.m11 = 0.0;
        target.m22 = 0.0;
        target.m01 = -v.z;
        target.m02 = v.y;
        target.m10 = v.z;
        target.m12 = -v.x;
        target.m20 = -v.y;
        target.m21 = v.x;
    }

    public static void add(Matrix3d m1, Matrix3d m2) {
        m1.m00 += m2.m00;
        m1.m01 += m2.m01;
        m1.m02 += m2.m02;
        m1.m10 += m2.m10;
        m1.m11 += m2.m11;
        m1.m12 += m2.m12;
        m1.m20 += m2.m20;
        m1.m21 += m2.m21;
        m1.m22 += m2.m22;
    }

    protected Vec3d calculateFrictionImpulse(Matrix3d iit1, Matrix3d iit2) {
        double invMass = this.body1.getInverseMass();
        Matrix3d impToTorque = new Matrix3d();
        Contact.setSkewSymmetric(impToTorque, this.relativeContactPosition1);
        Matrix3d vDeltaWorld = impToTorque.clone();
        vDeltaWorld.multLocal(iit1);
        vDeltaWorld.multLocal(impToTorque);
        vDeltaWorld.multLocal(-1.0);
        if (this.body2 != null) {
            Contact.setSkewSymmetric(impToTorque, this.relativeContactPosition2);
            Matrix3d vDeltaWorld2 = impToTorque.clone();
            vDeltaWorld2.multLocal(iit2);
            vDeltaWorld2.multLocal(impToTorque);
            vDeltaWorld2.multLocal(-1.0);
            Contact.add(vDeltaWorld, vDeltaWorld2);
            invMass += this.body2.getInverseMass();
        }
        Matrix3d vDelta = this.contactToWorld.transpose();
        vDelta.multLocal(vDeltaWorld);
        vDelta.multLocal(this.contactToWorld);
        vDelta.m00 += invMass;
        vDelta.m11 += invMass;
        vDelta.m22 += invMass;
        Matrix3d impMatrix = vDelta.invert();
        Vec3d velKill = new Vec3d(this.desiredDeltaVelocity, -this.contactVelocity.y, -this.contactVelocity.z);
        Vec3d impContact = impMatrix.mult(velKill);
        double planarImp = Math.sqrt(impContact.y * impContact.y + impContact.z * impContact.z);
        if (planarImp > impContact.x * this.friction) {
            impContact.y /= planarImp;
            impContact.z /= planarImp;
            impContact.x = vDelta.m00 + vDelta.m01 * this.friction * impContact.y + vDelta.m02 * this.friction * impContact.z;
            impContact.x = this.desiredDeltaVelocity / impContact.x;
            impContact.y *= this.friction * impContact.x;
            impContact.z *= this.friction * impContact.x;
        }
        return impContact;
    }
}

