/*
 * Decompiled with CFR 0.152.
 */
package mythruna.phys.proto;

import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mythruna.BlockType;
import mythruna.BlockTypeIndex;
import mythruna.Coordinates;
import mythruna.Vector3i;
import mythruna.World;
import mythruna.db.BlueprintData;
import mythruna.db.LeafData;
import mythruna.es.Entity;
import mythruna.es.EntityData;
import mythruna.es.EntityId;
import mythruna.es.EntitySet;
import mythruna.es.ModelInfo;
import mythruna.es.Position;
import mythruna.mathd.Matrix3d;
import mythruna.mathd.Quatd;
import mythruna.mathd.Vec3d;
import mythruna.phys.proto.Contact;
import mythruna.phys.proto.ContactDebug;
import mythruna.phys.proto.ContactGenerator;
import mythruna.phys.proto.ContactGenerators;
import mythruna.phys.proto.ContactResolver;
import mythruna.phys.proto.Mobile;
import mythruna.phys.proto.PhysicsDebug;
import mythruna.phys.proto.RigidBody;
import mythruna.phys.proto.SourceLink;
import mythruna.phys.proto.TargetLink;
import org.progeeks.util.log.Log;

public class ProtoPhysicsSystem
implements Runnable {
    static Log log = Log.getLog();
    private static boolean debugOn = true;
    private EntityData ed;
    private long physTime;
    private double secs;
    private ContactResolver resolver;
    private EntitySet mobs;
    private EntitySet links;
    private Map<EntityId, RigidBody> bodies = new HashMap<EntityId, RigidBody>();
    private Map<EntityId, ContactGenerator> generators = new HashMap<EntityId, ContactGenerator>();
    private List<Contact> contacts = new ArrayList<Contact>();
    private List<EntityId> debugContacts = new ArrayList<EntityId>();
    private int debugContactsInUse = 0;
    private World world;
    private long currentTime;

    public ProtoPhysicsSystem(long physTime, EntityData ed, World world) {
        this.physTime = physTime;
        this.secs = (double)physTime / 1000.0;
        this.ed = ed;
        this.resolver = new ContactResolver();
        this.world = world;
    }

    public void initialize() {
        this.mobs = this.ed.getEntities(Mobile.class, Position.class);
        this.links = this.ed.getEntities(SourceLink.class, TargetLink.class, Mobile.class);
    }

    @Override
    public void run() {
        try {
            this.currentTime = System.currentTimeMillis();
            long start = System.nanoTime();
            this.update(this.secs);
            long end = System.nanoTime();
            double ms = (double)(end - start) / 1000000.0;
            if (ms > this.secs * 1000.0) {
                System.out.println("Frame length:" + ms + " ms");
            }
        }
        catch (RuntimeException e) {
            log.error((Object)"Error updating physics", (Throwable)e);
            throw e;
        }
    }

    protected Position getPosition(Entity e) {
        Position p = e.get(Position.class);
        if (p != null) {
            return p;
        }
        return null;
    }

    protected RigidBody getBody(EntityId id) {
        RigidBody result = this.bodies.get(id);
        if (result != null) {
            return result;
        }
        return this.getBody(this.ed.getEntity(id, Position.class, Mobile.class));
    }

    protected RigidBody getBody(Entity entity) {
        RigidBody result = this.bodies.get(entity.getId());
        if (result != null) {
            return result;
        }
        result = new RigidBody(entity.getId());
        ModelInfo mi = this.ed.getComponent(entity.getId(), ModelInfo.class);
        System.out.println("********** Entity:" + entity.getId() + "   Model:" + mi);
        double mass = 10.0;
        Vec3d halfExtents = new Vec3d(0.25, 0.25, 0.25);
        if (entity.getId().getId() < 0L) {
            result.setInverseMass(0.0);
        } else if (mi != null) {
            System.out.println("Building model mass data...");
            BlueprintData data = this.world.getBlueprint(mi.getBlueprintId());
            result.setMesh(data);
            result.setAcceleration(0.0, -20.0, 0.0);
            halfExtents.x = (double)data.xSize * 0.5;
            halfExtents.y = (double)data.zSize * 0.5;
            halfExtents.z = (double)data.ySize * 0.5;
            int[][][] cells = data.cells;
            int xSize = data.xSize;
            int ySize = data.ySize;
            int zSize = data.zSize;
            double massScale = data.scale * data.scale * data.scale;
            System.out.println("************* massScale:" + massScale);
            double totalMass = 0.0;
            Vec3d center = new Vec3d();
            for (int i = 0; i < xSize; ++i) {
                for (int j = 0; j < ySize; ++j) {
                    for (int k = 0; k < zSize; ++k) {
                        BlockType type;
                        int t = cells[i][j][k];
                        if (t == 0 || (type = BlockTypeIndex.types[t]) == null) continue;
                        double m = type.getMaterial().getMass();
                        System.out.println("t:" + t + " @ " + i + ", " + j + ", " + k + "  mass/cu.m.:" + m);
                        System.out.println("  portion:" + type.getGeomFactory().getMassPortion());
                        System.out.println("  min:" + type.getGeomFactory().getMin() + "  max:" + type.getGeomFactory().getMax());
                        m = m * type.getGeomFactory().getMassPortion() * massScale;
                        totalMass += m;
                        center.addLocal((double)i * m, (double)k * m, (double)j * m);
                    }
                }
            }
            System.out.println("Total mass:" + totalMass);
            System.out.println("Center of mass before:" + center);
            center.multLocal(1.0 / totalMass);
            System.out.println("Center of mass:" + center);
            center.x += 0.5;
            center.y += 0.5;
            center.z += 0.5;
            center.multLocal(data.scale);
            result.cog.set(center);
            System.out.println("Center of mass:" + center);
            result.setMass(totalMass);
        } else {
            result.setMass(mass);
            result.setAcceleration(0.0, -10.0, 0.0);
        }
        result.setDamping(0.9, 0.8);
        Mobile m = entity.get(Mobile.class);
        Position p = this.getPosition(entity);
        if (entity.getId().getId() >= 0L) {
            result.setCanSleep(true);
        } else {
            result.setCanSleep(false);
        }
        if (m != null) {
            result.setAwake(true);
        } else {
            result.setAwake(false);
        }
        Matrix3d tensor = new Matrix3d();
        Vec3d squares = halfExtents.mult(halfExtents);
        tensor.m00 = (double)0.3f * mass * (squares.y + squares.z);
        tensor.m11 = (double)0.3f * mass * (squares.x + squares.z);
        tensor.m22 = (double)0.3f * mass * (squares.x + squares.y);
        result.setInertiaTensor(tensor);
        Vector3f fPos = p.getLocation();
        Quaternion q = p.getRotation();
        result.setPosition(fPos.x, fPos.z, fPos.y);
        result.setOrientation(new Quatd(q.getX(), q.getY(), q.getZ(), q.getW()));
        result.calculateDerivedData();
        this.bodies.put(entity.getId(), result);
        return result;
    }

    protected void updatePosition(RigidBody body) {
        Position p = this.ed.getComponent(body.getEntityId(), Position.class);
        Vector3f fPos = p.getLocation();
        Quaternion q = p.getRotation();
        body.setPosition(fPos.x, fPos.z, fPos.y);
        body.setOrientation(new Quatd(q.getX(), q.getY(), q.getZ(), q.getW()));
    }

    protected void pushPosition(RigidBody body) {
        Vec3d pos = body.getPosition().clone();
        Quatd q = body.getOrientation();
        BlueprintData bp = body.getMesh();
        Vec3d origin = body.cog.mult(-1.0);
        Vec3d offset = origin.add((double)(bp.scale * (float)bp.xSize) * 0.5, 0.0, (double)(bp.scale * (float)bp.ySize) * 0.5);
        offset = q.mult(offset);
        pos.addLocal(offset);
        Vector3f fPos = new Vector3f((float)pos.x, (float)pos.z, (float)pos.y);
        Quaternion fRot = new Quaternion((float)q.x, (float)q.y, (float)q.z, (float)q.w);
        this.ed.setComponent(body.getEntityId(), new Position(fPos, fRot));
    }

    protected void updateDebugState(RigidBody body) {
        if (!debugOn) {
            return;
        }
        PhysicsDebug.PhysicsState state = null;
        state = body.isStatic() ? PhysicsDebug.PhysicsState.STATIC : (body.isAwake() ? PhysicsDebug.PhysicsState.AWAKE : PhysicsDebug.PhysicsState.SLEEPING);
        if (body.debugState != state) {
            body.debugState = state;
            System.out.println("************* setting physics debug:" + (Object)((Object)state));
            this.ed.setComponent(body.getEntityId(), new PhysicsDebug(state, 1.0));
        }
    }

    protected ContactGenerator getGenerator(Entity e) {
        ContactGenerator result = this.generators.get(e.getId());
        if (result != null) {
            return result;
        }
        SourceLink source = e.get(SourceLink.class);
        Vector3f v1 = source.getOffset();
        TargetLink target = e.get(TargetLink.class);
        Vector3f v2 = target.getOffset();
        RigidBody b1 = this.getBody(source.getSource());
        RigidBody b2 = this.getBody(target.getTarget());
        Vec3d sourceOffset = new Vec3d(v1.x, v1.y, v1.z);
        if (b1.getMesh() != null) {
            Vec3d origin = b1.cog.mult(-1.0);
            BlueprintData bp = b1.getMesh();
            Vec3d offset = origin.add(bp.scale * (float)bp.xSize / 2.0f, 0.0, bp.scale * (float)bp.ySize / 2.0f);
            sourceOffset.addLocal(offset);
        }
        Vec3d targetOffset = new Vec3d(v2.x, v2.y, v2.z);
        if (b2.getMesh() != null) {
            Vec3d origin = b2.cog.mult(-1.0);
            BlueprintData bp = b2.getMesh();
            Vec3d offset = origin.add(bp.scale * (float)bp.xSize / 2.0f, 0.0, bp.scale * (float)bp.ySize / 2.0f);
            targetOffset.addLocal(offset);
        }
        result = ContactGenerators.hardLink(b2, targetOffset, b1, sourceOffset, 0.1);
        this.generators.put(e.getId(), result);
        return result;
    }

    protected final void generateContacts() {
        this.contacts.clear();
        Vec3d up = new Vec3d(0.0, 1.0, 0.0);
        double offset = 77.0;
        double radius = 0.25;
        for (RigidBody b : this.bodies.values()) {
            if (b.isStatic() || !b.isAwake()) continue;
            this.generateWorldContacts(b);
        }
        ArrayList<RigidBody> list = new ArrayList<RigidBody>(this.bodies.values());
        for (int i = 0; i < list.size(); ++i) {
            RigidBody b1 = (RigidBody)list.get(i);
            for (int j = i + 1; j < list.size(); ++j) {
                RigidBody b2 = (RigidBody)list.get(j);
                this.generateBodyContacts(b1, b2);
            }
        }
        for (ContactGenerator g : this.generators.values()) {
            g.addContacts(this.contacts);
        }
    }

    protected final boolean bodyBroadPhase(RigidBody b1, RigidBody b2) {
        Vec3d sep = b2.getPosition().subtract(b1.getPosition());
        double d = sep.lengthSq();
        return d < b2.getMaxRadius() + b1.getMaxRadius();
    }

    protected final void generateBodyContacts(RigidBody b1, RigidBody b2) {
        if (!this.bodyBroadPhase(b1, b2) || b1.getMesh() == null || b2.getMesh() == null) {
            return;
        }
        System.out.println("Hit.");
        if (b1.getVolume() < b2.getVolume()) {
            RigidBody temp = b2;
            b2 = b1;
            b1 = temp;
        }
        BlueprintData bp1 = b1.getMesh();
        BlueprintData bp2 = b2.getMesh();
        double scale1 = bp1.scale;
        double scale2 = bp2.scale;
        double cellRadius1 = scale1 * 0.5;
        double cellRadius2 = scale2 * 0.5;
        int[][][] cells1 = bp1.cells;
        int[][][] cells2 = bp2.cells;
        Vec3d xModel = new Vec3d(scale2, 0.0, 0.0);
        Vec3d yModel = new Vec3d(0.0, scale2, 0.0);
        Vec3d zModel = new Vec3d(0.0, 0.0, scale2);
        xModel = b2.getOrientation().mult(xModel);
        yModel = b2.getOrientation().mult(yModel);
        zModel = b2.getOrientation().mult(zModel);
        Quatd inverse = b1.getOrientation().inverse();
        xModel = inverse.mult(xModel);
        yModel = inverse.mult(yModel);
        zModel = inverse.mult(zModel);
        double invScale1 = 1.0 / scale1;
        xModel.multLocal(invScale1);
        yModel.multLocal(invScale1);
        zModel.multLocal(invScale1);
        double cellRadius2in1 = invScale1 * cellRadius2;
        Vec3d b2Origin = new Vec3d();
        b2Origin.subtractLocal(b2.cog);
        b2Origin.x += cellRadius2;
        b2Origin.y += cellRadius2;
        b2Origin.z += cellRadius2;
        b2Origin = b2.getOrientation().mult(b2Origin);
        b2Origin.addLocal(b2.getPosition());
        Vec3d base = b2Origin.subtract(b1.getPosition());
        base = inverse.mult(base);
        base.addLocal(b1.cog);
        base.multLocal(invScale1);
        Vec3d px = base.clone();
        Vec3d py = new Vec3d();
        Vec3d pz = new Vec3d();
        double min = Double.POSITIVE_INFINITY;
        Object dir = null;
        Vec3d contact = new Vec3d();
        Vec3d inCell = new Vec3d();
        Vec3d signs = new Vec3d();
        for (int i = 0; i < bp2.xSize; ++i) {
            py.set(px);
            for (int j = 0; j < bp2.ySize; ++j) {
                pz.set(py);
                for (int k = 0; k < bp2.zSize; ++k) {
                    int val = cells2[i][j][k];
                    if (val != 0) {
                        int x = Coordinates.worldToCell(pz.x);
                        int y = Coordinates.worldToCell(pz.z);
                        int z = Coordinates.worldToCell(pz.y);
                        this.clip(x, y, z, pz, inCell, signs);
                        boolean xOverlap = inCell.x < cellRadius2in1;
                        boolean yOverlap = inCell.y < cellRadius2in1;
                        boolean zOverlap = inCell.z < cellRadius2in1;
                        boolean main = this.checkBlueprint(b1, b2, x, y, z, bp1, pz, inCell, signs, cellRadius2in1, true, true, true);
                        int xs = (int)signs.x;
                        int ys = (int)signs.y;
                        int zs = (int)signs.z;
                        boolean found = false;
                        if (xOverlap) {
                            this.clip(x + xs, y, z, pz, inCell, signs);
                            found |= this.checkBlueprint(b1, b2, x + xs, y, z, bp1, pz, inCell, signs, cellRadius2in1, true, false, false);
                        }
                        if (yOverlap) {
                            this.clip(x, y, z + ys, pz, inCell, signs);
                            found |= this.checkBlueprint(b1, b2, x, y, z + ys, bp1, pz, inCell, signs, cellRadius2in1, false, true, false);
                        }
                        if (zOverlap) {
                            this.clip(x, y + zs, z, pz, inCell, signs);
                            found |= this.checkBlueprint(b1, b2, x, y + zs, z, bp1, pz, inCell, signs, cellRadius2in1, false, false, true);
                        }
                        if (xOverlap && yOverlap) {
                            this.clip(x + xs, y, z + ys, pz, inCell, signs);
                            this.checkBlueprint(b1, b2, x + xs, y, z + ys, bp1, pz, inCell, signs, cellRadius2in1, true, true, false);
                        }
                        if (xOverlap && zOverlap) {
                            this.clip(x + xs, y + zs, z, pz, inCell, signs);
                            this.checkBlueprint(b1, b2, x + xs, y + zs, z, bp1, pz, inCell, signs, cellRadius2in1, true, false, true);
                        }
                        if (yOverlap && zOverlap) {
                            this.clip(x, y + zs, z + ys, pz, inCell, signs);
                            this.checkBlueprint(b1, b2, x, y + zs, z + ys, bp1, pz, inCell, signs, cellRadius2in1, false, true, true);
                        }
                        if (xOverlap && yOverlap && zOverlap) {
                            this.clip(x + xs, y + zs, z + ys, pz, inCell, signs);
                            this.checkBlueprint(b1, b2, x + xs, y + zs, z + ys, bp1, pz, inCell, signs, cellRadius2in1, true, true, true);
                        }
                    }
                    pz.addLocal(yModel);
                }
                py.addLocal(zModel);
            }
            px.addLocal(xModel);
        }
    }

    private int getType(BlueprintData bp, int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0) {
            return 0;
        }
        if (x >= bp.xSize || y >= bp.ySize || z >= bp.zSize) {
            return 0;
        }
        return bp.cells[x][y][z];
    }

    private boolean checkBlueprint(RigidBody b1, RigidBody b2, int x, int y, int z, BlueprintData bp, Vec3d pos, Vec3d inCell, Vec3d signs, double cellRadius, boolean xCheck, boolean yCheck, boolean zCheck) {
        int t = this.getType(bp, x, y, z);
        if (t == 0) {
            return false;
        }
        double xd = inCell.x + cellRadius;
        double yd = inCell.y + cellRadius;
        double zd = inCell.z + cellRadius;
        double xs = signs.x;
        double ys = signs.y;
        double zs = signs.z;
        Vec3d normal = new Vec3d();
        double penetration = Double.POSITIVE_INFINITY;
        Vec3d contact = new Vec3d();
        if (xCheck) {
            contact.x = x;
            contact.y = pos.y;
            contact.z = pos.z;
            if (xs > 0.0) {
                contact.x += 1.0;
            }
            normal.x = xs;
            normal.y = 0.0;
            normal.z = 0.0;
            penetration = xd;
        }
        if (yCheck && yd < penetration) {
            contact.x = pos.x;
            contact.y = z;
            contact.z = pos.z;
            if (ys > 0.0) {
                contact.y += 1.0;
            }
            normal.x = 0.0;
            normal.y = ys;
            normal.z = 0.0;
            penetration = yd;
        }
        if (zCheck && zd < penetration) {
            contact.x = pos.x;
            contact.y = pos.y;
            contact.z = y;
            if (zs > 0.0) {
                contact.z += 1.0;
            }
            normal.x = 0.0;
            normal.y = 0.0;
            normal.z = zs;
            penetration = zd;
        }
        if (penetration < Double.POSITIVE_INFINITY) {
            Contact c = new Contact();
            c.contactNormal = b1.getWorldDirection(normal);
            double scale = bp.scale;
            c.penetration = penetration * scale;
            contact.multLocal(scale);
            contact.subtractLocal(b1.cog);
            contact = b1.getOrientation().mult(contact);
            contact.addLocal(b1.getPosition());
            c.contactPoint = contact;
            c.setBodyData(b2, b1, 0.95, 0.05);
            this.contacts.add(c);
            return true;
        }
        return false;
    }

    protected final boolean worldBroadPhase(RigidBody b) {
        double maxRadius = b.getMaxRadius();
        Vec3d minPos = b.getPosition().subtract(maxRadius, maxRadius, maxRadius);
        Vec3d maxPos = b.getPosition().add(maxRadius, maxRadius, maxRadius);
        Vector3i minCell = Coordinates.physToCell(minPos);
        Vector3i maxCell = Coordinates.physToCell(maxPos);
        for (int i = minCell.x; i <= maxCell.x; ++i) {
            for (int j = minCell.y; j <= maxCell.y; ++j) {
                for (int k = minCell.z; k <= maxCell.z; ++k) {
                    BlockType type;
                    int t = this.world.getType(i, j, k, (LeafData)null);
                    if (t == 0 || (type = BlockTypeIndex.types[t]) == null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void clip(int x, int y, int z, Vec3d pos, Vec3d inCell, Vec3d signs) {
        double xd = pos.x - (double)x;
        double xs = -1.0;
        if (xd > 0.5) {
            xd = 1.0 - xd;
            xs = 1.0;
        }
        double yd = pos.y - (double)z;
        double ys = -1.0;
        if (yd > 0.5) {
            yd = 1.0 - yd;
            ys = 1.0;
        }
        double zd = pos.z - (double)y;
        double zs = -1.0;
        if (zd > 0.5) {
            zd = 1.0 - zd;
            zs = 1.0;
        }
        inCell.set(xd, yd, zd);
        signs.set(xs, ys, zs);
    }

    private boolean checkWorld(RigidBody b, int x, int y, int z, Vec3d pos, Vec3d inCell, Vec3d signs, double cellRadius, boolean xCheck, boolean yCheck, boolean zCheck) {
        int t = this.world.getType(x, y, z, (LeafData)null);
        if (t == 0) {
            return false;
        }
        double xd = inCell.x + cellRadius;
        double yd = inCell.y + cellRadius;
        double zd = inCell.z + cellRadius;
        double xs = signs.x;
        double ys = signs.y;
        double zs = signs.z;
        Vec3d normal = new Vec3d();
        double penetration = Double.POSITIVE_INFINITY;
        Vec3d contact = new Vec3d();
        if (xCheck) {
            contact.x = x;
            contact.y = pos.y;
            contact.z = pos.z;
            if (xs > 0.0) {
                contact.x += 1.0;
            }
            normal.x = xs;
            normal.y = 0.0;
            normal.z = 0.0;
            penetration = xd;
        }
        if (yCheck && yd < penetration) {
            contact.x = pos.x;
            contact.y = z;
            contact.z = pos.z;
            if (ys > 0.0) {
                contact.y += 1.0;
            }
            normal.x = 0.0;
            normal.y = ys;
            normal.z = 0.0;
            penetration = yd;
        }
        if (zCheck && zd < penetration) {
            contact.x = pos.x;
            contact.y = pos.y;
            contact.z = y;
            if (zs > 0.0) {
                contact.z += 1.0;
            }
            normal.x = 0.0;
            normal.y = 0.0;
            normal.z = zs;
            penetration = zd;
        }
        if (penetration < Double.POSITIVE_INFINITY) {
            Contact c = new Contact();
            c.contactNormal = normal;
            c.penetration = penetration;
            c.contactPoint = contact;
            c.setBodyData(b, null, 0.95, 0.05);
            this.contacts.add(c);
            return true;
        }
        return false;
    }

    protected final void generateWorldContacts(RigidBody b) {
        if (!this.worldBroadPhase(b)) {
            return;
        }
        Vec3d xWorld = new Vec3d(1.0, 0.0, 0.0);
        Vec3d yWorld = new Vec3d(0.0, 1.0, 0.0);
        Vec3d zWorld = new Vec3d(0.0, 0.0, 1.0);
        Vec3d xModel = b.getOrientation().mult(xWorld);
        Vec3d yModel = b.getOrientation().mult(yWorld);
        Vec3d zModel = b.getOrientation().mult(zWorld);
        BlueprintData bp = b.getMesh();
        double scale = bp.scale;
        double cellRadius = scale * 0.5;
        int[][][] cells = bp.cells;
        Vec3d base = new Vec3d();
        base.subtractLocal(b.cog);
        base.x += cellRadius;
        base.y += cellRadius;
        base.z += cellRadius;
        base = b.getOrientation().mult(base);
        base.addLocal(b.getPosition());
        xModel.multLocal(scale);
        yModel.multLocal(scale);
        zModel.multLocal(scale);
        Vec3d px = base.clone();
        Vec3d py = new Vec3d();
        Vec3d pz = new Vec3d();
        double min = Double.POSITIVE_INFINITY;
        Object dir = null;
        Vec3d contact = new Vec3d();
        Vec3d inCell = new Vec3d();
        Vec3d signs = new Vec3d();
        for (int i = 0; i < bp.xSize; ++i) {
            py.set(px);
            for (int j = 0; j < bp.ySize; ++j) {
                pz.set(py);
                for (int k = 0; k < bp.zSize; ++k) {
                    int val = cells[i][j][k];
                    if (val != 0) {
                        int x = Coordinates.worldToCell(pz.x);
                        int y = Coordinates.worldToCell(pz.z);
                        int z = Coordinates.worldToCell(pz.y);
                        this.clip(x, y, z, pz, inCell, signs);
                        boolean xOverlap = inCell.x < cellRadius;
                        boolean yOverlap = inCell.y < cellRadius;
                        boolean zOverlap = inCell.z < cellRadius;
                        boolean main = this.checkWorld(b, x, y, z, pz, inCell, signs, cellRadius, true, true, true);
                        int xs = (int)signs.x;
                        int ys = (int)signs.y;
                        int zs = (int)signs.z;
                        if (xOverlap) {
                            this.clip(x + xs, y, z, pz, inCell, signs);
                            this.checkWorld(b, x + xs, y, z, pz, inCell, signs, cellRadius, true, false, false);
                        }
                        if (yOverlap) {
                            this.clip(x, y, z + ys, pz, inCell, signs);
                            this.checkWorld(b, x, y, z + ys, pz, inCell, signs, cellRadius, false, true, false);
                        }
                        if (zOverlap) {
                            this.clip(x, y + zs, z, pz, inCell, signs);
                            this.checkWorld(b, x, y + zs, z, pz, inCell, signs, cellRadius, false, false, true);
                        }
                    }
                    pz.addLocal(yModel);
                }
                py.addLocal(zModel);
            }
            px.addLocal(xModel);
        }
    }

    protected final void resolveContacts(double time) {
        this.resolver.resolveContacts(this.contacts, time);
    }

    protected final void publishContacts() {
        EntityId e;
        int i;
        for (i = 0; i < this.contacts.size(); ++i) {
            Contact c = this.contacts.get(i);
            e = null;
            if (i < this.debugContacts.size()) {
                e = this.debugContacts.get(i);
            } else {
                e = this.ed.createEntity();
                this.debugContacts.add(e);
            }
            ContactDebug cb = new ContactDebug(c);
            this.ed.setComponent(e, cb);
        }
        int inUse = i;
        while (i < this.debugContacts.size()) {
            e = this.debugContacts.get(i);
            this.ed.setComponent(e, new ContactDebug(false));
            ++i;
        }
        this.debugContactsInUse = inUse;
    }

    public void update(double time) {
        if (this.mobs.applyChanges()) {
            // empty if block
        }
        if (this.links.applyChanges()) {
            for (Entity e : this.links.getAddedEntities()) {
                System.out.println("Added link:" + e);
                ContactGenerator g = this.getGenerator(e);
                System.out.println("   generator:" + g);
            }
            for (Entity e : this.links.getRemovedEntities()) {
                System.out.println("Removed link:" + e);
                this.generators.remove(e.getId());
            }
            if (!this.links.getChangedEntities().isEmpty()) {
                System.out.println("----------Links Changed:" + this.links.getChangedEntities());
            }
        }
        long start = System.nanoTime();
        for (RigidBody b : this.bodies.values()) {
            if (b.getEntityId().getId() < 0L) {
                this.updatePosition(b);
            } else if (debugOn) {
                this.updateDebugState(b);
            }
            b.integrate(time);
        }
        long lap = System.nanoTime();
        long integrationTime = lap - start;
        start = lap;
        this.generateContacts();
        lap = System.nanoTime();
        long genContactsTime = lap - start;
        start = lap;
        if (debugOn) {
            this.publishContacts();
        }
        lap = System.nanoTime();
        long pubContactsTime = lap - start;
        start = lap;
        this.resolveContacts(time);
        lap = System.nanoTime();
        long resolveContactsTime = lap - start;
        start = lap;
        for (RigidBody b : this.bodies.values()) {
            if (b.getEntityId().getId() < 0L || !b.isAwake()) continue;
            this.pushPosition(b);
        }
        lap = System.nanoTime();
        long updatePositionTime = lap - start;
        start = lap;
    }
}

