/*
 * Decompiled with CFR 0.152.
 */
package mythruna.script;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptException;
import org.progeeks.util.StringUtils;
import org.progeeks.util.log.Log;

public abstract class AbstractScriptManager {
    static Log log = Log.getLog();
    private List<Object> scripts = new ArrayList<Object>();
    private String scriptExtension;
    private Bindings bindings;

    public AbstractScriptManager(String scriptExtension, Object ... scripts) {
        this.scriptExtension = scriptExtension;
        this.scripts.addAll(Arrays.asList(scripts));
        this.bindings = this.createBindings();
        this.bindings.put("bindings", (Object)this.bindings);
        this.bindings.put("scripts", (Object)this);
    }

    public void copySettingsTo(AbstractScriptManager to) {
        to.scripts.addAll(this.scripts);
        to.scriptExtension = this.scriptExtension;
        to.bindings.putAll(this.bindings);
        to.bindings.put("bindings", (Object)to.bindings);
        to.bindings.put("scripts", (Object)to);
    }

    protected abstract Bindings createBindings();

    protected abstract void applyEngineBindings(Bindings var1);

    protected abstract void eval(String var1);

    protected abstract void addClasspath(String var1);

    public void setBinding(String name, Object value) {
        this.bindings.put(name, value);
    }

    public void setScriptExtension(String ext) {
        this.scriptExtension = ext.startsWith(".") ? ext : "." + ext;
    }

    public void addScript(Object o) {
        this.scripts.add(o);
    }

    protected void initializeResource(String s) throws IOException, ScriptException {
        String initScript = StringUtils.readStringResource(this.getClass(), (String)s);
        System.out.println("Running:" + s);
        this.eval(initScript);
    }

    protected void initializeFile(File f) throws IOException, ScriptException {
        if (f.isDirectory()) {
            this.initializeDirectory(f);
            return;
        }
        if (!f.exists()) {
            log.warn((Object)("Script file or directory does not exist:" + f));
            return;
        }
        System.out.println("Running:" + f);
        String script = StringUtils.readFile((File)f);
        this.eval(script);
    }

    protected void initializeDirectory(File d) throws IOException, ScriptException {
        File[] init;
        this.addClasspath(d.getPath());
        File[] libs = new File(d, "lib").listFiles();
        if (libs != null) {
            for (File f : libs) {
                if (!f.getName().endsWith(".jar")) continue;
                log.info((Object)("Adding script dependency:" + f));
                this.addClasspath(f.getPath());
            }
        }
        if ((init = d.listFiles()) != null) {
            for (File f : init) {
                if (!f.getName().endsWith(this.scriptExtension)) continue;
                this.initializeFile(f);
            }
        }
    }

    public void initialize() {
        this.applyEngineBindings(this.bindings);
        for (int i = 0; i < this.scripts.size(); ++i) {
            Object o = this.scripts.get(i);
            try {
                if (o instanceof String) {
                    this.initializeResource((String)o);
                    continue;
                }
                if (o instanceof File) {
                    this.initializeFile((File)o);
                    continue;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error processing script resource:" + o, e);
            }
            throw new RuntimeException("Unknown resource type:" + o);
        }
    }
}

