/*
 * Decompiled with CFR 0.152.
 */
package mythruna.script;

import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import mythruna.es.EntityId;
import mythruna.script.DialogOption;
import mythruna.script.DialogPrompt;
import org.codehaus.groovy.jsr223.GroovyScriptEngineImpl;
import org.progeeks.util.StringUtils;
import org.progeeks.util.log.Log;

public class DialogManager {
    static Log log = Log.getLog();
    private List<Object> initScripts = new ArrayList<Object>();
    private List<String> scripts = new ArrayList<String>();
    private List<String> classpaths = new ArrayList<String>();
    private Map<String, Object> dialogs = new ConcurrentHashMap<String, Object>();
    private Map<EntityId, PlayerEnvironment> envs = new ConcurrentHashMap<EntityId, PlayerEnvironment>();
    private List<Object> roots = new ArrayList<Object>();
    private Map<String, Object> defaultBindings;
    private ScriptEngineManager factory;

    public DialogManager(File root, Object ... startupScripts) {
        this.roots.add(root);
        this.initScripts.addAll(Arrays.asList(startupScripts));
        this.factory = new ScriptEngineManager();
        this.defaultBindings = new HashMap<String, Object>();
        this.defaultBindings.put("bindings", this.defaultBindings);
        this.defaultBindings.put("scripts", this);
    }

    public void addRoot(Object root) {
        this.roots.add(root);
    }

    public void setBinding(String name, Object value) {
        this.defaultBindings.put(name, value);
    }

    public void addStartupScript(Object o) {
        this.initScripts.add(o);
    }

    protected String nameToScript(String name) {
        return name + ".dlg.groovy";
    }

    protected String readScript(String f) {
        try {
            for (Object o : this.roots) {
                File file;
                if (o instanceof String) {
                    InputStream in = this.getClass().getResourceAsStream(o + "/" + f);
                    if (in == null) continue;
                    return StringUtils.readString((Reader)new InputStreamReader(in));
                }
                if (!(o instanceof File) || !(file = new File((File)o, f)).exists()) continue;
                return StringUtils.readFile((File)file);
            }
            throw new RuntimeException("File not found for:" + f);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading dialog:" + f, e);
        }
    }

    protected PlayerEnvironment getEnv(EntityId player) throws ScriptException {
        PlayerEnvironment env = this.envs.get(player);
        if (env == null) {
            ScriptEngine se = this.factory.getEngineByName("groovy");
            env = new PlayerEnvironment(player, se);
            this.envs.put(player, env);
        }
        return env;
    }

    public void startDialog(EntityId player, String name) throws ScriptException {
        String script = (String)this.dialogs.get(name);
        if (script == null) {
            script = this.readScript(this.nameToScript(name));
            this.dialogs.put(name, script);
        }
        PlayerEnvironment env = this.getEnv(player);
        env.run(script);
    }

    public void selectOption(EntityId player, DialogPrompt prompt, int index, DialogOption option) {
        Closure c = option.getAction();
        if (c.getMaximumNumberOfParameters() > 1) {
            c.call(prompt, index);
        } else if (c.getMaximumNumberOfParameters() == 1) {
            c.call((Object)index);
        } else {
            c.call();
        }
    }

    protected void loadScriptResource(String s) throws IOException, ScriptException {
        String initScript = StringUtils.readStringResource(this.getClass(), (String)s);
        System.out.println("Adding:" + s);
        this.scripts.add(initScript);
    }

    protected void loadScriptFile(File f) throws IOException, ScriptException {
        if (f.isDirectory()) {
            this.loadDirectory(f);
            return;
        }
        if (!f.exists()) {
            log.warn((Object)("Script file or directory does not exist:" + f));
            return;
        }
        System.out.println("Adding:" + f);
        String script = StringUtils.readFile((File)f);
        this.scripts.add(script);
    }

    protected void loadDirectory(File d) throws IOException, ScriptException {
        File[] init;
        this.classpaths.add(d.getPath());
        File[] libs = new File(d, "lib").listFiles();
        if (libs != null) {
            for (File f : libs) {
                if (!f.getName().endsWith(".jar")) continue;
                log.info((Object)("Adding script dependency:" + f));
                this.classpaths.add(f.getPath());
            }
        }
        if ((init = d.listFiles()) != null) {
            for (File f : init) {
                if (!f.getName().endsWith(".init.groovy")) continue;
                this.loadScriptFile(f);
            }
        }
    }

    protected void initEngine(ScriptEngine engine) throws ScriptException {
        for (String s : this.classpaths) {
            ((GroovyScriptEngineImpl)engine).getClassLoader().addClasspath(s);
        }
        for (String s : this.scripts) {
            engine.eval(s);
        }
    }

    public void initialize() {
        for (int i = 0; i < this.initScripts.size(); ++i) {
            Object o = this.initScripts.get(i);
            try {
                if (o instanceof String) {
                    this.loadScriptResource((String)o);
                    continue;
                }
                if (o instanceof File) {
                    this.loadScriptFile((File)o);
                    continue;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error processing script resource:" + o, e);
            }
            throw new RuntimeException("Unknown resource type:" + o);
        }
    }

    private class PlayerEnvironment {
        private EntityId player;
        private ScriptEngine engine;
        private Bindings bindings;
        private Map options;

        public PlayerEnvironment(EntityId player, ScriptEngine engine) throws ScriptException {
            this.player = player;
            this.engine = engine;
            this.bindings = engine.createBindings();
            this.bindings.putAll(DialogManager.this.defaultBindings);
            this.bindings.put("player", (Object)player);
            this.options = new HashMap();
            this.bindings.put("options", (Object)this.options);
            engine.setBindings(this.bindings, 100);
            DialogManager.this.initEngine(engine);
        }

        public synchronized void run(String script) throws ScriptException {
            this.options.clear();
            this.engine.eval(script);
        }
    }
}

