/*
 * Decompiled with CFR 0.152.
 */
package mythruna.script;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import mythruna.es.EntityId;

public class ObjectTemplates {
    private Map<String, ObjectTemplate> templates = new ConcurrentHashMap<String, ObjectTemplate>();
    private Map<EntityId, ObjectTemplate> entities = new ConcurrentHashMap<EntityId, ObjectTemplate>();

    public ObjectTemplate getTemplate(String name) {
        return this.templates.get(name);
    }

    public ObjectTemplate getTemplate(EntityId id) {
        return this.entities.get(id);
    }

    public void addTemplate(ObjectTemplate template) {
        this.templates.put(template.getName(), template);
        this.entities.put(template.getClassEntity(), template);
    }

    public void compile() {
        for (ObjectTemplate t : this.templates.values()) {
            t.compile();
        }
    }

    public static interface ObjectTemplate {
        public String getName();

        public EntityId getClassEntity();

        public void compile();
    }
}

