/*
 * Decompiled with CFR 0.152.
 */
package mythruna.server;

import com.jme3.network.Client;
import com.jme3.network.Message;
import com.jme3.network.MessageConnection;
import com.jme3.network.MessageListener;
import com.jme3.network.Server;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public abstract class AbstractMessageDelegator<S>
implements MessageListener<S> {
    private Class delegateType;
    private Map<Class, Method> methods = new HashMap<Class, Method>();

    protected AbstractMessageDelegator(Class delegateType, boolean automap) {
        this.delegateType = delegateType;
        if (automap) {
            this.automap();
        }
    }

    public void register(Server server) {
        for (Class type : this.methods.keySet()) {
            server.addMessageListener((MessageListener)this, new Class[]{type});
        }
    }

    public void register(Client client) {
        for (Class type : this.methods.keySet()) {
            client.addMessageListener((MessageListener)this, new Class[]{type});
        }
    }

    protected Method findDelegate(String name, Class parameterType) {
        for (Method m : this.delegateType.getDeclaredMethods()) {
            Class<?>[] parms;
            if (!m.getName().equals(name) || (parms = m.getParameterTypes()).length != 2 || !MessageConnection.class.isAssignableFrom(parms[0]) || !parms[1].isAssignableFrom(parameterType)) continue;
            return m;
        }
        return null;
    }

    protected boolean allowName(String name) {
        return true;
    }

    public AbstractMessageDelegator<S> automap() {
        for (Method m : this.delegateType.getDeclaredMethods()) {
            Class<?>[] parms;
            if (!this.allowName(m.getName()) || (parms = m.getParameterTypes()).length != 2 || !MessageConnection.class.isAssignableFrom(parms[0]) || !Message.class.isAssignableFrom(parms[1])) continue;
            this.methods.put(parms[1], m);
        }
        return this;
    }

    public AbstractMessageDelegator<S> map(String ... methodNames) {
        HashSet<String> names = new HashSet<String>(Arrays.asList(methodNames));
        for (Method m : this.delegateType.getDeclaredMethods()) {
            Class<?>[] parms;
            if (!names.contains(m.getName()) || (parms = m.getParameterTypes()).length != 2 || !MessageConnection.class.isAssignableFrom(parms[0]) || !Message.class.isAssignableFrom(parms[1])) continue;
            this.methods.put(parms[1], m);
        }
        return this;
    }

    public AbstractMessageDelegator<S> map(Class messageType, String methodName) {
        Method m = this.findDelegate(methodName, messageType);
        if (m == null) {
            throw new RuntimeException("Method:" + methodName + " not found matching signature (MessageConnection, " + messageType.getName() + ")");
        }
        this.methods.put(messageType, m);
        return this;
    }

    protected Method getMethod(Class c) {
        Method m = this.methods.get(c);
        if (m != null) {
            return m;
        }
        return m;
    }

    protected abstract Object getSourceDelegate(S var1);

    public void messageReceived(S source, Message msg) {
        if (msg == null) {
            return;
        }
        Object delegate = this.getSourceDelegate(source);
        if (delegate == null) {
            return;
        }
        Method m = this.getMethod(msg.getClass());
        if (m == null) {
            throw new RuntimeException("Method now found for class:" + msg.getClass());
        }
        try {
            m.invoke(delegate, source, msg);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error executing:" + m, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error executing:" + m, e.getCause());
        }
    }
}

