/*
 * Decompiled with CFR 0.152.
 */
package mythruna.server;

import com.jme3.network.HostedConnection;
import com.jme3.network.Message;
import mythruna.PlayerContext;
import mythruna.msg.ConsoleMessage;
import mythruna.server.GameServer;
import mythruna.shell.Console;
import mythruna.shell.MemoryCommand;
import mythruna.shell.PlayerShellCommandProcessor;
import mythruna.shell.UptimeCommand;
import mythruna.shell.WhereCommand;
import mythruna.shell.WhoCommand;
import mythruna.sim.GameSimulation;
import org.progeeks.tool.console.PrintCommand;
import org.progeeks.tool.console.Shell;
import org.progeeks.tool.console.ShellCommand;
import org.progeeks.tool.console.ShellCommandProcessor;

public class HostedConnectionShell
extends Shell
implements Console {
    private GameServer server;
    private HostedConnection conn;

    public HostedConnectionShell(GameServer server, HostedConnection conn) {
        super("", (ShellCommandProcessor)new PlayerShellCommandProcessor(null));
        this.conn = conn;
        this.getShellEnvironment().getVariables().put("connection", conn);
        this.getShellEnvironment().getVariables().put("console", this);
        this.getShellEnvironment().getVariables().put("worldDb", server.getWorldDatabase());
        this.registerCommand("print", (ShellCommand)new PrintCommand());
        this.registerCommand("who", (ShellCommand)new WhoCommand(server, false));
        this.registerCommand("where", (ShellCommand)new WhereCommand(server));
        this.registerCommand("serverMem", (ShellCommand)new MemoryCommand());
        this.registerCommand("uptime", (ShellCommand)new UptimeCommand(server, true));
    }

    @Override
    public void setPlayerContext(PlayerContext context) {
        ((PlayerShellCommandProcessor)this.getShellEnvironment()).setPlayerContext(context);
    }

    @Override
    public void echo(Object s) {
        System.out.println("Sending to client:" + this.conn + "  message:" + s);
        ConsoleMessage m = new ConsoleMessage(GameSimulation.getTime(), -1, null, String.valueOf(s));
        this.conn.send(1, (Message)m);
    }

    @Override
    public void runCommand(String cmd) {
        this.execute(cmd);
    }
}

