/*
 * Decompiled with CFR 0.152.
 */
package mythruna.server;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.progeeks.util.log.Log;

public class Scheduler {
    static Log log = Log.getLog();
    private Map<String, TaskEntry> namedTasks = new ConcurrentHashMap<String, TaskEntry>();
    private ScheduledThreadPoolExecutor executor;

    public Scheduler(int poolSize) {
        this.executor = new ScheduledThreadPoolExecutor(poolSize);
    }

    public void shutdown() {
        log.info((Object)"Shutting down scheduler.");
        this.executor.shutdown();
        log.info((Object)"Scheduler shutdown.");
    }

    public synchronized void scheduleNamedTask(String name, long minTime, Runnable r) {
        TaskEntry e = this.namedTasks.get(name);
        if (e == null) {
            e = new TaskEntry(name);
            this.namedTasks.put(name, e);
        }
        e.scheduleNext(r, minTime);
    }

    public void cancelNamedTask(String name) {
        TaskEntry e = this.namedTasks.remove(name);
        if (e == null) {
            return;
        }
        e.cancel();
    }

    public ScheduledThreadPoolExecutor getExecutor() {
        return this.executor;
    }

    private class TaskEntry
    implements Runnable {
        String name;
        long lastRuntime;
        AtomicReference<Runnable> task = new AtomicReference();

        public TaskEntry(String name) {
            this.name = name;
        }

        public void scheduleNext(Runnable r, long minTime) {
            long target;
            Runnable old = this.task.getAndSet(r);
            if (old != null) {
                System.out.println("Task is already scheduled.");
                return;
            }
            long delay = 0L;
            if (this.lastRuntime > 0L && (delay = (target = this.lastRuntime + minTime) - System.currentTimeMillis()) < 0L) {
                delay = 0L;
            }
            log.info((Object)("Running " + this.name + " in:" + delay + " ms."));
            Scheduler.this.executor.schedule(this, delay, TimeUnit.MILLISECONDS);
        }

        public void cancel() {
            this.task.set(null);
        }

        @Override
        public void run() {
            this.lastRuntime = System.currentTimeMillis();
            Runnable toRun = this.task.getAndSet(null);
            toRun.run();
        }
    }
}

