/*
 * Decompiled with CFR 0.152.
 */
package mythruna.server;

import com.jme3.math.Vector3f;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.progeeks.json.JsonParser;
import org.progeeks.json.JsonPrinter;
import org.progeeks.util.PropertyAccess;
import org.progeeks.util.SimpleExpressionLanguage;
import org.progeeks.util.TemplateExpressionProcessor;

public class ServerStats {
    public static final int STATS_VERSION = 1;
    public static final String STATS_FILE = "stats.json";
    private static SimpleExpressionLanguage el = TemplateExpressionProcessor.getDefaultProcessor().getExpressionLanguage();
    private File file;
    private Map values;
    private JsonParser jsonParser = new JsonParser();
    private JsonPrinter jsonPrinter = new JsonPrinter();

    public ServerStats(File file) throws IOException {
        this.file = file;
        this.values = (Map)this.loadJson();
        if (this.values == null) {
            this.values = new HashMap();
            this.values.put("version", 1);
        }
    }

    public synchronized void set(String property, Object value) {
        List exps = el.parseExpression(property);
        HashMap o = this.values;
        PropertyAccess access = el.getPropertyAccess();
        SimpleExpressionLanguage.ExpressionElement last = null;
        Object lastObject = this.values;
        Iterator i = exps.iterator();
        while (i.hasNext()) {
            SimpleExpressionLanguage.ExpressionElement e = (SimpleExpressionLanguage.ExpressionElement)i.next();
            if (!i.hasNext()) {
                last = e;
                break;
            }
            if ((o = e.get(access, (Object)o)) == null && e instanceof SimpleExpressionLanguage.NamedExpressionElement) {
                SimpleExpressionLanguage.NamedExpressionElement nel = (SimpleExpressionLanguage.NamedExpressionElement)e;
                HashMap sub = new HashMap();
                ((Map)lastObject).put(nel.getName(), sub);
                o = sub;
            }
            lastObject = o;
        }
        last.set(access, (Object)o, value);
    }

    public synchronized <T> T get(String property) {
        return (T)el.getProperty((Object)this.values, property);
    }

    public synchronized List getList(String property) {
        CopyOnWriteArrayList l = (CopyOnWriteArrayList)this.get(property);
        if (l == null) {
            l = new CopyOnWriteArrayList();
            this.set(property, l);
        }
        return l;
    }

    public synchronized void add(String property, Object value, int maxSize) {
        List l = this.getList(property);
        l.add(value);
        while (maxSize > 0 && l.size() > maxSize) {
            l.remove(0);
        }
    }

    public synchronized void add(String property, int index, Object value, int maxSize, boolean fromEnd) {
        List l = this.getList(property);
        l.add(index, value);
        while (maxSize > 0 && l.size() > maxSize) {
            if (fromEnd) {
                l.remove(l.size() - 1);
                continue;
            }
            l.remove(0);
        }
    }

    public synchronized int increment(String property) {
        Integer i = (Integer)this.get(property);
        if (i == null) {
            i = 0;
        }
        i = i + 1;
        this.set(property, i);
        return i;
    }

    public synchronized void setLocation(String property, Vector3f value) {
        this.set(property + ".x", Float.valueOf(value.x));
        this.set(property + ".y", Float.valueOf(value.y));
        this.set(property + ".z", Float.valueOf(value.z));
    }

    public synchronized Float getFloat(String property) {
        Number n = (Number)this.get(property);
        if (n == null) {
            return null;
        }
        return Float.valueOf(n.floatValue());
    }

    public synchronized Long getLong(String property) {
        Number n = (Number)this.get(property);
        if (n == null) {
            return null;
        }
        return n.longValue();
    }

    public synchronized Vector3f getLocation(String property) {
        Float x = this.getFloat(property + ".x");
        Float y = this.getFloat(property + ".y");
        Float z = this.getFloat(property + ".z");
        if (x == null || y == null || z == null) {
            return null;
        }
        return new Vector3f(x.floatValue(), y.floatValue(), z.floatValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object loadJson() throws IOException {
        if (!this.file.exists()) {
            return null;
        }
        FileReader in = new FileReader(this.file);
        try {
            Object object = this.jsonParser.parse((Reader)in);
            return object;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeJson(Object o) throws IOException {
        FileWriter out = new FileWriter(this.file);
        try {
            this.jsonPrinter.write(o, (Writer)out);
        }
        finally {
            out.close();
        }
    }

    public synchronized void save() {
        try {
            this.writeJson(this.values);
        }
        catch (IOException e) {
            throw new RuntimeException("Error saving server stats", e);
        }
    }

    public String toString() {
        return "DefaultPlayer[" + this.values + "]";
    }
}

