/*
 * Decompiled with CFR 0.152.
 */
package mythruna.shell;

import org.progeeks.tool.console.AbstractShellCommand;
import org.progeeks.tool.console.ShellEnvironment;
import org.progeeks.util.Inspector;
import org.progeeks.util.SimpleExpressionLanguage;
import org.progeeks.util.TemplateExpressionProcessor;

public class SetCommand
extends AbstractShellCommand {
    public static final String DESCRIPTION = "Sets the value of a variable or option.";
    public static final String[] HELP = new String[]{"Usage: set <expression> <value>", "Where:", "  <expression>  is dot-notation variable to set, such as", "                opts.rotationSpeed", "  <value> is the value to set."};

    public SetCommand() {
        super(DESCRIPTION, HELP);
    }

    public int execute(ShellEnvironment sEnv, String args) {
        if (args.length() == 0) {
            sEnv.println((Object)"No expression or value specified.");
            return -1;
        }
        int split = args.indexOf(32);
        if (split < 0) {
            sEnv.println((Object)"No value specified.");
            return -2;
        }
        String name = args.substring(0, split);
        String value = args.substring(split + 1);
        SimpleExpressionLanguage el = TemplateExpressionProcessor.getContextProcessor().getExpressionLanguage();
        Class c = el.getPropertyClass((Object)sEnv.getVariables(), name);
        if (c == null) {
            sEnv.println((Object)("Variable does not exist for:" + name));
            return -3;
        }
        try {
            Object o = Inspector.constructFromString((String)value, (Class)c);
            sEnv.println((Object)("Setting: " + name + "=" + o));
            el.setProperty((Object)sEnv.getVariables(), name, o);
        }
        catch (Exception e) {
            sEnv.println((Object)("Error setting value. " + e.getMessage()));
        }
        return 0;
    }

    public boolean isSimple() {
        return true;
    }
}

