/*
 * Decompiled with CFR 0.152.
 */
package mythruna.shell;

import java.io.File;
import java.util.Map;
import java.util.TreeSet;
import org.progeeks.tool.console.AbstractShellCommand;
import org.progeeks.tool.console.ShellEnvironment;
import org.progeeks.util.StringUtils;
import org.progeeks.util.log.Log;

public class ShowThreadsCommand
extends AbstractShellCommand {
    static Log log = Log.getLog();
    public static final String DESCRIPTION = "Displays the active threads and their stack traces.";
    public static final String[] HELP = new String[]{"Usage: threads", "", "  Displays all of the currently active threads and their", "  stack traces."};

    public ShowThreadsCommand() {
        super(DESCRIPTION, HELP);
    }

    public int execute(ShellEnvironment sEnv, String args) {
        TreeSet<String> dumps = new TreeSet<String>();
        for (Map.Entry<Thread, StackTraceElement[]> e : Thread.getAllStackTraces().entrySet()) {
            Thread t = e.getKey();
            StackTraceElement[] trace = e.getValue();
            StringBuilder sb = new StringBuilder();
            sb.append(" \"" + t.getName() + "\"");
            sb.append(" #" + t.getId());
            sb.append(t.isDaemon() ? " daemon" : "");
            sb.append(" prio=" + t.getPriority());
            sb.append(" state=" + (Object)((Object)t.getState()));
            for (int i = 0; i < trace.length; ++i) {
                sb.append("\n        " + trace[i]);
            }
            sb.append("\n");
            dumps.add(sb.toString());
        }
        StringBuilder sb = new StringBuilder();
        for (String s : dumps) {
            System.out.println(s);
            sb.append(s + "\n");
        }
        try {
            File f = new File("threads-" + System.currentTimeMillis() + ".txt");
            System.out.println("Writing thread dump to:" + f);
            StringUtils.writeFile((String)sb.toString(), (File)f);
            sEnv.println((Object)("Thread dump written to:" + f.getCanonicalFile().getPath()));
        }
        catch (Exception e) {
            log.error((Object)"Error writing thread stack dump", (Throwable)e);
        }
        return 0;
    }

    public boolean isSimple() {
        return true;
    }
}

