/*
 * Decompiled with CFR 0.152.
 */
package mythruna.shell;

import com.jme3.network.HostedConnection;
import mythruna.PlayerData;
import mythruna.server.GameServer;
import mythruna.shell.UptimeCommand;
import org.progeeks.tool.console.AbstractShellCommand;
import org.progeeks.tool.console.ShellEnvironment;

public class WhoCommand
extends AbstractShellCommand {
    public static final String DESCRIPTION = "Lists the players that are currently online.";
    public static final String[] HELP = new String[]{"Usage: who", "   No additional parameters."};
    private GameServer server;
    private boolean showVersion;

    public WhoCommand(GameServer server, boolean showVersion) {
        super(DESCRIPTION, HELP);
        this.server = server;
        this.showVersion = showVersion;
    }

    public int execute(ShellEnvironment sEnv, String args) {
        for (HostedConnection conn : this.server.getServer().getConnections()) {
            String name = (String)conn.getAttribute("name");
            if (name == null) {
                name = "Unknown";
            }
            PlayerData p = (PlayerData)conn.getAttribute("player");
            String line = "id:" + conn.getId() + "  name:" + name;
            if (this.server != null) {
                line = line + "  address:" + conn.getAddress();
            }
            if (this.showVersion) {
                line = line + "  version:" + conn.getAttribute("version");
            }
            if (p != null) {
                Long count;
                Long login = p.getLong("stats.lastLogin");
                if (login != null) {
                    long time = System.currentTimeMillis() - login;
                    line = line + "  on for:" + UptimeCommand.timeString(time, false);
                }
                if ((count = p.getLong("stats.blocksChanged")) != null) {
                    line = line + "  changed blocks:" + count;
                }
            }
            sEnv.println((Object)line);
        }
        return 0;
    }

    public boolean isSimple() {
        return true;
    }
}

