/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim;

import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import mythruna.World;
import mythruna.db.WorldDatabase;
import mythruna.sim.GameSimulation;
import mythruna.sim.Mob;
import mythruna.sim.MobChangeListener;
import mythruna.sim.MobClass;
import mythruna.sim.MobType;

public class MobManager {
    private World world;
    private WorldDatabase worldDb;
    private Map<MobType, Map<Long, Mob>> classMaps = new HashMap<MobType, Map<Long, Mob>>();
    private List<MobChangeListener> listeners = new CopyOnWriteArrayList<MobChangeListener>();

    public MobManager(World world) {
        this.world = world;
        this.worldDb = world.getWorldDatabase();
        this.classMaps.put(MobType.PLAYER, new ConcurrentHashMap());
        this.classMaps.put(MobType.MOB, new ConcurrentHashMap());
        this.classMaps.put(MobType.PLACEABLE, new ConcurrentHashMap());
    }

    protected Map<Long, Mob> getMobs(MobType type) {
        return this.classMaps.get((Object)type);
    }

    public Collection<Mob> mobs(MobClass ec) {
        return this.classMaps.get((Object)ec.getType()).values();
    }

    public void remove(Mob e) {
        this.getMobs(e.getType().getType()).remove(e.getId());
        e.setAlive(false);
    }

    public Mob getMob(MobClass ec, long id) {
        Mob result = this.getMobs(ec.getType()).get(id);
        if (result != null) {
            return result;
        }
        if (ec.getType() != MobType.PLAYER) {
            throw new UnsupportedOperationException("Don't support the type yet:" + (Object)((Object)ec.getType()));
        }
        System.out.println("Creating new mob for:" + ec + "  id:" + id);
        result = new Mob(MobClass.PLAYER, id, 10);
        result.initializeTransform(GameSimulation.getTime(), this.world.getDefaultSpawnLocation(), this.world.getDefaultSpawnDirection());
        this.getMobs(ec.getType()).put(id, result);
        this.fireChangeEvent(GameSimulation.getTime(), result, null, null);
        return result;
    }

    public void changeMob(long time, Mob e, Quaternion rotation, Vector3f position) {
        if (e.updateTransform(time, position, rotation)) {
            this.fireChangeEvent(time, e, position, rotation);
        }
    }

    protected void fireChangeEvent(long time, Mob e, Vector3f newPos, Quaternion newRot) {
        for (MobChangeListener l : this.listeners) {
            l.mobChanged(e, newPos, newRot);
        }
    }

    public void addMobChangeListener(MobChangeListener l) {
        this.listeners.add(l);
    }

    public void removeMobChangeListener(MobChangeListener l) {
        this.listeners.remove(l);
    }
}

