/*
 * Decompiled with CFR 0.152.
 */
package mythruna.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import mythruna.db.LeafInfo;
import mythruna.db.io.LeafInfoProtocol;

public class Cleaner {
    private int threshold;
    private LeafInfoProtocol infoProto = new LeafInfoProtocol();

    public Cleaner(int threshold) {
        this.threshold = threshold;
    }

    public void clean(File dir) throws IOException {
        File[] list;
        for (File f : list = dir.listFiles()) {
            if (f.isDirectory()) {
                this.clean(f);
                continue;
            }
            if (!f.getName().endsWith(".leaf")) continue;
            this.checkFile(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LeafInfo getLeafInfo(File f) throws IOException {
        FileInputStream fIn = new FileInputStream(f);
        BufferedInputStream in = new BufferedInputStream(fIn);
        try {
            int protocolVersion = in.read();
            LeafInfo leafInfo = this.infoProto.read(in, protocolVersion);
            return leafInfo;
        }
        finally {
            in.close();
        }
    }

    protected void checkFile(File f) throws IOException {
        LeafInfo info = this.getLeafInfo(f);
        System.out.println(f + " vesion:" + info.version + "  threshold:" + this.threshold);
        if (info.version < (long)this.threshold) {
            if (!f.delete()) {
                System.err.println("Error deleting file:" + f);
            } else {
                System.out.println("...deleted.");
            }
        }
    }

    public static void main(String ... args) throws Exception {
        if (args.length == 0) {
            System.out.println("Usage: Cleaner [-d directory] [-v tile version threshold]");
            return;
        }
        String db = "mythruna.db";
        int threshold = 2;
        for (int i = 0; i < args.length; ++i) {
            if ("-d".equals(args[i])) {
                db = args[++i];
                continue;
            }
            if (!"-v".equals(args[i])) continue;
            threshold = Integer.parseInt(args[++i]);
        }
        System.out.println("Directory:" + db);
        System.out.println("Threshold:" + threshold);
        Cleaner c = new Cleaner(threshold);
        c.clean(new File(db));
    }
}

