/*
 * Decompiled with CFR 0.152.
 */
package mythruna.util;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import mythruna.util.ReportSystem;
import mythruna.util.Reporter;

public class LruCache<K, V>
implements Iterable<V> {
    private AtomicLong accessCounter = new AtomicLong();
    private Map<K, CacheEntry<V>> cache = new ConcurrentHashMap<K, CacheEntry<V>>();
    private int depth;
    private String name;

    public LruCache(int depth) {
        this("Unnamed", depth);
    }

    public LruCache(String name, int depth) {
        this.name = name;
        this.depth = depth;
        ReportSystem.registerCacheReporter(new MemReporter());
    }

    @Override
    public Iterator<V> iterator() {
        return new EntryIterator(this.cache.values().iterator());
    }

    public boolean containsKey(Object key) {
        return this.cache.containsKey(key);
    }

    public V get(Object key) {
        CacheEntry<V> result = this.cache.get(key);
        if (result == null) {
            return null;
        }
        result.access(this.accessCounter.getAndIncrement());
        return result.getValue();
    }

    public V put(K key, V value) {
        CacheEntry<V> e = new CacheEntry<V>(value);
        e.access(this.accessCounter.getAndIncrement());
        CacheEntry<V> old = this.cache.put(key, e);
        this.expireOldEntries();
        return old != null ? (V)old.getValue() : null;
    }

    public int size() {
        return this.cache.size();
    }

    protected void expired(V value) {
    }

    protected void expireOldEntries() {
        if (this.cache.size() <= this.depth) {
            return;
        }
        long start = System.nanoTime();
        while (this.cache.size() > this.depth) {
            Object oldest = null;
            long min = this.accessCounter.get();
            for (Map.Entry<K, CacheEntry<V>> e : this.cache.entrySet()) {
                CacheEntry<V> ce = e.getValue();
                long val = ce.lastAccess.get();
                if (val >= min) continue;
                min = val;
                oldest = e.getKey();
            }
            if (oldest == null) {
                throw new RuntimeException("For some reason the cache cannot be expired.");
            }
            CacheEntry<V> removed = this.cache.remove(oldest);
            if (removed == null) continue;
            this.expired(removed.value);
        }
        long end = System.nanoTime();
        long delta = end - start;
        if (delta > 1000000L) {
            System.out.println(this.name + " :Expired old cache entries in > 1 ms:" + (double)(end - start) / 1000000.0 + " ms.");
        }
    }

    private class MemReporter
    implements Reporter {
        private MemReporter() {
        }

        @Override
        public void printReport(String type, PrintWriter out) {
            out.println("LruCache[" + LruCache.this.name + "]:" + LruCache.this.cache.size());
        }
    }

    protected class EntryIterator
    implements Iterator<V> {
        private Iterator<CacheEntry<V>> delegate;

        public EntryIterator(Iterator<CacheEntry<V>> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public V next() {
            return this.delegate.next().getValue();
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }
    }

    protected static class CacheEntry<V> {
        V value;
        AtomicLong lastAccess = new AtomicLong();

        public CacheEntry(V value) {
            this.value = value;
        }

        public void access(long access) {
            this.lastAccess.set(access);
        }

        public V getValue() {
            return this.value;
        }
    }
}

