/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.map;

import org.progeeks.map.AbstractNoiseElevationGenerator;

public class RidgeFractalElevations
extends AbstractNoiseElevationGenerator {
    private int heightScale = 15000;
    private double fractalIncrement = 0.5;
    private double lacunarity = 3.02;
    private int octaves = 6;
    private double offset = 0.86;
    private double gain = 2.0;
    private double threshold = 1.5;
    private int maxOctaves = 128;
    private double[] exponents = new double[this.maxOctaves];

    public RidgeFractalElevations() {
        super("Ridge Fractal");
        this.setFrequency(512);
    }

    @Override
    protected void reinitialize() {
        for (int i = 0; i < this.maxOctaves; ++i) {
            this.exponents[i] = Math.pow(this.lacunarity, (double)(-i) * this.fractalIncrement);
        }
    }

    public void setFractalIncrement(double d) {
        if (this.fractalIncrement == d) {
            return;
        }
        this.fractalIncrement = d;
        this.invalidate();
    }

    public double getFractalIncrement() {
        return this.fractalIncrement;
    }

    public void setLacunarity(double d) {
        if (this.lacunarity == d) {
            return;
        }
        this.lacunarity = d;
        this.invalidate();
    }

    public double getLacunarity() {
        return this.lacunarity;
    }

    public void setOctaves(int d) {
        if (this.octaves == d) {
            return;
        }
        this.octaves = d;
        this.invalidate();
    }

    public int getOctaves() {
        return this.octaves;
    }

    public void setOffset(double d) {
        if (this.offset == d) {
            return;
        }
        this.offset = d;
        this.invalidate();
    }

    public double getOffset() {
        return this.offset;
    }

    public void setThreshold(double d) {
        if (this.threshold == d) {
            return;
        }
        this.threshold = d;
        this.invalidate();
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setGain(double d) {
        if (this.gain == d) {
            return;
        }
        this.gain = d;
        this.invalidate();
    }

    public double getGain() {
        return this.gain;
    }

    @Override
    protected double getElevation(double x, double y, double z) {
        double signal = this.noise.getNoise(x, y, z);
        if (signal < 0.0) {
            signal = -signal;
        }
        signal = this.offset - signal;
        signal *= signal;
        double result = signal;
        double weight = 1.0;
        for (int i = 1; i < this.octaves; ++i) {
            x *= this.lacunarity;
            y *= this.lacunarity;
            z *= this.lacunarity;
            weight = signal * this.threshold;
            if (weight > 1.0) {
                weight = 1.0;
            }
            if (weight < 0.0) {
                weight = 0.0;
            }
            if ((signal = this.noise.getNoise(x, y, z)) < 0.0) {
                signal = -signal;
            }
            signal = this.offset - signal;
            signal *= signal;
            result += (signal *= weight) * this.exponents[i];
        }
        return result;
    }
}

