/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.map;

import org.progeeks.map.AbstractNoiseElevationGenerator;

public class TurbulenceElevations
extends AbstractNoiseElevationGenerator {
    private double minFreq = 1.0;
    private int frequencyIterations = 5;

    public TurbulenceElevations() {
        super("Turbulence");
    }

    public void setStartingFrequency(double d) {
        if (this.minFreq == d) {
            return;
        }
        this.minFreq = d;
        this.invalidate();
    }

    public double getStartingFrequency() {
        return this.minFreq;
    }

    public void setFrequencyIterations(int i) {
        if (this.frequencyIterations == i) {
            return;
        }
        this.frequencyIterations = i;
        this.invalidate();
    }

    public int getFrequencyIterations() {
        return this.frequencyIterations;
    }

    @Override
    protected double getElevation(double x, double y, double z) {
        double value = 0.0;
        double f = this.minFreq;
        for (int i = 0; i < this.frequencyIterations; ++i) {
            double sample = Math.abs(this.noise.getNoise(x * f, y * f, z * f)) / f;
            value += sample;
            f *= 2.0;
        }
        return value;
    }
}

