/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.collision.bih;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingSphere;
import com.jme3.bounding.BoundingVolume;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResults;
import com.jme3.collision.UnsupportedCollisionException;
import com.jme3.collision.bih.BIHNode;
import com.jme3.collision.bih.TriangleAxisComparator;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.math.Matrix4f;
import com.jme3.math.Ray;
import com.jme3.math.Vector3f;
import com.jme3.scene.CollisionData;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexBuffer;
import com.jme3.scene.mesh.VirtualIndexBuffer;
import com.jme3.scene.mesh.WrappedIndexBuffer;
import com.jme3.util.TempVars;
import java.io.IOException;
import java.nio.FloatBuffer;

public class BIHTree
implements CollisionData {
    public static final int MAX_TREE_DEPTH = 100;
    public static final int MAX_TRIS_PER_NODE = 21;
    private Mesh mesh;
    private BIHNode root;
    private int maxTrisPerNode;
    private int numTris;
    private float[] pointData;
    private int[] triIndices;
    private transient CollisionResults boundResults = new CollisionResults();
    private transient float[] bihSwapTmp;
    private static final TriangleAxisComparator[] comparators = new TriangleAxisComparator[]{new TriangleAxisComparator(0), new TriangleAxisComparator(1), new TriangleAxisComparator(2)};

    private void initTriList(FloatBuffer vb, IndexBuffer ib) {
        int i;
        this.pointData = new float[this.numTris * 3 * 3];
        int p = 0;
        for (i = 0; i < this.numTris * 3; i += 3) {
            int vert = ib.get(i) * 3;
            this.pointData[p++] = vb.get(vert++);
            this.pointData[p++] = vb.get(vert++);
            this.pointData[p++] = vb.get(vert);
            vert = ib.get(i + 1) * 3;
            this.pointData[p++] = vb.get(vert++);
            this.pointData[p++] = vb.get(vert++);
            this.pointData[p++] = vb.get(vert);
            vert = ib.get(i + 2) * 3;
            this.pointData[p++] = vb.get(vert++);
            this.pointData[p++] = vb.get(vert++);
            this.pointData[p++] = vb.get(vert);
        }
        this.triIndices = new int[this.numTris];
        for (i = 0; i < this.numTris; ++i) {
            this.triIndices[i] = i;
        }
    }

    public BIHTree(Mesh mesh, int maxTrisPerNode) {
        this.mesh = mesh;
        this.maxTrisPerNode = maxTrisPerNode;
        if (maxTrisPerNode < 1 || mesh == null) {
            throw new IllegalArgumentException();
        }
        this.bihSwapTmp = new float[9];
        FloatBuffer vb = (FloatBuffer)mesh.getBuffer(VertexBuffer.Type.Position).getData();
        IndexBuffer ib = mesh.getIndexBuffer();
        if (ib == null) {
            ib = new VirtualIndexBuffer(mesh.getVertexCount(), mesh.getMode());
        } else if (mesh.getMode() != Mesh.Mode.Triangles) {
            ib = new WrappedIndexBuffer(mesh);
        }
        this.numTris = ib.size() / 3;
        this.initTriList(vb, ib);
    }

    public BIHTree(Mesh mesh) {
        this(mesh, 21);
    }

    public BIHTree() {
    }

    public void construct() {
        BoundingBox sceneBbox = this.createBox(0, this.numTris - 1);
        this.root = this.createNode(0, this.numTris - 1, sceneBbox, 0);
    }

    private BoundingBox createBox(int l, int r) {
        TempVars vars = TempVars.get();
        Vector3f min = vars.vect1.set(new Vector3f(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY));
        Vector3f max = vars.vect2.set(new Vector3f(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY));
        Vector3f v1 = vars.vect3;
        Vector3f v2 = vars.vect4;
        Vector3f v3 = vars.vect5;
        for (int i = l; i <= r; ++i) {
            this.getTriangle(i, v1, v2, v3);
            BoundingBox.checkMinMax(min, max, v1);
            BoundingBox.checkMinMax(min, max, v2);
            BoundingBox.checkMinMax(min, max, v3);
        }
        BoundingBox bbox = new BoundingBox(min, max);
        vars.release();
        return bbox;
    }

    int getTriangleIndex(int triIndex) {
        return this.triIndices[triIndex];
    }

    private int sortTriangles(int l, int r, float split, int axis) {
        int pivot = l;
        int j = r;
        TempVars vars = TempVars.get();
        Vector3f v1 = vars.vect1;
        Vector3f v2 = vars.vect2;
        Vector3f v3 = vars.vect3;
        while (pivot <= j) {
            this.getTriangle(pivot, v1, v2, v3);
            v1.addLocal(v2).addLocal(v3).multLocal(0.33333334f);
            if (v1.get(axis) > split) {
                this.swapTriangles(pivot, j);
                --j;
                continue;
            }
            ++pivot;
        }
        vars.release();
        pivot = pivot == l && j < pivot ? j : pivot;
        return pivot;
    }

    private void setMinMax(BoundingBox bbox, boolean doMin, int axis, float value) {
        Vector3f min = bbox.getMin(null);
        Vector3f max = bbox.getMax(null);
        if (doMin) {
            min.set(axis, value);
        } else {
            max.set(axis, value);
        }
        bbox.setMinMax(min, max);
    }

    private float getMinMax(BoundingBox bbox, boolean doMin, int axis) {
        if (doMin) {
            return bbox.getMin(null).get(axis);
        }
        return bbox.getMax(null).get(axis);
    }

    private BIHNode createNode(int l, int r, BoundingBox nodeBbox, int depth) {
        float split;
        int pivot;
        if (r - l < this.maxTrisPerNode || depth > 100) {
            return new BIHNode(l, r);
        }
        BoundingBox currentBox = this.createBox(l, r);
        Vector3f exteriorExt = nodeBbox.getExtent(null);
        Vector3f interiorExt = currentBox.getExtent(null);
        exteriorExt.subtractLocal(interiorExt);
        int axis = 0;
        axis = exteriorExt.x > exteriorExt.y ? (exteriorExt.x > exteriorExt.z ? 0 : 2) : (exteriorExt.y > exteriorExt.z ? 1 : 2);
        if (exteriorExt.equals(Vector3f.ZERO)) {
            axis = 0;
        }
        if ((pivot = this.sortTriangles(l, r, split = currentBox.getCenter().get(axis), axis)) == l || pivot == r) {
            pivot = (r + l) / 2;
        }
        if (pivot < l) {
            BoundingBox rbbox = new BoundingBox(currentBox);
            this.setMinMax(rbbox, true, axis, split);
            return this.createNode(l, r, rbbox, depth + 1);
        }
        if (pivot > r) {
            BoundingBox lbbox = new BoundingBox(currentBox);
            this.setMinMax(lbbox, false, axis, split);
            return this.createNode(l, r, lbbox, depth + 1);
        }
        BIHNode node = new BIHNode(axis);
        BoundingBox lbbox = new BoundingBox(currentBox);
        this.setMinMax(lbbox, false, axis, split);
        node.setLeftPlane(this.getMinMax(this.createBox(l, Math.max(l, pivot - 1)), false, axis));
        node.setLeftChild(this.createNode(l, Math.max(l, pivot - 1), lbbox, depth + 1));
        BoundingBox rbbox = new BoundingBox(currentBox);
        this.setMinMax(rbbox, true, axis, split);
        node.setRightPlane(this.getMinMax(this.createBox(pivot, r), true, axis));
        node.setRightChild(this.createNode(pivot, r, rbbox, depth + 1));
        return node;
    }

    public void getTriangle(int index, Vector3f v1, Vector3f v2, Vector3f v3) {
        int pointIndex = index * 9;
        v1.x = this.pointData[pointIndex++];
        v1.y = this.pointData[pointIndex++];
        v1.z = this.pointData[pointIndex++];
        v2.x = this.pointData[pointIndex++];
        v2.y = this.pointData[pointIndex++];
        v2.z = this.pointData[pointIndex++];
        v3.x = this.pointData[pointIndex++];
        v3.y = this.pointData[pointIndex++];
        v3.z = this.pointData[pointIndex++];
    }

    public void swapTriangles(int index1, int index2) {
        int p1 = index1 * 9;
        int p2 = index2 * 9;
        System.arraycopy(this.pointData, p1, this.bihSwapTmp, 0, 9);
        System.arraycopy(this.pointData, p2, this.pointData, p1, 9);
        System.arraycopy(this.bihSwapTmp, 0, this.pointData, p2, 9);
        int tmp2 = this.triIndices[index1];
        this.triIndices[index1] = this.triIndices[index2];
        this.triIndices[index2] = tmp2;
    }

    private int collideWithRay(Ray r, Matrix4f worldMatrix, BoundingVolume worldBound, CollisionResults results) {
        this.boundResults.clear();
        worldBound.collideWith(r, this.boundResults);
        if (this.boundResults.size() > 0) {
            float tMin = this.boundResults.getClosestCollision().getDistance();
            float tMax = this.boundResults.getFarthestCollision().getDistance();
            if (tMax <= 0.0f) {
                tMax = Float.POSITIVE_INFINITY;
            } else if (tMin == tMax) {
                tMin = 0.0f;
            }
            if (tMin <= 0.0f) {
                tMin = 0.0f;
            }
            if (r.getLimit() < Float.POSITIVE_INFINITY && tMin > (tMax = Math.min(tMax, r.getLimit()))) {
                return 0;
            }
            return this.root.intersectWhere(r, worldMatrix, this, tMin, tMax, results);
        }
        return 0;
    }

    private int collideWithBoundingVolume(BoundingVolume bv, Matrix4f worldMatrix, CollisionResults results) {
        BoundingBox bbox;
        if (bv instanceof BoundingSphere) {
            BoundingSphere sphere = (BoundingSphere)bv;
            bbox = new BoundingBox(bv.getCenter().clone(), sphere.getRadius(), sphere.getRadius(), sphere.getRadius());
        } else if (bv instanceof BoundingBox) {
            bbox = new BoundingBox((BoundingBox)bv);
        } else {
            throw new UnsupportedCollisionException();
        }
        bbox.transform(worldMatrix.invert(), (BoundingVolume)bbox);
        return this.root.intersectWhere(bv, bbox, worldMatrix, this, results);
    }

    public int collideWith(Collidable other, Matrix4f worldMatrix, BoundingVolume worldBound, CollisionResults results) {
        if (other instanceof Ray) {
            Ray ray = (Ray)other;
            return this.collideWithRay(ray, worldMatrix, worldBound, results);
        }
        if (other instanceof BoundingVolume) {
            BoundingVolume bv = (BoundingVolume)other;
            return this.collideWithBoundingVolume(bv, worldMatrix, results);
        }
        throw new UnsupportedCollisionException();
    }

    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.mesh, "mesh", null);
        oc.write(this.root, "root", null);
        oc.write(this.maxTrisPerNode, "tris_per_node", 0);
        oc.write(this.pointData, "points", (float[])null);
        oc.write(this.triIndices, "indices", (int[])null);
    }

    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.mesh = (Mesh)ic.readSavable("mesh", null);
        this.root = (BIHNode)ic.readSavable("root", null);
        this.maxTrisPerNode = ic.readInt("tris_per_node", 0);
        this.pointData = ic.readFloatArray("points", null);
        this.triIndices = ic.readIntArray("indices", null);
    }
}

