/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.input.InputManager;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.AnalogListener;
import com.jme3.input.controls.MouseAxisTrigger;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import java.io.IOException;

public class ChaseCamera
implements ActionListener,
AnalogListener,
Control {
    protected Spatial target = null;
    protected float minVerticalRotation = 0.0f;
    protected float maxVerticalRotation = 1.5707964f;
    protected float minDistance = 1.0f;
    protected float maxDistance = 40.0f;
    protected float distance = 20.0f;
    protected float zoomSpeed = 2.0f;
    protected float rotationSpeed = 1.0f;
    protected float rotation = 0.0f;
    protected float trailingRotationInertia = 0.05f;
    protected float zoomSensitivity = 5.0f;
    protected float rotationSensitivity = 5.0f;
    protected float chasingSensitivity = 5.0f;
    protected float trailingSensitivity = 0.5f;
    protected float vRotation = 0.5235988f;
    protected boolean smoothMotion = false;
    protected boolean trailingEnabled = true;
    protected float rotationLerpFactor = 0.0f;
    protected float trailingLerpFactor = 0.0f;
    protected boolean rotating = false;
    protected boolean vRotating = false;
    protected float targetRotation = this.rotation;
    protected InputManager inputManager;
    protected Vector3f initialUpVec;
    protected float targetVRotation = this.vRotation;
    protected float vRotationLerpFactor = 0.0f;
    protected float targetDistance = this.distance;
    protected float distanceLerpFactor = 0.0f;
    protected boolean zooming = false;
    protected boolean trailing = false;
    protected boolean chasing = false;
    protected boolean veryCloseRotation = true;
    protected boolean canRotate;
    protected float offsetDistance = 0.002f;
    protected Vector3f prevPos;
    protected boolean targetMoves = false;
    protected boolean enabled = true;
    protected Camera cam = null;
    protected final Vector3f targetDir = new Vector3f();
    protected float previousTargetRotation;
    protected final Vector3f pos = new Vector3f();
    protected Vector3f targetLocation = new Vector3f(0.0f, 0.0f, 0.0f);
    protected boolean dragToRotate = true;
    protected Vector3f lookAtOffset = new Vector3f(0.0f, 0.0f, 0.0f);
    protected boolean leftClickRotate = true;
    protected boolean rightClickRotate = true;
    protected Vector3f temp = new Vector3f(0.0f, 0.0f, 0.0f);
    protected boolean invertYaxis = false;
    protected boolean invertXaxis = false;
    protected static final String ChaseCamDown = "ChaseCamDown";
    protected static final String ChaseCamUp = "ChaseCamUp";
    protected static final String ChaseCamZoomIn = "ChaseCamZoomIn";
    protected static final String ChaseCamZoomOut = "ChaseCamZoomOut";
    protected static final String ChaseCamMoveLeft = "ChaseCamMoveLeft";
    protected static final String ChaseCamMoveRight = "ChaseCamMoveRight";
    protected static final String ChaseCamToggleRotate = "ChaseCamToggleRotate";
    private boolean zoomin;

    public ChaseCamera(Camera cam, Spatial target) {
        this(cam);
        target.addControl(this);
    }

    public ChaseCamera(Camera cam) {
        this.cam = cam;
        this.initialUpVec = cam.getUp().clone();
    }

    public ChaseCamera(Camera cam, InputManager inputManager) {
        this(cam);
        this.registerWithInput(inputManager);
    }

    public ChaseCamera(Camera cam, Spatial target, InputManager inputManager) {
        this(cam, target);
        this.registerWithInput(inputManager);
    }

    public void onAction(String name, boolean keyPressed, float tpf) {
        if (this.dragToRotate && name.equals(ChaseCamToggleRotate) && this.enabled) {
            if (keyPressed) {
                this.canRotate = true;
                this.inputManager.setCursorVisible(false);
            } else {
                this.canRotate = false;
                this.inputManager.setCursorVisible(true);
            }
        }
    }

    public void onAnalog(String name, float value, float tpf) {
        if (name.equals(ChaseCamMoveLeft)) {
            this.rotateCamera(-value);
        } else if (name.equals(ChaseCamMoveRight)) {
            this.rotateCamera(value);
        } else if (name.equals(ChaseCamUp)) {
            this.vRotateCamera(value);
        } else if (name.equals(ChaseCamDown)) {
            this.vRotateCamera(-value);
        } else if (name.equals(ChaseCamZoomIn)) {
            this.zoomCamera(-value);
            if (!this.zoomin) {
                this.distanceLerpFactor = 0.0f;
            }
            this.zoomin = true;
        } else if (name.equals(ChaseCamZoomOut)) {
            this.zoomCamera(value);
            if (this.zoomin) {
                this.distanceLerpFactor = 0.0f;
            }
            this.zoomin = false;
        }
    }

    public final void registerWithInput(InputManager inputManager) {
        String[] inputs = new String[]{ChaseCamToggleRotate, ChaseCamDown, ChaseCamUp, ChaseCamMoveLeft, ChaseCamMoveRight, ChaseCamZoomIn, ChaseCamZoomOut};
        this.inputManager = inputManager;
        if (!this.invertYaxis) {
            inputManager.addMapping(ChaseCamDown, new MouseAxisTrigger(1, true));
            inputManager.addMapping(ChaseCamUp, new MouseAxisTrigger(1, false));
        } else {
            inputManager.addMapping(ChaseCamDown, new MouseAxisTrigger(1, false));
            inputManager.addMapping(ChaseCamUp, new MouseAxisTrigger(1, true));
        }
        inputManager.addMapping(ChaseCamZoomIn, new MouseAxisTrigger(2, false));
        inputManager.addMapping(ChaseCamZoomOut, new MouseAxisTrigger(2, true));
        if (!this.invertXaxis) {
            inputManager.addMapping(ChaseCamMoveLeft, new MouseAxisTrigger(0, true));
            inputManager.addMapping(ChaseCamMoveRight, new MouseAxisTrigger(0, false));
        } else {
            inputManager.addMapping(ChaseCamMoveLeft, new MouseAxisTrigger(0, false));
            inputManager.addMapping(ChaseCamMoveRight, new MouseAxisTrigger(0, true));
        }
        inputManager.addMapping(ChaseCamToggleRotate, new MouseButtonTrigger(0));
        inputManager.addMapping(ChaseCamToggleRotate, new MouseButtonTrigger(1));
        inputManager.addListener(this, inputs);
    }

    public void setToggleRotationTrigger(Trigger ... triggers) {
        this.inputManager.deleteMapping(ChaseCamToggleRotate);
        this.inputManager.addMapping(ChaseCamToggleRotate, triggers);
        this.inputManager.addListener(this, ChaseCamToggleRotate);
    }

    public void setZoomInTrigger(Trigger ... triggers) {
        this.inputManager.deleteMapping(ChaseCamZoomIn);
        this.inputManager.addMapping(ChaseCamZoomIn, triggers);
        this.inputManager.addListener(this, ChaseCamZoomIn);
    }

    public void setZoomOutTrigger(Trigger ... triggers) {
        this.inputManager.deleteMapping(ChaseCamZoomOut);
        this.inputManager.addMapping(ChaseCamZoomOut, triggers);
        this.inputManager.addListener(this, ChaseCamZoomOut);
    }

    private void computePosition() {
        float hDistance = this.distance * FastMath.sin(1.5707964f - this.vRotation);
        this.pos.set(hDistance * FastMath.cos(this.rotation), this.distance * FastMath.sin(this.vRotation), hDistance * FastMath.sin(this.rotation));
        this.pos.addLocal(this.target.getWorldTranslation());
    }

    private void rotateCamera(float value) {
        if (!this.canRotate || !this.enabled) {
            return;
        }
        this.rotating = true;
        this.targetRotation += value * this.rotationSpeed;
    }

    private void zoomCamera(float value) {
        if (!this.enabled) {
            return;
        }
        this.zooming = true;
        this.targetDistance += value * this.zoomSpeed;
        if (this.targetDistance > this.maxDistance) {
            this.targetDistance = this.maxDistance;
        }
        if (this.targetDistance < this.minDistance) {
            this.targetDistance = this.minDistance;
        }
        if (this.veryCloseRotation && this.targetVRotation < this.minVerticalRotation && this.targetDistance > this.minDistance + 1.0f) {
            this.targetVRotation = this.minVerticalRotation;
        }
    }

    private void vRotateCamera(float value) {
        if (!this.canRotate || !this.enabled) {
            return;
        }
        this.vRotating = true;
        float lastGoodRot = this.targetVRotation;
        this.targetVRotation += value * this.rotationSpeed;
        if (this.targetVRotation > this.maxVerticalRotation) {
            this.targetVRotation = lastGoodRot;
        }
        if (this.veryCloseRotation) {
            if (this.targetVRotation < this.minVerticalRotation && this.targetDistance > this.minDistance + 1.0f) {
                this.targetVRotation = this.minVerticalRotation;
            } else if (this.targetVRotation < -1.5707964f) {
                this.targetVRotation = lastGoodRot;
            }
        } else if (this.targetVRotation < this.minVerticalRotation) {
            this.targetVRotation = lastGoodRot;
        }
    }

    protected void updateCamera(float tpf) {
        if (this.enabled) {
            this.targetLocation.set(this.target.getWorldTranslation()).addLocal(this.lookAtOffset);
            if (this.smoothMotion) {
                this.targetDir.set(this.targetLocation).subtractLocal(this.prevPos);
                float dist = this.targetDir.length();
                if (this.offsetDistance < dist) {
                    this.chasing = true;
                    if (this.trailingEnabled) {
                        this.trailing = true;
                    }
                    this.targetMoves = true;
                } else {
                    if (this.targetMoves && !this.canRotate) {
                        if (this.targetRotation - this.rotation > this.trailingRotationInertia) {
                            this.targetRotation = this.rotation + this.trailingRotationInertia;
                        } else if (this.targetRotation - this.rotation < -this.trailingRotationInertia) {
                            this.targetRotation = this.rotation - this.trailingRotationInertia;
                        }
                    }
                    this.targetMoves = false;
                }
                if (this.canRotate) {
                    this.trailingLerpFactor = 0.0f;
                    this.trailing = false;
                }
                if (this.trailingEnabled && this.trailing) {
                    if (this.targetMoves) {
                        Vector3f a = this.targetDir.negate().normalizeLocal();
                        Vector3f b = Vector3f.UNIT_X;
                        a.y = 0.0f;
                        this.targetRotation = this.targetDir.z > 0.0f ? (float)Math.PI * 2 - FastMath.acos(a.dot(b)) : FastMath.acos(a.dot(b));
                        if (this.targetRotation - this.rotation > (float)Math.PI || this.targetRotation - this.rotation < (float)(-Math.PI)) {
                            this.targetRotation -= (float)Math.PI * 2;
                        }
                        if (this.targetRotation != this.previousTargetRotation && FastMath.abs(this.targetRotation - this.previousTargetRotation) > 0.3926991f) {
                            this.trailingLerpFactor = 0.0f;
                        }
                        this.previousTargetRotation = this.targetRotation;
                    }
                    this.trailingLerpFactor = Math.min(this.trailingLerpFactor + tpf * tpf * this.trailingSensitivity, 1.0f);
                    this.rotation = FastMath.interpolateLinear(this.trailingLerpFactor, this.rotation, this.targetRotation);
                    if (this.targetRotation + 0.01f >= this.rotation && this.targetRotation - 0.01f <= this.rotation) {
                        this.trailing = false;
                        this.trailingLerpFactor = 0.0f;
                    }
                }
                if (this.chasing) {
                    this.distance = this.temp.set(this.targetLocation).subtractLocal(this.cam.getLocation()).length();
                    this.distanceLerpFactor = Math.min(this.distanceLerpFactor + tpf * tpf * this.chasingSensitivity * 0.05f, 1.0f);
                    this.distance = FastMath.interpolateLinear(this.distanceLerpFactor, this.distance, this.targetDistance);
                    if (this.targetDistance + 0.01f >= this.distance && this.targetDistance - 0.01f <= this.distance) {
                        this.distanceLerpFactor = 0.0f;
                        this.chasing = false;
                    }
                }
                if (this.zooming) {
                    this.distanceLerpFactor = Math.min(this.distanceLerpFactor + tpf * tpf * this.zoomSensitivity, 1.0f);
                    this.distance = FastMath.interpolateLinear(this.distanceLerpFactor, this.distance, this.targetDistance);
                    if (this.targetDistance + 0.1f >= this.distance && this.targetDistance - 0.1f <= this.distance) {
                        this.zooming = false;
                        this.distanceLerpFactor = 0.0f;
                    }
                }
                if (this.rotating) {
                    this.rotationLerpFactor = Math.min(this.rotationLerpFactor + tpf * tpf * this.rotationSensitivity, 1.0f);
                    this.rotation = FastMath.interpolateLinear(this.rotationLerpFactor, this.rotation, this.targetRotation);
                    if (this.targetRotation + 0.01f >= this.rotation && this.targetRotation - 0.01f <= this.rotation) {
                        this.rotating = false;
                        this.rotationLerpFactor = 0.0f;
                    }
                }
                if (this.vRotating) {
                    this.vRotationLerpFactor = Math.min(this.vRotationLerpFactor + tpf * tpf * this.rotationSensitivity, 1.0f);
                    this.vRotation = FastMath.interpolateLinear(this.vRotationLerpFactor, this.vRotation, this.targetVRotation);
                    if (this.targetVRotation + 0.01f >= this.vRotation && this.targetVRotation - 0.01f <= this.vRotation) {
                        this.vRotating = false;
                        this.vRotationLerpFactor = 0.0f;
                    }
                }
                this.computePosition();
                this.cam.setLocation(this.pos.addLocal(this.lookAtOffset));
            } else {
                this.vRotation = this.targetVRotation;
                this.rotation = this.targetRotation;
                this.distance = this.targetDistance;
                this.computePosition();
                this.cam.setLocation(this.pos.addLocal(this.lookAtOffset));
            }
            this.prevPos.set(this.targetLocation);
            this.cam.lookAt(this.targetLocation, this.initialUpVec);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!enabled) {
            this.canRotate = false;
        }
    }

    public float getMaxDistance() {
        return this.maxDistance;
    }

    public void setMaxDistance(float maxDistance) {
        this.maxDistance = maxDistance;
    }

    public float getMinDistance() {
        return this.minDistance;
    }

    public void setMinDistance(float minDistance) {
        this.minDistance = minDistance;
    }

    public Control cloneForSpatial(Spatial spatial) {
        ChaseCamera cc = new ChaseCamera(this.cam, spatial, this.inputManager);
        cc.setMaxDistance(this.getMaxDistance());
        cc.setMinDistance(this.getMinDistance());
        return cc;
    }

    public void setSpatial(Spatial spatial) {
        this.target = spatial;
        if (spatial == null) {
            return;
        }
        this.computePosition();
        this.prevPos = new Vector3f(this.target.getWorldTranslation());
        this.cam.setLocation(this.pos);
    }

    public void update(float tpf) {
        this.updateCamera(tpf);
    }

    public void render(RenderManager rm, ViewPort vp) {
    }

    public void write(JmeExporter ex) throws IOException {
        OutputCapsule capsule = ex.getCapsule(this);
        capsule.write(this.maxDistance, "maxDistance", 40.0f);
        capsule.write(this.minDistance, "minDistance", 1.0f);
    }

    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.maxDistance = ic.readFloat("maxDistance", 40.0f);
        this.minDistance = ic.readFloat("minDistance", 1.0f);
    }

    public float getMaxVerticalRotation() {
        return this.maxVerticalRotation;
    }

    public void setMaxVerticalRotation(float maxVerticalRotation) {
        this.maxVerticalRotation = maxVerticalRotation;
    }

    public float getMinVerticalRotation() {
        return this.minVerticalRotation;
    }

    public void setMinVerticalRotation(float minHeight) {
        this.minVerticalRotation = minHeight;
    }

    public boolean isSmoothMotion() {
        return this.smoothMotion;
    }

    public void setSmoothMotion(boolean smoothMotion) {
        this.smoothMotion = smoothMotion;
    }

    public float getChasingSensitivity() {
        return this.chasingSensitivity;
    }

    public void setChasingSensitivity(float chasingSensitivity) {
        this.chasingSensitivity = chasingSensitivity;
    }

    public float getRotationSensitivity() {
        return this.rotationSensitivity;
    }

    public void setRotationSensitivity(float rotationSensitivity) {
        this.rotationSensitivity = rotationSensitivity;
    }

    public boolean isTrailingEnabled() {
        return this.trailingEnabled;
    }

    public void setTrailingEnabled(boolean trailingEnabled) {
        this.trailingEnabled = trailingEnabled;
    }

    public float getTrailingRotationInertia() {
        return this.trailingRotationInertia;
    }

    public void setTrailingRotationInertia(float trailingRotationInertia) {
        this.trailingRotationInertia = trailingRotationInertia;
    }

    public float getTrailingSensitivity() {
        return this.trailingSensitivity;
    }

    public void setTrailingSensitivity(float trailingSensitivity) {
        this.trailingSensitivity = trailingSensitivity;
    }

    public float getZoomSensitivity() {
        return this.zoomSensitivity;
    }

    public void setZoomSensitivity(float zoomSensitivity) {
        this.zoomSensitivity = zoomSensitivity;
    }

    public void setDefaultDistance(float defaultDistance) {
        this.targetDistance = this.distance = defaultDistance;
    }

    public void setDefaultHorizontalRotation(float angleInRad) {
        this.rotation = angleInRad;
        this.targetRotation = angleInRad;
    }

    public void setDefaultVerticalRotation(float angleInRad) {
        this.vRotation = angleInRad;
        this.targetVRotation = angleInRad;
    }

    public boolean isDragToRotate() {
        return this.dragToRotate;
    }

    public void setDragToRotate(boolean dragToRotate) {
        this.dragToRotate = dragToRotate;
        this.canRotate = !dragToRotate;
        this.inputManager.setCursorVisible(dragToRotate);
    }

    public void setDownRotateOnCloseViewOnly(boolean rotateOnlyWhenClose) {
        this.veryCloseRotation = rotateOnlyWhenClose;
    }

    public boolean getDownRotateOnCloseViewOnly() {
        return this.veryCloseRotation;
    }

    public float getDistanceToTarget() {
        return this.distance;
    }

    public float getHorizontalRotation() {
        return this.rotation;
    }

    public float getVerticalRotation() {
        return this.vRotation;
    }

    public Vector3f getLookAtOffset() {
        return this.lookAtOffset;
    }

    public void setLookAtOffset(Vector3f lookAtOffset) {
        this.lookAtOffset = lookAtOffset;
    }

    public void setUpVector(Vector3f up) {
        this.initialUpVec = up;
    }

    public Vector3f getUpVector() {
        return this.initialUpVec;
    }

    public void setInvertVerticalAxis(boolean invertYaxis) {
        this.invertYaxis = invertYaxis;
        this.inputManager.deleteMapping(ChaseCamDown);
        this.inputManager.deleteMapping(ChaseCamUp);
        if (!invertYaxis) {
            this.inputManager.addMapping(ChaseCamDown, new MouseAxisTrigger(1, true));
            this.inputManager.addMapping(ChaseCamUp, new MouseAxisTrigger(1, false));
        } else {
            this.inputManager.addMapping(ChaseCamDown, new MouseAxisTrigger(1, false));
            this.inputManager.addMapping(ChaseCamUp, new MouseAxisTrigger(1, true));
        }
        this.inputManager.addListener(this, ChaseCamDown, ChaseCamUp);
    }

    public void setInvertHorizontalAxis(boolean invertXaxis) {
        this.invertXaxis = invertXaxis;
        this.inputManager.deleteMapping(ChaseCamMoveLeft);
        this.inputManager.deleteMapping(ChaseCamMoveRight);
        if (!invertXaxis) {
            this.inputManager.addMapping(ChaseCamMoveLeft, new MouseAxisTrigger(0, true));
            this.inputManager.addMapping(ChaseCamMoveRight, new MouseAxisTrigger(0, false));
        } else {
            this.inputManager.addMapping(ChaseCamMoveLeft, new MouseAxisTrigger(0, false));
            this.inputManager.addMapping(ChaseCamMoveRight, new MouseAxisTrigger(0, true));
        }
        this.inputManager.addListener(this, ChaseCamMoveLeft, ChaseCamMoveRight);
    }
}

