/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.AssetManager;
import com.jme3.asset.AssetNotFoundException;
import com.jme3.asset.TextureKey;
import com.jme3.material.Material;
import com.jme3.material.MaterialList;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.util.PlaceholderAssets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MTLLoader
implements AssetLoader {
    private static final Logger logger = Logger.getLogger(MTLLoader.class.getName());
    protected Scanner scan;
    protected MaterialList matList;
    protected AssetManager assetManager;
    protected String folderName;
    protected AssetKey key;
    protected Texture diffuseMap;
    protected Texture normalMap;
    protected Texture specularMap;
    protected Texture alphaMap;
    protected ColorRGBA ambient = new ColorRGBA();
    protected ColorRGBA diffuse = new ColorRGBA();
    protected ColorRGBA specular = new ColorRGBA();
    protected float shininess = 16.0f;
    protected boolean shadeless;
    protected String matName;
    protected float alpha = 1.0f;
    protected boolean transparent = false;
    protected boolean disallowTransparency = false;
    protected boolean disallowAmbient = false;
    protected boolean disallowSpecular = false;

    public void reset() {
        this.scan = null;
        this.matList = null;
        this.resetMaterial();
    }

    protected ColorRGBA readColor() {
        ColorRGBA v = new ColorRGBA();
        v.set(this.scan.nextFloat(), this.scan.nextFloat(), this.scan.nextFloat(), 1.0f);
        return v;
    }

    protected String nextStatement() {
        this.scan.useDelimiter("\n");
        String result = this.scan.next();
        this.scan.useDelimiter("\\p{javaWhitespace}+");
        return result;
    }

    protected boolean skipLine() {
        try {
            this.scan.skip(".*\r{0,1}\n");
            return true;
        }
        catch (NoSuchElementException ex) {
            return false;
        }
    }

    protected void resetMaterial() {
        this.ambient.set(ColorRGBA.DarkGray);
        this.diffuse.set(ColorRGBA.LightGray);
        this.specular.set(ColorRGBA.Black);
        this.shininess = 16.0f;
        this.disallowTransparency = false;
        this.disallowAmbient = false;
        this.disallowSpecular = false;
        this.shadeless = false;
        this.transparent = false;
        this.matName = null;
        this.diffuseMap = null;
        this.specularMap = null;
        this.normalMap = null;
        this.alphaMap = null;
        this.alpha = 1.0f;
    }

    protected void createMaterial() {
        Material material;
        if (this.alpha < 1.0f && this.transparent && !this.disallowTransparency) {
            this.diffuse.a = this.alpha;
        }
        if (this.shadeless) {
            material = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
            material.setColor("Color", this.diffuse.clone());
            material.setTexture("ColorMap", this.diffuseMap);
        } else {
            material = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
            material.setBoolean("UseMaterialColors", true);
            material.setColor("Ambient", this.ambient.clone());
            material.setColor("Diffuse", this.diffuse.clone());
            material.setColor("Specular", this.specular.clone());
            material.setFloat("Shininess", this.shininess);
            if (this.diffuseMap != null) {
                material.setTexture("DiffuseMap", this.diffuseMap);
            }
            if (this.specularMap != null) {
                material.setTexture("SpecularMap", this.specularMap);
            }
            if (this.normalMap != null) {
                material.setTexture("NormalMap", this.normalMap);
            }
            if (this.alphaMap != null) {
                material.setTexture("AlphaMap", this.alphaMap);
            }
        }
        if (this.transparent && !this.disallowTransparency) {
            material.setTransparent(true);
            material.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
            material.getAdditionalRenderState().setAlphaTest(true);
            material.getAdditionalRenderState().setAlphaFallOff(0.01f);
        }
        this.matList.put(this.matName, material);
    }

    protected void startMaterial(String name) {
        if (this.matName != null) {
            this.createMaterial();
        }
        this.resetMaterial();
        this.matName = name;
    }

    protected Texture loadTexture(String path) {
        Texture texture;
        String[] split = path.trim().split("\\p{javaWhitespace}+");
        path = split[split.length - 1];
        String name = new File(path).getName();
        TextureKey texKey = new TextureKey(this.folderName + name);
        texKey.setGenerateMips(true);
        try {
            texture = this.assetManager.loadTexture(texKey);
            texture.setWrap(Texture.WrapMode.Repeat);
        }
        catch (AssetNotFoundException ex) {
            logger.log(Level.WARNING, "Cannot locate {0} for material {1}", new Object[]{texKey, this.key});
            texture = new Texture2D(PlaceholderAssets.getPlaceholderImage());
        }
        return texture;
    }

    protected boolean readLine() {
        if (!this.scan.hasNext()) {
            return false;
        }
        String cmd = this.scan.next().toLowerCase();
        if (cmd.startsWith("#")) {
            return this.skipLine();
        }
        if (cmd.equals("newmtl")) {
            String name = this.scan.next();
            this.startMaterial(name);
        } else if (cmd.equals("ka")) {
            this.ambient.set(this.readColor());
        } else if (cmd.equals("kd")) {
            this.diffuse.set(this.readColor());
        } else if (cmd.equals("ks")) {
            this.specular.set(this.readColor());
        } else if (cmd.equals("ns")) {
            float shiny = this.scan.nextFloat();
            if (shiny >= 1.0f) {
                this.shininess = shiny;
                if (this.specular.equals(ColorRGBA.Black)) {
                    this.specular.set(ColorRGBA.White);
                }
            }
        } else if (cmd.equals("d") || cmd.equals("tr")) {
            this.alpha = this.scan.nextFloat();
            this.transparent = true;
        } else {
            if (cmd.equals("map_ka")) {
                return this.skipLine();
            }
            if (cmd.equals("map_kd")) {
                String path = this.nextStatement();
                this.diffuseMap = this.loadTexture(path);
            } else if (cmd.equals("map_bump") || cmd.equals("bump")) {
                if (this.normalMap == null) {
                    String path = this.nextStatement();
                    this.normalMap = this.loadTexture(path);
                }
            } else if (cmd.equals("map_ks")) {
                String path = this.nextStatement();
                this.specularMap = this.loadTexture(path);
                if (this.specularMap != null && this.specular.equals(ColorRGBA.Black)) {
                    this.specular.set(ColorRGBA.White);
                }
            } else if (cmd.equals("map_d")) {
                String path = this.scan.next();
                this.alphaMap = this.loadTexture(path);
                this.transparent = true;
            } else if (cmd.equals("illum")) {
                int mode = this.scan.nextInt();
                switch (mode) {
                    case 0: {
                        this.shadeless = true;
                        this.disallowTransparency = true;
                        break;
                    }
                    case 1: {
                        this.disallowSpecular = true;
                        this.disallowTransparency = true;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 5: 
                    case 8: {
                        this.disallowTransparency = true;
                        break;
                    }
                    case 4: 
                    case 6: 
                    case 7: 
                    case 9: {
                        this.transparent = true;
                    }
                }
            } else {
                if (cmd.equals("ke") || cmd.equals("ni")) {
                    return this.skipLine();
                }
                logger.log(Level.WARNING, "Unknown statement in MTL! {0}", cmd);
                return this.skipLine();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object load(AssetInfo info) throws IOException {
        this.reset();
        this.key = info.getKey();
        this.assetManager = info.getManager();
        this.folderName = info.getKey().getFolder();
        this.matList = new MaterialList();
        InputStream in = null;
        try {
            in = info.openStream();
            this.scan = new Scanner(in);
            this.scan.useLocale(Locale.US);
            while (this.readLine()) {
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        if (this.matName != null) {
            this.createMaterial();
            this.resetMaterial();
        }
        MaterialList list = this.matList;
        return list;
    }
}

