/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shadow;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Matrix4f;
import com.jme3.math.Vector3f;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.GeometryList;
import com.jme3.renderer.queue.OpaqueComparator;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.WireFrustum;
import com.jme3.shadow.PssmShadowUtil;
import com.jme3.shadow.ShadowUtil;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.ui.Picture;

public class PssmShadowRenderer
implements SceneProcessor {
    private int nbSplits = 3;
    private float lambda = 0.65f;
    private float shadowIntensity = 0.7f;
    private float zFarOverride = 0.0f;
    private RenderManager renderManager;
    private ViewPort viewPort;
    private FrameBuffer[] shadowFB;
    private Texture2D[] shadowMaps;
    private Texture2D dummyTex;
    private Camera shadowCam;
    private Material preshadowMat;
    private Material postshadowMat;
    private GeometryList splitOccluders = new GeometryList(new OpaqueComparator());
    private Matrix4f[] lightViewProjectionsMatrices;
    private ColorRGBA splits;
    private float[] splitsArray;
    private boolean noOccluders = false;
    private Vector3f direction = new Vector3f();
    private AssetManager assetManager;
    private boolean debug = false;
    private float edgesThickness = 1.0f;
    private FilterMode filterMode;
    private CompareMode compareMode;
    private Picture[] dispPic;
    private Vector3f[] points = new Vector3f[8];
    private boolean flushQueues = true;

    public PssmShadowRenderer(AssetManager manager, int size, int nbSplits) {
        this(manager, size, nbSplits, new Material(manager, "Common/MatDefs/Shadow/PostShadowPSSM.j3md"));
    }

    public PssmShadowRenderer(AssetManager manager, int size, int nbSplits, Material postShadowMat) {
        int i;
        this.assetManager = manager;
        this.nbSplits = nbSplits = Math.max(Math.min(nbSplits, 4), 1);
        this.shadowFB = new FrameBuffer[nbSplits];
        this.shadowMaps = new Texture2D[nbSplits];
        this.dispPic = new Picture[nbSplits];
        this.lightViewProjectionsMatrices = new Matrix4f[nbSplits];
        this.splits = new ColorRGBA();
        this.splitsArray = new float[nbSplits + 1];
        this.dummyTex = new Texture2D(size, size, Image.Format.RGBA8);
        this.preshadowMat = new Material(manager, "Common/MatDefs/Shadow/PreShadow.j3md");
        this.postshadowMat = postShadowMat;
        for (i = 0; i < nbSplits; ++i) {
            this.lightViewProjectionsMatrices[i] = new Matrix4f();
            this.shadowFB[i] = new FrameBuffer(size, size, 1);
            this.shadowMaps[i] = new Texture2D(size, size, Image.Format.Depth);
            this.shadowFB[i].setDepthTexture(this.shadowMaps[i]);
            this.shadowFB[i].setColorTexture(this.dummyTex);
            this.postshadowMat.setTexture("ShadowMap" + i, this.shadowMaps[i]);
            this.dispPic[i] = new Picture("Picture" + i);
            this.dispPic[i].setTexture(manager, this.shadowMaps[i], false);
        }
        this.setCompareMode(CompareMode.Hardware);
        this.setFilterMode(FilterMode.Bilinear);
        this.setShadowIntensity(0.7f);
        this.shadowCam = new Camera(size, size);
        this.shadowCam.setParallelProjection(true);
        for (i = 0; i < this.points.length; ++i) {
            this.points[i] = new Vector3f();
        }
    }

    public void setFilterMode(FilterMode filterMode) {
        if (filterMode == null) {
            throw new NullPointerException();
        }
        if (this.filterMode == filterMode) {
            return;
        }
        this.filterMode = filterMode;
        this.postshadowMat.setInt("FilterMode", filterMode.ordinal());
        this.postshadowMat.setFloat("PCFEdge", this.edgesThickness);
        if (this.compareMode == CompareMode.Hardware) {
            for (Texture2D shadowMap : this.shadowMaps) {
                if (filterMode == FilterMode.Bilinear) {
                    shadowMap.setMagFilter(Texture.MagFilter.Bilinear);
                    shadowMap.setMinFilter(Texture.MinFilter.BilinearNoMipMaps);
                    continue;
                }
                shadowMap.setMagFilter(Texture.MagFilter.Nearest);
                shadowMap.setMinFilter(Texture.MinFilter.NearestNoMipMaps);
            }
        }
    }

    public void setCompareMode(CompareMode compareMode) {
        if (compareMode == null) {
            throw new NullPointerException();
        }
        if (this.compareMode == compareMode) {
            return;
        }
        this.compareMode = compareMode;
        for (Texture2D shadowMap : this.shadowMaps) {
            if (compareMode == CompareMode.Hardware) {
                shadowMap.setShadowCompareMode(Texture.ShadowCompareMode.LessOrEqual);
                if (this.filterMode == FilterMode.Bilinear) {
                    shadowMap.setMagFilter(Texture.MagFilter.Bilinear);
                    shadowMap.setMinFilter(Texture.MinFilter.BilinearNoMipMaps);
                    continue;
                }
                shadowMap.setMagFilter(Texture.MagFilter.Nearest);
                shadowMap.setMinFilter(Texture.MinFilter.NearestNoMipMaps);
                continue;
            }
            shadowMap.setShadowCompareMode(Texture.ShadowCompareMode.Off);
            shadowMap.setMagFilter(Texture.MagFilter.Nearest);
            shadowMap.setMinFilter(Texture.MinFilter.NearestNoMipMaps);
        }
        this.postshadowMat.setBoolean("HardwareShadows", compareMode == CompareMode.Hardware);
    }

    private Geometry createFrustum(Vector3f[] pts, int i) {
        WireFrustum frustum = new WireFrustum(pts);
        Geometry frustumMdl = new Geometry("f", frustum);
        frustumMdl.setCullHint(Spatial.CullHint.Never);
        frustumMdl.setShadowMode(RenderQueue.ShadowMode.Off);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.getAdditionalRenderState().setWireframe(true);
        frustumMdl.setMaterial(mat);
        switch (i) {
            case 0: {
                frustumMdl.getMaterial().setColor("Color", ColorRGBA.Pink);
                break;
            }
            case 1: {
                frustumMdl.getMaterial().setColor("Color", ColorRGBA.Red);
                break;
            }
            case 2: {
                frustumMdl.getMaterial().setColor("Color", ColorRGBA.Green);
                break;
            }
            case 3: {
                frustumMdl.getMaterial().setColor("Color", ColorRGBA.Blue);
                break;
            }
            default: {
                frustumMdl.getMaterial().setColor("Color", ColorRGBA.White);
            }
        }
        frustumMdl.updateGeometricState();
        return frustumMdl;
    }

    public void initialize(RenderManager rm, ViewPort vp) {
        this.renderManager = rm;
        this.viewPort = vp;
    }

    public boolean isInitialized() {
        return this.viewPort != null;
    }

    public Vector3f getDirection() {
        return this.direction;
    }

    public void setDirection(Vector3f direction) {
        this.direction.set(direction).normalizeLocal();
    }

    public void postQueue(RenderQueue rq) {
        GeometryList occluders = rq.getShadowQueueContent(RenderQueue.ShadowMode.Cast);
        if (occluders.size() == 0) {
            return;
        }
        GeometryList receivers = rq.getShadowQueueContent(RenderQueue.ShadowMode.Receive);
        if (receivers.size() == 0) {
            return;
        }
        Camera viewCam = this.viewPort.getCamera();
        float zFar = this.zFarOverride;
        if (zFar == 0.0f) {
            zFar = viewCam.getFrustumFar();
        }
        float frustumNear = Math.max(viewCam.getFrustumNear(), 0.001f);
        ShadowUtil.updateFrustumPoints(viewCam, frustumNear, zFar, 1.0f, this.points);
        this.shadowCam.getRotation().lookAt(this.direction, this.shadowCam.getUp());
        this.shadowCam.update();
        this.shadowCam.updateViewProjection();
        PssmShadowUtil.updateFrustumSplits(this.splitsArray, frustumNear, zFar, this.lambda);
        switch (this.splitsArray.length) {
            case 5: {
                this.splits.a = this.splitsArray[4];
            }
            case 4: {
                this.splits.b = this.splitsArray[3];
            }
            case 3: {
                this.splits.g = this.splitsArray[2];
            }
            case 1: 
            case 2: {
                this.splits.r = this.splitsArray[1];
            }
        }
        Renderer r = this.renderManager.getRenderer();
        this.renderManager.setForcedMaterial(this.preshadowMat);
        this.renderManager.setForcedTechnique("PreShadow");
        for (int i = 0; i < this.nbSplits; ++i) {
            ShadowUtil.updateFrustumPoints(viewCam, this.splitsArray[i], this.splitsArray[i + 1], 1.0f, this.points);
            ShadowUtil.updateShadowCamera(occluders, receivers, this.shadowCam, this.points, this.splitOccluders);
            this.lightViewProjectionsMatrices[i] = this.shadowCam.getViewProjectionMatrix().clone();
            this.renderManager.setCamera(this.shadowCam, false);
            r.setFrameBuffer(this.shadowFB[i]);
            r.clearBuffers(false, true, false);
            this.viewPort.getQueue().renderShadowQueue(this.splitOccluders, this.renderManager, this.shadowCam, true);
        }
        if (this.flushQueues) {
            occluders.clear();
        }
        r.setFrameBuffer(this.viewPort.getOutputFrameBuffer());
        this.renderManager.setForcedMaterial(null);
        this.renderManager.setForcedTechnique(null);
        this.renderManager.setCamera(viewCam, false);
    }

    private void displayShadowMap(Renderer r) {
        Camera cam = this.viewPort.getCamera();
        this.renderManager.setCamera(cam, true);
        int h = cam.getHeight();
        for (int i = 0; i < this.dispPic.length; ++i) {
            this.dispPic[i].setPosition(64 * (i + 1) + 128 * i, (float)h / 20.0f);
            this.dispPic[i].setWidth(128.0f);
            this.dispPic[i].setHeight(128.0f);
            this.dispPic[i].updateGeometricState();
            this.renderManager.renderGeometry(this.dispPic[i]);
        }
        this.renderManager.setCamera(cam, false);
    }

    public void displayDebug() {
        this.debug = true;
    }

    public void postFrame(FrameBuffer out) {
        Camera cam = this.viewPort.getCamera();
        if (!this.noOccluders) {
            this.postshadowMat.setColor("Splits", this.splits);
            for (int i = 0; i < this.nbSplits; ++i) {
                this.postshadowMat.setMatrix4("LightViewProjectionMatrix" + i, this.lightViewProjectionsMatrices[i]);
            }
            this.renderManager.setForcedMaterial(this.postshadowMat);
            this.viewPort.getQueue().renderShadowQueue(RenderQueue.ShadowMode.Receive, this.renderManager, cam, this.flushQueues);
            this.renderManager.setForcedMaterial(null);
            this.renderManager.setCamera(cam, false);
        }
        if (this.debug) {
            this.displayShadowMap(this.renderManager.getRenderer());
        }
    }

    public void preFrame(float tpf) {
    }

    public void cleanup() {
    }

    public void reshape(ViewPort vp, int w, int h) {
    }

    public float getLambda() {
        return this.lambda;
    }

    public void setLambda(float lambda) {
        this.lambda = lambda;
    }

    public float getShadowZExtend() {
        return this.zFarOverride;
    }

    public void setShadowZExtend(float zFar) {
        this.zFarOverride = zFar;
    }

    public float getShadowIntensity() {
        return this.shadowIntensity;
    }

    public void setShadowIntensity(float shadowIntensity) {
        this.shadowIntensity = shadowIntensity;
        this.postshadowMat.setFloat("ShadowIntensity", shadowIntensity);
    }

    public int getEdgesThickness() {
        return (int)(this.edgesThickness * 10.0f);
    }

    public void setEdgesThickness(int edgesThickness) {
        this.edgesThickness = Math.max(1, Math.min(edgesThickness, 10));
        this.edgesThickness *= 0.1f;
        this.postshadowMat.setFloat("PCFEdge", edgesThickness);
    }

    public boolean isFlushQueues() {
        return this.flushQueues;
    }

    public void setFlushQueues(boolean flushQueues) {
        this.flushQueues = flushQueues;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CompareMode {
        Software,
        Hardware;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FilterMode {
        Nearest,
        Bilinear,
        Dither,
        PCF4,
        PCF8;

    }
}

