/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.ogre;

import com.jme3.animation.AnimControl;
import com.jme3.animation.Animation;
import com.jme3.animation.SkeletonControl;
import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.AssetManager;
import com.jme3.asset.AssetNotFoundException;
import com.jme3.material.Material;
import com.jme3.material.MaterialList;
import com.jme3.math.ColorRGBA;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.control.Control;
import com.jme3.scene.plugins.ogre.AnimData;
import com.jme3.scene.plugins.ogre.OgreMeshKey;
import com.jme3.scene.plugins.ogre.matext.OgreMaterialKey;
import com.jme3.util.BufferUtils;
import com.jme3.util.IntMap;
import com.jme3.util.PlaceholderAssets;
import com.jme3.util.xml.SAXUtil;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class MeshLoader
extends DefaultHandler
implements AssetLoader {
    private static final Logger logger = Logger.getLogger(MeshLoader.class.getName());
    public static boolean AUTO_INTERLEAVE = true;
    public static boolean HARDWARE_SKINNING = false;
    private static final VertexBuffer.Type[] TEXCOORD_TYPES = new VertexBuffer.Type[]{VertexBuffer.Type.TexCoord, VertexBuffer.Type.TexCoord2, VertexBuffer.Type.TexCoord3, VertexBuffer.Type.TexCoord4, VertexBuffer.Type.TexCoord5, VertexBuffer.Type.TexCoord6, VertexBuffer.Type.TexCoord7, VertexBuffer.Type.TexCoord8};
    private AssetKey key;
    private String meshName;
    private String folderName;
    private AssetManager assetManager;
    private MaterialList materialList;
    private ShortBuffer sb;
    private IntBuffer ib;
    private FloatBuffer fb;
    private VertexBuffer vb;
    private Mesh mesh;
    private Geometry geom;
    private ByteBuffer indicesData;
    private FloatBuffer weightsFloatData;
    private boolean actuallyHasWeights = false;
    private int vertCount;
    private boolean usesSharedVerts;
    private boolean usesBigIndices;
    private Mesh sharedMesh;
    private int meshIndex = 0;
    private int texCoordIndex = 0;
    private String ignoreUntilEnd = null;
    private List<Geometry> geoms = new ArrayList<Geometry>();
    private ArrayList<Boolean> usesSharedMesh = new ArrayList();
    private IntMap<List<VertexBuffer>> lodLevels = new IntMap();
    private AnimData animData;

    public void startDocument() {
        this.geoms.clear();
        this.lodLevels.clear();
        this.sb = null;
        this.ib = null;
        this.fb = null;
        this.vb = null;
        this.mesh = null;
        this.geom = null;
        this.sharedMesh = null;
        this.usesSharedMesh.clear();
        this.usesSharedVerts = false;
        this.vertCount = 0;
        this.meshIndex = 0;
        this.texCoordIndex = 0;
        this.ignoreUntilEnd = null;
        this.animData = null;
        this.actuallyHasWeights = false;
        this.indicesData = null;
        this.weightsFloatData = null;
    }

    public void endDocument() {
    }

    private void pushIndex(int index) {
        if (this.ib != null) {
            this.ib.put(index);
        } else {
            this.sb.put((short)index);
        }
    }

    private void pushFace(String v1, String v2, String v3) throws SAXException {
        switch (this.mesh.getMode()) {
            case Triangles: {
                this.pushIndex(SAXUtil.parseInt((String)v1));
                this.pushIndex(SAXUtil.parseInt((String)v2));
                this.pushIndex(SAXUtil.parseInt((String)v3));
                break;
            }
            case Lines: {
                this.pushIndex(SAXUtil.parseInt((String)v1));
                this.pushIndex(SAXUtil.parseInt((String)v2));
                break;
            }
            case Points: {
                this.pushIndex(SAXUtil.parseInt((String)v1));
            }
        }
    }

    private void startFaces(String count) throws SAXException {
        int numFaces = SAXUtil.parseInt((String)count);
        int indicesPerFace = 0;
        switch (this.mesh.getMode()) {
            case Triangles: {
                indicesPerFace = 3;
                break;
            }
            case Lines: {
                indicesPerFace = 2;
                break;
            }
            case Points: {
                indicesPerFace = 1;
                break;
            }
            default: {
                throw new SAXException("Strips or fans not supported!");
            }
        }
        int numIndices = indicesPerFace * numFaces;
        this.vb = new VertexBuffer(VertexBuffer.Type.Index);
        if (!this.usesBigIndices) {
            this.sb = BufferUtils.createShortBuffer((int)numIndices);
            this.ib = null;
            this.vb.setupData(VertexBuffer.Usage.Static, indicesPerFace, VertexBuffer.Format.UnsignedShort, (Buffer)this.sb);
        } else {
            this.ib = BufferUtils.createIntBuffer((int)numIndices);
            this.sb = null;
            this.vb.setupData(VertexBuffer.Usage.Static, indicesPerFace, VertexBuffer.Format.UnsignedInt, (Buffer)this.ib);
        }
        this.mesh.setBuffer(this.vb);
    }

    /*
     * Unable to fully structure code
     */
    private void applyMaterial(Geometry geom, String matName) {
        mat = null;
        if (matName.endsWith(".j3m")) {
            try {
                mat = this.assetManager.loadMaterial(matName);
            }
            catch (AssetNotFoundException ex) {
                if (ex.getMessage().equals(matName)) ** GOTO lbl11
                throw ex;
            }
        } else if (this.materialList != null) {
            mat = (Material)this.materialList.get((Object)matName);
        }
lbl11:
        // 5 sources

        if (mat == null) {
            MeshLoader.logger.log(Level.WARNING, "Cannot locate {0} for model {1}", new Object[]{matName, this.key});
            mat = PlaceholderAssets.getPlaceholderMaterial((AssetManager)this.assetManager);
        }
        if (mat.isTransparent()) {
            geom.setQueueBucket(RenderQueue.Bucket.Transparent);
        }
        geom.setMaterial(mat);
    }

    private void startSubMesh(String matName, String usesharedvertices, String use32bitIndices, String opType) throws SAXException {
        this.mesh = new Mesh();
        if (opType == null || opType.equals("triangle_list")) {
            this.mesh.setMode(Mesh.Mode.Triangles);
        } else if (opType.equals("line_list")) {
            this.mesh.setMode(Mesh.Mode.Lines);
        } else {
            throw new SAXException("Unsupported operation type: " + opType);
        }
        this.usesBigIndices = SAXUtil.parseBool((String)use32bitIndices, (boolean)false);
        this.usesSharedVerts = SAXUtil.parseBool((String)usesharedvertices, (boolean)false);
        if (this.usesSharedVerts) {
            this.usesSharedMesh.add(true);
        } else {
            this.usesSharedMesh.add(false);
        }
        this.geom = this.meshName == null ? new Geometry("OgreSubmesh-" + ++this.meshIndex, this.mesh) : new Geometry(this.meshName + "-geom-" + ++this.meshIndex, this.mesh);
        if (this.usesSharedVerts) {
            // empty if block
        }
        this.applyMaterial(this.geom, matName);
        this.geoms.add(this.geom);
    }

    private void startSharedGeom(String vertexcount) throws SAXException {
        this.sharedMesh = new Mesh();
        this.vertCount = SAXUtil.parseInt((String)vertexcount);
        this.usesSharedVerts = false;
        this.geom = null;
        this.mesh = this.sharedMesh;
    }

    private void startGeometry(String vertexcount) throws SAXException {
        this.vertCount = SAXUtil.parseInt((String)vertexcount);
    }

    private void endBoneAssigns() {
        if (!this.actuallyHasWeights) {
            this.mesh.clearBuffer(VertexBuffer.Type.BoneIndex);
            this.mesh.clearBuffer(VertexBuffer.Type.BoneWeight);
            this.weightsFloatData = null;
            this.indicesData = null;
            return;
        }
        int maxWeightsPerVert = 0;
        this.weightsFloatData.rewind();
        for (int v = 0; v < this.vertCount; ++v) {
            float w0 = this.weightsFloatData.get();
            float w1 = this.weightsFloatData.get();
            float w2 = this.weightsFloatData.get();
            float w3 = this.weightsFloatData.get();
            if (w3 != 0.0f) {
                maxWeightsPerVert = Math.max(maxWeightsPerVert, 4);
            } else if (w2 != 0.0f) {
                maxWeightsPerVert = Math.max(maxWeightsPerVert, 3);
            } else if (w1 != 0.0f) {
                maxWeightsPerVert = Math.max(maxWeightsPerVert, 2);
            } else if (w0 != 0.0f) {
                maxWeightsPerVert = Math.max(maxWeightsPerVert, 1);
            }
            float sum = w0 + w1 + w2 + w3;
            if (sum == 1.0f) continue;
            this.weightsFloatData.position(this.weightsFloatData.position() - 4);
            float sumToB = 1.0f / sum;
            this.weightsFloatData.put(w0 * sumToB);
            this.weightsFloatData.put(w1 * sumToB);
            this.weightsFloatData.put(w2 * sumToB);
            this.weightsFloatData.put(w3 * sumToB);
        }
        this.weightsFloatData.rewind();
        this.actuallyHasWeights = false;
        this.weightsFloatData = null;
        this.indicesData = null;
        this.mesh.setMaxNumWeights(maxWeightsPerVert);
    }

    private void startBoneAssigns() {
        if (this.mesh != this.sharedMesh && this.usesSharedVerts) {
            return;
        }
        if (HARDWARE_SKINNING) {
            this.weightsFloatData = BufferUtils.createFloatBuffer((int)(this.vertCount * 4));
            this.indicesData = BufferUtils.createByteBuffer((int)(this.vertCount * 4));
        } else {
            this.weightsFloatData = FloatBuffer.allocate(this.vertCount * 4);
            this.indicesData = ByteBuffer.allocate(this.vertCount * 4);
        }
        VertexBuffer weights = new VertexBuffer(VertexBuffer.Type.BoneWeight);
        VertexBuffer indices = new VertexBuffer(VertexBuffer.Type.BoneIndex);
        VertexBuffer.Usage usage = HARDWARE_SKINNING ? VertexBuffer.Usage.Static : VertexBuffer.Usage.CpuOnly;
        weights.setupData(usage, 4, VertexBuffer.Format.Float, (Buffer)this.weightsFloatData);
        indices.setupData(usage, 4, VertexBuffer.Format.UnsignedByte, (Buffer)this.indicesData);
        this.mesh.setBuffer(weights);
        this.mesh.setBuffer(indices);
    }

    private void startVertexBuffer(Attributes attribs) throws SAXException {
        if (SAXUtil.parseBool((String)attribs.getValue("positions"), (boolean)false)) {
            this.vb = new VertexBuffer(VertexBuffer.Type.Position);
            this.fb = BufferUtils.createFloatBuffer((int)(this.vertCount * 3));
            this.vb.setupData(VertexBuffer.Usage.Static, 3, VertexBuffer.Format.Float, (Buffer)this.fb);
            this.mesh.setBuffer(this.vb);
        }
        if (SAXUtil.parseBool((String)attribs.getValue("normals"), (boolean)false)) {
            this.vb = new VertexBuffer(VertexBuffer.Type.Normal);
            this.fb = BufferUtils.createFloatBuffer((int)(this.vertCount * 3));
            this.vb.setupData(VertexBuffer.Usage.Static, 3, VertexBuffer.Format.Float, (Buffer)this.fb);
            this.mesh.setBuffer(this.vb);
        }
        if (SAXUtil.parseBool((String)attribs.getValue("colours_diffuse"), (boolean)false)) {
            this.vb = new VertexBuffer(VertexBuffer.Type.Color);
            this.fb = BufferUtils.createFloatBuffer((int)(this.vertCount * 4));
            this.vb.setupData(VertexBuffer.Usage.Static, 4, VertexBuffer.Format.Float, (Buffer)this.fb);
            this.mesh.setBuffer(this.vb);
        }
        if (SAXUtil.parseBool((String)attribs.getValue("tangents"), (boolean)false)) {
            int dimensions = SAXUtil.parseInt((String)attribs.getValue("tangent_dimensions"), (int)3);
            this.vb = new VertexBuffer(VertexBuffer.Type.Tangent);
            this.fb = BufferUtils.createFloatBuffer((int)(this.vertCount * dimensions));
            this.vb.setupData(VertexBuffer.Usage.Static, dimensions, VertexBuffer.Format.Float, (Buffer)this.fb);
            this.mesh.setBuffer(this.vb);
        }
        if (SAXUtil.parseBool((String)attribs.getValue("binormals"), (boolean)false)) {
            this.vb = new VertexBuffer(VertexBuffer.Type.Binormal);
            this.fb = BufferUtils.createFloatBuffer((int)(this.vertCount * 3));
            this.vb.setupData(VertexBuffer.Usage.Static, 3, VertexBuffer.Format.Float, (Buffer)this.fb);
            this.mesh.setBuffer(this.vb);
        }
        int texCoords = SAXUtil.parseInt((String)attribs.getValue("texture_coords"), (int)0);
        for (int i = 0; i < texCoords; ++i) {
            int dims = SAXUtil.parseInt((String)attribs.getValue("texture_coord_dimensions_" + i), (int)2);
            if (dims < 1 || dims > 4) {
                throw new SAXException("Texture coord dimensions must be 1 <= dims <= 4");
            }
            if (i > 7) {
                throw new SAXException("More than 8 texture coordinates not supported");
            }
            this.vb = new VertexBuffer(TEXCOORD_TYPES[i]);
            this.fb = BufferUtils.createFloatBuffer((int)(this.vertCount * dims));
            this.vb.setupData(VertexBuffer.Usage.Static, dims, VertexBuffer.Format.Float, (Buffer)this.fb);
            this.mesh.setBuffer(this.vb);
        }
    }

    private void startVertex() {
        this.texCoordIndex = 0;
    }

    private void pushAttrib(VertexBuffer.Type type, Attributes attribs) throws SAXException {
        try {
            FloatBuffer buf = (FloatBuffer)this.mesh.getBuffer(type).getData();
            buf.put(SAXUtil.parseFloat((String)attribs.getValue("x"))).put(SAXUtil.parseFloat((String)attribs.getValue("y"))).put(SAXUtil.parseFloat((String)attribs.getValue("z")));
        }
        catch (Exception ex) {
            throw new SAXException("Failed to push attrib", ex);
        }
    }

    private void pushTangent(Attributes attribs) throws SAXException {
        try {
            VertexBuffer tangentBuf = this.mesh.getBuffer(VertexBuffer.Type.Tangent);
            FloatBuffer buf = (FloatBuffer)tangentBuf.getData();
            buf.put(SAXUtil.parseFloat((String)attribs.getValue("x"))).put(SAXUtil.parseFloat((String)attribs.getValue("y"))).put(SAXUtil.parseFloat((String)attribs.getValue("z")));
            if (tangentBuf.getNumComponents() == 4) {
                buf.put(SAXUtil.parseFloat((String)attribs.getValue("w")));
            }
        }
        catch (Exception ex) {
            throw new SAXException("Failed to push attrib", ex);
        }
    }

    private void pushTexCoord(Attributes attribs) throws SAXException {
        if (this.texCoordIndex >= 8) {
            return;
        }
        VertexBuffer.Type type = TEXCOORD_TYPES[this.texCoordIndex];
        VertexBuffer tcvb = this.mesh.getBuffer(type);
        FloatBuffer buf = (FloatBuffer)tcvb.getData();
        buf.put(SAXUtil.parseFloat((String)attribs.getValue("u")));
        if (tcvb.getNumComponents() >= 2) {
            buf.put(SAXUtil.parseFloat((String)attribs.getValue("v")));
            if (tcvb.getNumComponents() >= 3) {
                buf.put(SAXUtil.parseFloat((String)attribs.getValue("w")));
                if (tcvb.getNumComponents() == 4) {
                    buf.put(SAXUtil.parseFloat((String)attribs.getValue("x")));
                }
            }
        }
        ++this.texCoordIndex;
    }

    private void pushColor(Attributes attribs) throws SAXException {
        FloatBuffer buf = (FloatBuffer)this.mesh.getBuffer(VertexBuffer.Type.Color).getData();
        String value = SAXUtil.parseString((String)attribs.getValue("value"));
        String[] vals = value.split("\\s");
        if (vals.length != 3 && vals.length != 4) {
            throw new SAXException("Color value must contain 3 or 4 components");
        }
        ColorRGBA color = new ColorRGBA();
        color.r = SAXUtil.parseFloat((String)vals[0]);
        color.g = SAXUtil.parseFloat((String)vals[1]);
        color.b = SAXUtil.parseFloat((String)vals[2]);
        color.a = vals.length == 3 ? 1.0f : SAXUtil.parseFloat((String)vals[3]);
        buf.put(color.r).put(color.g).put(color.b).put(color.a);
    }

    private void startLodFaceList(String submeshindex, String numfaces) {
        int index = Integer.parseInt(submeshindex);
        this.mesh = this.geoms.get(index).getMesh();
        int faceCount = Integer.parseInt(numfaces);
        VertexBuffer originalIndexBuffer = this.mesh.getBuffer(VertexBuffer.Type.Index);
        this.vb = new VertexBuffer(VertexBuffer.Type.Index);
        if (originalIndexBuffer.getFormat() == VertexBuffer.Format.UnsignedInt) {
            this.ib = BufferUtils.createIntBuffer((int)(faceCount * 3));
            this.sb = null;
            this.vb.setupData(VertexBuffer.Usage.Static, 3, VertexBuffer.Format.UnsignedInt, (Buffer)this.ib);
        } else {
            this.sb = BufferUtils.createShortBuffer((int)(faceCount * 3));
            this.ib = null;
            this.vb.setupData(VertexBuffer.Usage.Static, 3, VertexBuffer.Format.UnsignedShort, (Buffer)this.sb);
        }
        ArrayList<VertexBuffer> levels = (ArrayList<VertexBuffer>)this.lodLevels.get(index);
        if (levels == null) {
            levels = new ArrayList<VertexBuffer>();
            levels.add(originalIndexBuffer);
            this.lodLevels.put(index, levels);
        }
        levels.add(this.vb);
    }

    private void startLevelOfDetail(String numlevels) {
    }

    private void endLevelOfDetail() {
        for (IntMap.Entry entry : this.lodLevels) {
            Mesh m = this.geoms.get(entry.getKey()).getMesh();
            List levels = (List)entry.getValue();
            VertexBuffer[] levelArray = new VertexBuffer[levels.size()];
            levels.toArray(levelArray);
            m.setLodLevels(levelArray);
        }
    }

    private void startLodGenerated(String depthsqr) {
    }

    private void pushBoneAssign(String vertIndex, String boneIndex, String weight) throws SAXException {
        int i;
        int vert = SAXUtil.parseInt((String)vertIndex);
        float w = SAXUtil.parseFloat((String)weight);
        byte bone = (byte)SAXUtil.parseInt((String)boneIndex);
        assert (bone >= 0);
        assert (vert >= 0 && vert < this.mesh.getVertexCount());
        float v = 0.0f;
        for (i = vert * 4; i < vert * 4 + 4 && (v = this.weightsFloatData.get(i)) != 0.0f; ++i) {
        }
        if (v != 0.0f) {
            logger.log(Level.WARNING, "Vertex {0} has more than 4 weights per vertex! Ignoring..", vert);
            return;
        }
        this.weightsFloatData.put(i, w);
        this.indicesData.put(i, bone);
        this.actuallyHasWeights = true;
    }

    private void startSkeleton(String name) {
        AssetKey assetKey = new AssetKey(this.folderName + name + ".xml");
        try {
            this.animData = (AnimData)this.assetManager.loadAsset(assetKey);
        }
        catch (AssetNotFoundException ex) {
            logger.log(Level.WARNING, "Cannot locate {0} for model {1}", new Object[]{assetKey, this.key});
            this.animData = null;
        }
    }

    private void startSubmeshName(String indexStr, String nameStr) {
        int index = Integer.parseInt(indexStr);
        this.geoms.get(index).setName(nameStr);
    }

    public void startElement(String uri, String localName, String qName, Attributes attribs) throws SAXException {
        if (this.ignoreUntilEnd != null) {
            return;
        }
        if (qName.equals("texcoord")) {
            this.pushTexCoord(attribs);
        } else if (qName.equals("vertexboneassignment")) {
            this.pushBoneAssign(attribs.getValue("vertexindex"), attribs.getValue("boneindex"), attribs.getValue("weight"));
        } else if (qName.equals("face")) {
            this.pushFace(attribs.getValue("v1"), attribs.getValue("v2"), attribs.getValue("v3"));
        } else if (qName.equals("position")) {
            this.pushAttrib(VertexBuffer.Type.Position, attribs);
        } else if (qName.equals("normal")) {
            this.pushAttrib(VertexBuffer.Type.Normal, attribs);
        } else if (qName.equals("tangent")) {
            this.pushTangent(attribs);
        } else if (qName.equals("binormal")) {
            this.pushAttrib(VertexBuffer.Type.Binormal, attribs);
        } else if (qName.equals("colour_diffuse")) {
            this.pushColor(attribs);
        } else if (qName.equals("vertex")) {
            this.startVertex();
        } else if (qName.equals("faces")) {
            this.startFaces(attribs.getValue("count"));
        } else if (qName.equals("geometry")) {
            String count = attribs.getValue("vertexcount");
            if (count == null) {
                count = attribs.getValue("count");
            }
            this.startGeometry(count);
        } else if (qName.equals("vertexbuffer")) {
            this.startVertexBuffer(attribs);
        } else if (qName.equals("lodfacelist")) {
            this.startLodFaceList(attribs.getValue("submeshindex"), attribs.getValue("numfaces"));
        } else if (qName.equals("lodgenerated")) {
            this.startLodGenerated(attribs.getValue("fromdepthsquared"));
        } else if (qName.equals("levelofdetail")) {
            this.startLevelOfDetail(attribs.getValue("numlevels"));
        } else if (qName.equals("boneassignments")) {
            this.startBoneAssigns();
        } else if (qName.equals("submesh")) {
            this.startSubMesh(attribs.getValue("material"), attribs.getValue("usesharedvertices"), attribs.getValue("use32bitindexes"), attribs.getValue("operationtype"));
        } else if (qName.equals("sharedgeometry")) {
            String count = attribs.getValue("vertexcount");
            if (count == null) {
                count = attribs.getValue("count");
            }
            if (count != null && !count.equals("0")) {
                this.startSharedGeom(count);
            }
        } else if (!qName.equals("submeshes")) {
            if (qName.equals("skeletonlink")) {
                this.startSkeleton(attribs.getValue("name"));
            } else if (!qName.equals("submeshnames")) {
                if (qName.equals("submeshname")) {
                    this.startSubmeshName(attribs.getValue("index"), attribs.getValue("name"));
                } else if (!qName.equals("mesh")) {
                    logger.log(Level.WARNING, "Unknown tag: {0}. Ignoring.", qName);
                    this.ignoreUntilEnd = qName;
                }
            }
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (this.ignoreUntilEnd != null) {
            if (this.ignoreUntilEnd.equals(qName)) {
                this.ignoreUntilEnd = null;
            }
            return;
        }
        if (qName.equals("submesh")) {
            this.usesBigIndices = false;
            this.geom = null;
            this.mesh = null;
        } else if (qName.equals("submeshes")) {
            this.geom = null;
            this.mesh = this.sharedMesh;
            this.usesSharedVerts = false;
        } else if (qName.equals("faces")) {
            if (this.ib != null) {
                this.ib.flip();
            } else {
                this.sb.flip();
            }
            this.vb = null;
            this.ib = null;
            this.sb = null;
        } else if (qName.equals("vertexbuffer")) {
            this.fb = null;
            this.vb = null;
        } else if (qName.equals("geometry") || qName.equals("sharedgeometry")) {
            for (VertexBuffer buf : (VertexBuffer[])this.mesh.getBufferList().getArray()) {
                Buffer data = buf.getData();
                if (data.position() == 0) continue;
                data.flip();
            }
            this.mesh.updateBound();
            this.mesh.setStatic();
            if (qName.equals("sharedgeometry")) {
                this.geom = null;
                this.mesh = null;
            }
        } else if (qName.equals("lodfacelist")) {
            this.sb.flip();
            this.vb = null;
            this.sb = null;
        } else if (qName.equals("levelofdetail")) {
            this.endLevelOfDetail();
        } else if (qName.equals("boneassignments")) {
            this.endBoneAssigns();
        }
    }

    public void characters(char[] ch, int start, int length) {
    }

    private Node compileModel() {
        Mesh m;
        Geometry g;
        int i;
        Node model = new Node(this.meshName + "-ogremesh");
        for (i = 0; i < this.geoms.size(); ++i) {
            g = this.geoms.get(i);
            m = g.getMesh();
            if (this.sharedMesh != null && this.usesSharedMesh.get(i).booleanValue()) {
                m.extractVertexData(this.sharedMesh);
            }
            model.attachChild((Spatial)this.geoms.get(i));
        }
        if (this.animData != null) {
            for (i = 0; i < this.geoms.size(); ++i) {
                g = this.geoms.get(i);
                m = this.geoms.get(i).getMesh();
                m.generateBindPose(!HARDWARE_SKINNING);
            }
            HashMap<String, Animation> anims = new HashMap<String, Animation>();
            ArrayList<Animation> animList = this.animData.anims;
            for (int i2 = 0; i2 < animList.size(); ++i2) {
                Animation anim = animList.get(i2);
                anims.put(anim.getName(), anim);
            }
            AnimControl ctrl = new AnimControl(this.animData.skeleton);
            ctrl.setAnimations(anims);
            model.addControl((Control)ctrl);
            SkeletonControl skeletonControl = new SkeletonControl(this.animData.skeleton);
            model.addControl((Control)skeletonControl);
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object load(AssetInfo info) throws IOException {
        try {
            this.key = info.getKey();
            this.meshName = this.key.getName();
            this.folderName = this.key.getFolder();
            String ext = this.key.getExtension();
            this.meshName = this.meshName.substring(0, this.meshName.length() - ext.length() - 1);
            if (this.folderName != null && this.folderName.length() > 0) {
                this.meshName = this.meshName.substring(this.folderName.length());
            }
            this.assetManager = info.getManager();
            if (this.key instanceof OgreMeshKey) {
                OgreMeshKey meshKey = (OgreMeshKey)this.key;
                this.materialList = meshKey.getMaterialList();
                String materialName = meshKey.getMaterialName();
                if (this.materialList == null && materialName != null) {
                    OgreMaterialKey materialKey = new OgreMaterialKey(this.folderName + materialName + ".material");
                    try {
                        this.materialList = (MaterialList)this.assetManager.loadAsset((AssetKey)materialKey);
                    }
                    catch (AssetNotFoundException e) {
                        logger.log(Level.WARNING, "Cannot locate {0} for model {1}", new Object[]{materialKey, this.key});
                    }
                }
            } else {
                this.materialList = null;
            }
            if (this.materialList == null) {
                OgreMaterialKey materialKey = new OgreMaterialKey(this.folderName + this.meshName + ".material");
                try {
                    this.materialList = (MaterialList)this.assetManager.loadAsset((AssetKey)materialKey);
                }
                catch (AssetNotFoundException e) {
                    logger.log(Level.WARNING, "Cannot locate {0} for model {1}", new Object[]{materialKey, this.key});
                }
            }
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            XMLReader xr = factory.newSAXParser().getXMLReader();
            xr.setContentHandler(this);
            xr.setErrorHandler(this);
            InputStreamReader r = null;
            try {
                r = new InputStreamReader(info.openStream());
                xr.parse(new InputSource(r));
            }
            finally {
                if (r != null) {
                    r.close();
                }
            }
            return this.compileModel();
        }
        catch (SAXException ex) {
            IOException ioEx = new IOException("Error while parsing Ogre3D mesh.xml");
            ioEx.initCause(ex);
            throw ioEx;
        }
        catch (ParserConfigurationException ex) {
            IOException ioEx = new IOException("Error while parsing Ogre3D mesh.xml");
            ioEx.initCause(ex);
            throw ioEx;
        }
    }
}

