/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.tool.console;

import java.util.ArrayList;
import org.progeeks.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentList
extends ArrayList<Object> {
    private String name;
    private char open;
    private char close;

    public ArgumentList(char open, char close) {
        this(null, open, close);
    }

    public ArgumentList(String name, char open, char close) {
        this.name = name;
        this.open = open;
        this.close = close;
    }

    public String getName() {
        return this.name;
    }

    public char getOpenCharacter() {
        return this.open;
    }

    public char getCloseCharacter() {
        return this.close;
    }

    public StringBuilder appendTree(String indent, StringBuilder result) {
        if (result == null) {
            result = new StringBuilder();
        }
        result.append(indent);
        if (this.name != null) {
            result.append(this.name);
        }
        result.append(this.open);
        if (!this.isEmpty()) {
            result.append("\n");
        }
        for (Object o : this) {
            if (o instanceof ArgumentList) {
                ((ArgumentList)o).appendTree(indent + "    ", result);
            } else {
                result.append(indent + "    " + o);
            }
            result.append("\n");
        }
        if (!this.isEmpty()) {
            result.append(indent);
        }
        result.append(this.close);
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.name != null) {
            sb.append(this.name);
        }
        sb.append(this.open);
        sb.append(StringUtils.join((Iterable)this, (String)", "));
        sb.append(this.close);
        return sb.toString();
    }
}

