/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.tool.console;

import org.progeeks.util.StringUtils;

public class CharStream {
    private CharSequence original;
    private char[] buffer;
    private int pos;
    private char[] result;
    private int resultPos;
    private char escapeChar = (char)92;
    private int escapeResult;

    public CharStream(CharSequence seq) {
        this.original = seq;
        this.buffer = ((Object)seq).toString().toCharArray();
        this.result = new char[seq.length()];
    }

    protected boolean isEscapeChar(char c) {
        return c == this.escapeChar;
    }

    public void error(String message) {
        throw new RuntimeException(this.createErrorMessage(message), null);
    }

    public String createErrorMessage(String message) {
        int index = this.pos - 1;
        StringBuilder sb = new StringBuilder(message + "  Offset:" + index);
        sb.append("\n");
        sb.append(new String(this.buffer));
        sb.append("\n");
        sb.append(StringUtils.prepad((String)"", (char)' ', (int)index));
        sb.append("^");
        return sb.toString();
    }

    public boolean hasMore() {
        return this.pos < this.buffer.length;
    }

    public int read() {
        char c;
        if (this.pos >= this.buffer.length) {
            return -1;
        }
        if (this.isEscapeChar(c = this.buffer[this.pos++])) {
            if (this.pos == this.buffer.length) {
                this.error("Escape encountered without following character.");
            }
            c = this.addResultChar(this.buffer[this.pos]);
            this.buffer[this.pos++] = '\u0000';
            if (this.escapeResult == -1) {
                return c;
            }
            return this.escapeResult;
        }
        this.addResultChar(c);
        return c;
    }

    public void pushBack() {
        --this.pos;
        char removed = this.removeResultChar();
        if (this.buffer[this.pos] == '\u0000') {
            this.buffer[this.pos] = removed;
            --this.pos;
        }
    }

    protected char addResultChar(char c) {
        this.result[this.resultPos++] = c;
        return c;
    }

    protected char removeResultChar() {
        char c = this.result[this.resultPos];
        --this.resultPos;
        return c;
    }

    public int getPosition() {
        return this.resultPos;
    }

    public int getSourcePosition() {
        return this.pos;
    }

    public String substring(int start) {
        return this.substring(start, this.resultPos);
    }

    public String substring(int start, int end) {
        if (end < 0) {
            return new String(this.result, start, this.resultPos + end - start);
        }
        return new String(this.result, start, end - start);
    }

    public CharSequence getSourceSequence() {
        return this.original;
    }

    public boolean isEscaped(int pos) {
        return this.result[pos] == '\u0000';
    }

    public boolean isEscaped() {
        if (this.resultPos == 0) {
            return false;
        }
        return this.result[this.resultPos - 1] == '\u0000';
    }

    public CharSequence getRemaining() {
        if (!this.hasMore()) {
            return null;
        }
        return this.original.subSequence(this.pos, this.original.length());
    }

    public String toString() {
        return this.getClass().getName() + "[" + new String(this.buffer) + "]";
    }
}

