/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.tool.console;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.progeeks.tool.console.AbstractShellCommand;
import org.progeeks.tool.console.ShellCommand;
import org.progeeks.tool.console.ShellEnvironment;
import org.progeeks.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HelpCommand
extends AbstractShellCommand {
    private static String[] HELP = new String[]{"Usage: help [command]", "where:", "  command is an optional command name.", "", "If no arguments are specified then the full command", "list is displayed with descriptions."};

    public HelpCommand() {
        super("Help summary or help for a specific command.", HELP);
    }

    protected void printHelpAll(Map<String, ShellCommand> commands, ShellEnvironment sEnv) {
        sEnv.println("");
        HashMap<ShellCommand, String> reverse = new HashMap<ShellCommand, String>();
        for (Map.Entry<String, ShellCommand> e : commands.entrySet()) {
            String name = e.getKey();
            ShellCommand cmd = e.getValue();
            String oldName = (String)reverse.get(cmd);
            if (oldName != null) {
                name = oldName + ", " + name;
            }
            reverse.put(cmd, name);
        }
        TreeMap sorted = new TreeMap();
        int maxSize = 0;
        for (Map.Entry e : reverse.entrySet()) {
            String s = (String)e.getValue();
            if (s.length() > maxSize) {
                maxSize = s.length();
            }
            sorted.put(e.getValue(), e.getKey());
        }
        for (Map.Entry e : sorted.entrySet()) {
            String pre = StringUtils.pad((String)((String)e.getKey()), (int)maxSize) + " : ";
            ShellCommand cmd = (ShellCommand)e.getValue();
            sEnv.println(pre + cmd.getDescription());
        }
    }

    protected void printHelp(String command, Map<String, ShellCommand> commands, ShellEnvironment sEnv) {
        ShellCommand cmd = commands.get(command.toLowerCase());
        String[] help = cmd.getHelp();
        if (help == null) {
            sEnv.println("No help available for " + command + ".");
            return;
        }
        sEnv.println("");
        for (int i = 0; i < help.length; ++i) {
            sEnv.println(help[i]);
        }
    }

    @Override
    public int execute(ShellEnvironment sEnv, String args) {
        if (args.length() == 0) {
            this.printHelpAll(sEnv.getShell().getCommands(), sEnv);
        } else {
            this.printHelp(args, sEnv.getShell().getCommands(), sEnv);
        }
        return 0;
    }

    @Override
    public boolean isSimple() {
        return true;
    }
}

