/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.tool.console;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.progeeks.tool.console.CommandNameParser;
import org.progeeks.tool.console.ExitCommand;
import org.progeeks.tool.console.HelpCommand;
import org.progeeks.tool.console.ShellCommand;
import org.progeeks.tool.console.ShellCommandProcessor;
import org.progeeks.tool.console.ShellEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Shell {
    private String prompt;
    private String extendedPrompt;
    private StringBuilder currentCommand = new StringBuilder();
    private int lastStatus;
    private boolean go = true;
    private boolean preserveLineFeeds = false;
    private CommandNameParser nameParser = new WordCommandParser();
    private Map<String, ShellCommand> commands = new HashMap<String, ShellCommand>();
    private ShellCommandProcessor cmdProc;

    public Shell(String prompt) {
        this(prompt, new ShellCommandProcessor());
    }

    public Shell(String prompt, ShellCommandProcessor cmdProc) {
        this.setPrompt(prompt);
        this.cmdProc = cmdProc;
        cmdProc.setShell(this);
        HelpCommand help = new HelpCommand();
        this.registerCommand("?", help);
        this.registerCommand("help", help);
        this.registerCommand("exit", new ExitCommand());
    }

    public ShellEnvironment getShellEnvironment() {
        return this.cmdProc;
    }

    public void registerCommand(String name, ShellCommand cmd) {
        name = name.toLowerCase();
        if (cmd == null) {
            this.commands.remove(name);
        } else {
            this.commands.put(name, cmd);
        }
    }

    public Map<String, ShellCommand> getCommands() {
        return this.commands;
    }

    public void setPreserveLineFeeds(boolean b) {
        this.preserveLineFeeds = b;
    }

    public boolean getPreserveLineFeeds() {
        return this.preserveLineFeeds;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
        this.extendedPrompt = prompt.replaceAll(".", " ");
        this.extendedPrompt = this.extendedPrompt.replaceAll(".$", "-");
    }

    public String getDisplayPrompt() {
        if (this.currentCommand.length() == 0) {
            return this.prompt;
        }
        return this.extendedPrompt;
    }

    public void setCommandNameParser(CommandNameParser nameParser) {
        this.nameParser = nameParser;
    }

    public CommandNameParser getCommandNameParser() {
        return this.nameParser;
    }

    public boolean addText(CharSequence s) {
        String name;
        ShellCommand cmd;
        String add = ((Object)s).toString().trim();
        if (add.length() == 0 && !this.preserveLineFeeds) {
            return false;
        }
        boolean execute = false;
        if (add.endsWith(";")) {
            execute = true;
            add = add.substring(0, add.length() - 1);
        }
        if (add.length() > 0 || this.preserveLineFeeds) {
            if (this.currentCommand.length() > 0) {
                this.currentCommand.append(this.preserveLineFeeds ? "\n " : " ");
            }
            this.currentCommand.append(add);
        }
        if (!execute && (cmd = this.getCommand(name = this.nameParser.getName(this.currentCommand))) != null) {
            execute = cmd.isSimple();
        }
        if (execute) {
            StringBuilder cmd2 = this.currentCommand;
            this.currentCommand = new StringBuilder();
            this.execute(cmd2);
            return true;
        }
        return false;
    }

    public void execute(CharSequence cmd) {
        String name = this.nameParser.getName(cmd);
        String theRest = ((Object)cmd).toString().substring(name.length()).trim();
        this.executeCommand(name, theRest);
    }

    public void errorCommandNotFound(String name, String args) {
        this.error("Command not found:" + name);
        this.lastStatus = -1;
    }

    public void executeCommand(String name, String args) {
        ShellCommand cmd = this.getCommand(name);
        if (cmd == null) {
            this.errorCommandNotFound(name, args);
            return;
        }
        this.lastStatus = this.cmdProc.execute(cmd, args);
    }

    public void echo(Object s) {
        System.out.println(s);
    }

    public void error(Object s) {
        System.err.println(s);
    }

    public void commandFinished() {
        System.out.println(":" + this.getLastStatus());
    }

    protected ShellCommand getCommand(String name) {
        return this.commands.get(name.toLowerCase());
    }

    public int getLastStatus() {
        return this.lastStatus;
    }

    public boolean isRunning() {
        return this.go;
    }

    public void run() {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            while (this.isRunning()) {
                System.out.print(this.getDisplayPrompt() + ">");
                String line = in.readLine();
                if (line == null) {
                    System.out.println("Console closed.");
                    break;
                }
                if (!this.addText(line)) continue;
                this.commandFinished();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading shell input", e);
        }
    }

    public void stop() {
        this.go = false;
    }

    public static class WordCommandParser
    extends RegexNameParser {
        public WordCommandParser() {
            super("\\w+");
        }
    }

    public static class SimpleNameParser
    extends RegexNameParser {
        public SimpleNameParser() {
            super("\\S+");
        }
    }

    public static class RegexNameParser
    implements CommandNameParser {
        private Pattern commandPart;

        public RegexNameParser(String regex) {
            this.commandPart = Pattern.compile(regex);
        }

        public String getName(CharSequence command) {
            Matcher m = this.commandPart.matcher(command);
            if (!m.lookingAt()) {
                return ((Object)command).toString();
            }
            return m.group(0);
        }
    }
}

