/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.progeeks.util.ConfiguratorListener;
import org.progeeks.util.ConfiguratorUtils;
import org.progeeks.util.InspectionUtils;
import org.progeeks.util.Inspector;
import org.progeeks.util.ObjectConfigurator;
import org.progeeks.util.PropertyAccess;
import org.progeeks.util.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractObjectConfigurator<V>
extends LinkedHashMap<String, Object>
implements ObjectConfigurator<V>,
Serializable {
    static Log log = Log.getLog();
    private transient PropertyAccess access;
    private boolean appendCollections = false;
    private boolean appendFactories = false;
    private boolean overwriteExistingValues = true;
    private boolean reuseFactoryResults = true;
    private boolean reusable = true;
    private transient List<ConfiguratorListener> listeners = new ArrayList<ConfiguratorListener>();

    protected AbstractObjectConfigurator(PropertyAccess access) {
        this.setPropertyAccess(access);
    }

    protected PropertyAccess getPropertyAccess() {
        return this.access;
    }

    protected void setPropertyAccess(PropertyAccess access) {
        this.access = access;
    }

    protected abstract V newInstance(Object ... var1);

    @Override
    public V createObject(Object ... args) {
        return this.createObject(null, args);
    }

    @Override
    public V createObject(Map configuratorCache, Object ... args) {
        V result = this.newInstance(args);
        this.configureObject(result, configuratorCache);
        this.fireObjectCreated(result);
        return result;
    }

    @Override
    public void configureObject(V obj) {
        this.configureObject(obj, null);
    }

    @Override
    public void configureObject(V obj, Map factoryCache) {
        if (log.isDebugEnabled()) {
            log.debug("configureObject( " + obj + " )");
        }
        if (factoryCache == null && this.getReuseFactoryResults()) {
            factoryCache = new IdentityHashMap();
        }
        for (Map.Entry e : this.entrySet()) {
            String field = (String)e.getKey();
            Object val = e.getValue();
            if (val instanceof Collection) {
                this.setCollectionValue(field, (Collection)val, obj, factoryCache);
                continue;
            }
            if (val instanceof Map && !(val instanceof ObjectConfigurator)) {
                this.setMapValue(field, (Map)val, obj, factoryCache);
                continue;
            }
            this.setValue(field, val, obj, factoryCache);
        }
    }

    protected void setCollectionValue(String name, Collection value, V target, Map factoryCache) {
        boolean hasValue;
        Object obj;
        if (log.isDebugEnabled()) {
            log.debug("   setCollectionValue(" + name + ", " + value + ")");
        }
        if ((obj = this.getProperty(target, name)) != null && !(obj instanceof Collection)) {
            throw new RuntimeException("Type mismatch for field:" + name + " exising value is not a collection.");
        }
        boolean bl = hasValue = obj != null && ((Collection)obj).size() > 0;
        if (!this.getOverwriteExistingValues() && !this.getAppendCollections() && hasValue) {
            return;
        }
        value = ConfiguratorUtils.resolveCollection(value, null, factoryCache);
        if (this.hasMutableProperty(target, name) && !hasValue) {
            this.setValue(name, value, target, factoryCache);
            return;
        }
        Class fieldType = this.getPropertyClass(target, name);
        if (value != null && !Collection.class.isAssignableFrom(fieldType)) {
            throw new RuntimeException("Type mismatch for field:" + name + "  value type:" + value.getClass() + " not compatible with field type:" + fieldType);
        }
        Collection current = (Collection)obj;
        if (current != null) {
            if (this.getOverwriteExistingValues() && !this.getAppendCollections()) {
                log.debug("Clearing existing collection.");
                current.clear();
            }
            if (log.isDebugEnabled()) {
                log.debug("    addAll(" + value + ")");
            }
            current.addAll(value);
            return;
        }
        log.error("Error setting property:" + name + " on object:" + target + " No mutator defined.");
    }

    protected void setMapValue(String name, Map value, V target, Map factoryCache) {
        boolean hasValue;
        Object obj;
        if (log.isDebugEnabled()) {
            log.debug("   setMapValue(" + name + ", " + value + ")");
        }
        if ((obj = this.getProperty(target, name)) != null && !(obj instanceof Map)) {
            throw new RuntimeException("Type mismatch for field:" + name + " exising value is not a collection.");
        }
        boolean bl = hasValue = obj != null && ((Map)obj).size() > 0;
        if (!this.getOverwriteExistingValues() && !this.getAppendCollections() && hasValue) {
            return;
        }
        if (this.hasMutableProperty(target, name) && !hasValue) {
            this.setValue(name, value, target, factoryCache);
            return;
        }
        Class fieldType = this.getPropertyClass(target, name);
        if (value != null && !Map.class.isAssignableFrom(fieldType)) {
            throw new RuntimeException("Type mismatch for field:" + name + "  value type:" + value.getClass() + " not compatible with field type:" + fieldType);
        }
        Map current = (Map)obj;
        if (current != null) {
            if (this.getOverwriteExistingValues() && !this.getAppendCollections()) {
                log.debug("Clearing existing collection.");
                current.clear();
            }
            if (log.isDebugEnabled()) {
                log.debug("    putAll(" + value + ")");
            }
            current.putAll(value);
            return;
        }
        log.error("Error setting property:" + name + " on object:" + target + " No mutator defined.");
    }

    protected void setValue(String name, Object value, V target, Map factoryCache) {
        Collection c;
        Object constant;
        Class<?> type;
        if (log.isDebugEnabled()) {
            log.debug("   setValue(" + name + ", " + value + ")");
        }
        if ((type = this.getPropertyClass(target, name)) == null) {
            throw new RuntimeException("Error setting property:" + name + " on object:" + target + " Property not found.");
        }
        Object obj = this.getProperty(target, name);
        if (obj != null && !this.getOverwriteExistingValues()) {
            if (log.isDebugEnabled()) {
                log.debug("   ignoring field:" + name + " with value:" + obj);
            }
            return;
        }
        if (value instanceof ObjectConfigurator && !ObjectConfigurator.class.isAssignableFrom(type)) {
            value = ConfiguratorUtils.resolveConfigurator((ObjectConfigurator)value, factoryCache);
            if (log.isDebugEnabled()) {
                log.debug("   created:" + value);
            }
        } else if (!type.isEnum() && value instanceof String && (constant = Inspector.getConstant((String)value, target.getClass())) != null) {
            value = constant;
        }
        if ((type = Inspector.translateFromPrimitive(type)).isInstance(value) || value == null && !type.isPrimitive()) {
            this.setProperty(target, name, value);
            return;
        }
        if (type.isArray() && value instanceof Collection) {
            c = (Collection)value;
            Object[] array = (Object[])Array.newInstance(type.getComponentType(), c.size());
            array = c.toArray(array);
            this.setProperty(target, name, array);
            return;
        }
        if (!(value instanceof String)) {
            if (Collection.class.isAssignableFrom(type)) {
                c = InspectionUtils.createCollection(type);
                c.add(value);
                this.setProperty(target, name, c);
                return;
            }
            throw new RuntimeException("Error setting property:" + name + " type:" + type + " on object:" + target + " Incompatible type:" + (value != null ? value.getClass().toString() : ""));
        }
        Object v = Inspector.constructFromString((String)value, type);
        if (v == null) {
            throw new RuntimeException("Error setting property:" + name + " on object:" + target + " Could not convert string[" + value + "] to type:" + type);
        }
        this.setProperty(target, name, v);
    }

    @Override
    public void setAppendCollections(boolean flag) {
        this.appendCollections = flag;
    }

    @Override
    public boolean getAppendCollections() {
        return this.appendCollections;
    }

    @Override
    public void setAppendFactories(boolean flag) {
        this.appendFactories = flag;
    }

    @Override
    public boolean getAppendFactories() {
        return this.appendFactories;
    }

    @Override
    public void setOverwriteExistingValues(boolean flag) {
        this.overwriteExistingValues = flag;
    }

    @Override
    public boolean getOverwriteExistingValues() {
        return this.overwriteExistingValues;
    }

    @Override
    public void setReuseFactoryResults(boolean f) {
        this.reuseFactoryResults = f;
    }

    @Override
    public boolean getReuseFactoryResults() {
        return this.reuseFactoryResults;
    }

    @Override
    public void setReusable(boolean f) {
        this.reusable = f;
    }

    @Override
    public boolean isReusable() {
        return this.reusable;
    }

    @Override
    public void addConfiguratorListener(ConfiguratorListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeConfiguratorListener(ConfiguratorListener listener) {
        this.listeners.remove(listener);
    }

    protected List getConfiguratorListeners() {
        return this.listeners;
    }

    protected Object getProperty(V obj, String name) {
        return this.getPropertyAccess().getProperty(obj, name);
    }

    protected Class getPropertyClass(V obj, String name) {
        return this.getPropertyAccess().getPropertyClass(obj, name);
    }

    protected void setProperty(V obj, String name, Object value) {
        this.getPropertyAccess().setProperty(obj, name, value);
    }

    protected boolean hasMutableProperty(V obj, String name) {
        return this.getPropertyAccess().hasMutableProperty(obj, name);
    }

    @Override
    public Object put(String key, Object value) {
        if (!(key instanceof String)) {
            throw new RuntimeException("Key values must be Strings.");
        }
        return super.put(key, value);
    }

    protected void fireObjectCreated(V object) {
        if (this.listeners.size() == 0) {
            return;
        }
        ConfiguratorListener[] array = new ConfiguratorListener[this.listeners.size()];
        array = this.listeners.toArray(array);
        for (int i = 0; i < array.length; ++i) {
            array[i].objectCreated(object, this);
        }
    }

    @Override
    public void appendFactory(ObjectConfigurator factory) {
        ConfiguratorUtils.mergeFactories(this, factory);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.listeners = new ArrayList<ConfiguratorListener>();
    }
}

