/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.progeeks.util.beans.BeanChangeSupport;
import org.progeeks.util.beans.StandardBean;

public class AdapterInvocationHandler
implements InvocationHandler {
    private MethodMapping mapping;
    private Object target;

    private AdapterInvocationHandler(MethodMapping mapping, Object target) {
        this.mapping = mapping;
        this.target = target;
    }

    public static Object newAdapterProxy(Class[] interfaces, Object target) {
        return AdapterInvocationHandler.newAdapterProxy(target.getClass().getClassLoader(), interfaces, target);
    }

    public static Object newAdapterProxy(ClassLoader loader, Class[] interfaces, Object target) {
        MethodMapping mapping = new MethodMapping(interfaces, target.getClass());
        AdapterInvocationHandler handler = new AdapterInvocationHandler(mapping, target);
        return Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)handler);
    }

    public static boolean isConformingClass(Class[] interfaces, Class objClass) {
        try {
            MethodMapping mapping = new MethodMapping(interfaces, objClass);
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Method m = this.mapping.methods.get(method);
        if (m == null) {
            m = this.mapping.methods.get(method.getName());
        }
        if (m == null) {
            throw new RuntimeException("No matching method found for:" + method);
        }
        return m.invoke(this.target, args);
    }

    public static void main(String[] args) {
        Class[] interfaces = new Class[]{StandardBean.class};
        Object obj = AdapterInvocationHandler.newAdapterProxy(interfaces, new BeanChangeSupport());
        StandardBean bean = (StandardBean)obj;
        System.out.println("hasListener(\"test\") : " + bean.hasListeners("test"));
        bean.addPropertyChangeListener("test", null);
        System.out.println("hasListener(\"test\") : " + bean.hasListeners("test"));
        System.out.println("equals( null ) : " + bean.equals(null));
        System.out.println("toString() : " + bean.toString());
    }

    private static class MethodMapping {
        Class[] interfaces;
        Class type;
        Map<Object, Method> methods = new HashMap<Object, Method>();

        public MethodMapping(Class[] interfaces, Class type) {
            this.interfaces = interfaces;
            this.type = type;
            this.buildMapping();
        }

        private void addMapping(Method method) {
            if (this.methods.containsKey(method)) {
                return;
            }
            try {
                Method m = this.type.getMethod(method.getName(), method.getParameterTypes());
                this.methods.put(method, m);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("No conforming method for:" + method);
            }
        }

        private void buildMapping() {
            for (int i = 0; i < this.interfaces.length; ++i) {
                if (!this.interfaces[i].isInterface()) {
                    throw new RuntimeException(this.interfaces[i] + " is not an interface.");
                }
                Method[] list = this.interfaces[i].getMethods();
                for (int j = 0; j < list.length; ++j) {
                    this.addMapping(list[j]);
                }
            }
            try {
                Method m = this.type.getMethod("hashCode", null);
                this.methods.put("hashCode", m);
                m = this.type.getMethod("toString", null);
                this.methods.put("toString", m);
                m = this.type.getMethod("equals", Object.class);
                this.methods.put("equals", m);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Error looking up standard methods.", e);
            }
        }
    }
}

