/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.progeeks.util.DefaultProgressReporter;
import org.progeeks.util.ProgressReporter;

public class AggregatedProgressReporter
implements ProgressReporter {
    private String message;
    private int min = -1;
    private int max = -1;
    private int progress = -1;
    private int steps = 0;
    private List<ChildReporter> children = new CopyOnWriteArrayList<ChildReporter>();
    private ProgressReporter delegate;

    public AggregatedProgressReporter() {
        this(new DefaultProgressReporter());
    }

    public AggregatedProgressReporter(ProgressReporter delegate) {
        this.setProgressDelegate(delegate);
    }

    public void setSteps(int steps) {
        this.steps = steps;
    }

    public int getSteps() {
        return this.steps;
    }

    public void setProgressDelegate(ProgressReporter delegate) {
        this.delegate = delegate;
        delegate.setMessage(this.message);
        delegate.setMinimum(this.min);
        delegate.setMaximum(this.max);
        delegate.setProgress(this.progress);
    }

    public ProgressReporter getProgressDelegate() {
        return this.delegate;
    }

    public void setMessage(String message) {
        this.message = message;
        this.delegate.setMessage(message);
    }

    public String getMessage() {
        return this.message;
    }

    public void setProgress(int val) {
    }

    public int getProgress() {
        return this.progress;
    }

    public void setMinimum(int val) {
    }

    public int getMinimum() {
        return this.min;
    }

    public void setMaximum(int val) {
    }

    public int getMaximum() {
        return this.max;
    }

    public boolean isCanceled() {
        return this.delegate.isCanceled();
    }

    public void done() {
        for (ChildReporter r : this.children) {
            r.done();
        }
    }

    protected ProgressReporter createChildDelegate(String message, int min, int max) {
        DefaultProgressReporter rep = new DefaultProgressReporter();
        rep.setMessage(message);
        rep.setMinimum(min);
        rep.setMaximum(max);
        return rep;
    }

    protected void removeChildDelegate(ProgressReporter child) {
    }

    protected void updateProgress(String message, int delta) {
        if (delta != 0) {
            this.recalculateTotals();
            this.delegate.setMessage(message);
        }
    }

    protected void recalculateTotals() {
        double totalProgress = 0.0;
        double total = (double)Math.max(this.children.size(), this.steps) * 100.0;
        for (ChildReporter child : this.children) {
            if (child.getMaximum() == child.getMinimum()) continue;
            double range = child.getMaximum() - child.getMinimum();
            double val = (double)(child.getProgress() - child.getMinimum()) * 100.0 / range;
            totalProgress += val;
        }
        this.max = (int)Math.round(total);
        this.progress = (int)Math.round(totalProgress);
        this.delegate.setMaximum(this.max);
        this.delegate.setProgress(this.progress);
    }

    public ProgressReporter getChild(String message, int min, int max) {
        ProgressReporter bare = this.createChildDelegate(message, min, max);
        ChildReporter child = new ChildReporter(bare);
        this.children.add(child);
        return child;
    }

    public AggregatedProgressReporter getAggregatedChild(int steps) {
        ProgressReporter bare = this.createChildDelegate(null, -1, -1);
        ChildReporter child = new ChildReporter(bare);
        this.children.add(child);
        return new AggregatedProgressReporter(child);
    }

    public void removeChild(ProgressReporter child) {
        if (child instanceof AggregatedProgressReporter) {
            this.removeChild(((AggregatedProgressReporter)child).delegate);
            return;
        }
        child.done();
        this.children.remove(child);
        this.removeChildDelegate(((ChildReporter)child).getDelegate());
        this.recalculateTotals();
    }

    protected class ChildReporter
    implements ProgressReporter {
        private ProgressReporter delegate;
        private int progress;

        public ChildReporter(ProgressReporter delegate) {
            this.delegate = delegate;
            AggregatedProgressReporter.this.recalculateTotals();
            this.setProgress(delegate.getProgress());
        }

        protected ProgressReporter getDelegate() {
            return this.delegate;
        }

        public void setMessage(String message) {
            this.delegate.setMessage(message);
        }

        public String getMessage() {
            return this.delegate.getMessage();
        }

        public void setProgress(int val) {
            this.delegate.setProgress(val);
            if (val != this.progress) {
                AggregatedProgressReporter.this.updateProgress(this.delegate.getMessage(), val - this.progress);
            }
            this.progress = val;
        }

        public int getProgress() {
            return this.delegate.getProgress();
        }

        public void setMinimum(int val) {
            this.delegate.setMinimum(val);
            AggregatedProgressReporter.this.recalculateTotals();
        }

        public int getMinimum() {
            return this.delegate.getMinimum();
        }

        public void setMaximum(int val) {
            this.delegate.setMaximum(val);
            AggregatedProgressReporter.this.recalculateTotals();
        }

        public int getMaximum() {
            return this.delegate.getMaximum();
        }

        public boolean isCanceled() {
            boolean b = this.delegate.isCanceled();
            if (b) {
                AggregatedProgressReporter.this.removeChild(this);
            }
            return b;
        }

        public void done() {
            this.delegate.done();
            this.setProgress(this.getMaximum());
        }
    }
}

