/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.progeeks.util.Inspector;
import org.progeeks.util.log.Log;

public class ArrayUtils {
    static Log log = Log.getLog();
    private static final Map<String, Class> A_PRIMS = new HashMap<String, Class>();

    public static Class getArrayClass(String s) {
        if (s.charAt(0) != '[') {
            if (log.isTraceEnabled()) {
                log.trace("String [" + s + "] missing leading '['.");
            }
            return null;
        }
        if (s.charAt(1) == '[') {
            Class sub = ArrayUtils.getArrayClass(s.substring(1));
            if (sub == null) {
                if (log.isDebugEnabled()) {
                    log.debug("String [" + s.substring(1) + "] not a sub-type.");
                }
                return null;
            }
            Object o = Array.newInstance(sub, 0);
            return o.getClass();
        }
        Class result = A_PRIMS.get(s);
        if (result != null) {
            return result;
        }
        if (s.charAt(1) != 'L' || s.charAt(s.length() - 1) != ';') {
            if (log.isDebugEnabled()) {
                log.debug("String [" + s + "] does not match '[Lcname;'");
            }
            return null;
        }
        String type = s.substring(2, s.length() - 1);
        Class element = Inspector.getClassForName(type);
        if (element == null) {
            if (log.isDebugEnabled()) {
                log.debug("Element type [" + type + "] was invalid.");
            }
            return null;
        }
        Object o = Array.newInstance(element, 0);
        return o.getClass();
    }

    public static Class getArrayClass(Class type, int dimensions) {
        if (dimensions == 0) {
            return type;
        }
        Object o = Array.newInstance(ArrayUtils.getArrayClass(type, dimensions - 1), dimensions);
        return o.getClass();
    }

    public static Object constructFromString(String value, Class type) {
        if (value == null || value.trim().length() == 0) {
            return null;
        }
        if (value.equals("null")) {
            return null;
        }
        String arrayString = value.trim();
        if (!arrayString.startsWith("[") || !arrayString.endsWith("]")) {
            return null;
        }
        Class<?> compType = type.getComponentType();
        if (arrayString.length() == 2) {
            return Array.newInstance(compType, 0);
        }
        if ((arrayString = arrayString.substring(1, value.length() - 1).trim()).length() == 0) {
            return Array.newInstance(compType, 0);
        }
        String[] values = ArrayUtils.parse(arrayString);
        Object array = Array.newInstance(compType, values.length);
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null || values[i].trim().length() == 0) continue;
            Object v = Inspector.constructFromString(values[i], compType);
            if (v != null) {
                Array.set(array, i, v);
                continue;
            }
            if (values[i].equals("null")) continue;
            return null;
        }
        return array;
    }

    public static String escape(String s) {
        if (s.length() == 0) {
            return s;
        }
        char start = s.charAt(0);
        char end = s.charAt(s.length() - 1);
        if (!(Character.isWhitespace(start) || Character.isWhitespace(end) || start == '\"' && end == '\"' || s.indexOf(44) >= 0)) {
            return s;
        }
        s = s.replaceAll("\\\\", "\\\\\\\\");
        s = s.replaceAll("\"", "\\\\\"");
        return '\"' + s + '\"';
    }

    public static String encodeAsString(Object value) {
        Class<?> compType = value.getClass().getComponentType();
        if (!compType.isPrimitive()) {
            Object[] array = (Object[])value;
            StringBuilder sb = new StringBuilder("[");
            for (int i = 0; i < array.length; ++i) {
                sb.append(ArrayUtils.escape(Inspector.encodeAsString(array[i])));
                if (i >= array.length - 1) continue;
                sb.append(", ");
            }
            sb.append("]");
            return sb.toString();
        }
        if (Boolean.TYPE.isAssignableFrom(compType)) {
            return Arrays.toString((boolean[])value);
        }
        if (Byte.TYPE.isAssignableFrom(compType)) {
            return Arrays.toString((byte[])value);
        }
        if (Character.TYPE.isAssignableFrom(compType)) {
            return Arrays.toString((char[])value);
        }
        if (Double.TYPE.isAssignableFrom(compType)) {
            return Arrays.toString((double[])value);
        }
        if (Float.TYPE.isAssignableFrom(compType)) {
            return Arrays.toString((float[])value);
        }
        if (Integer.TYPE.isAssignableFrom(compType)) {
            return Arrays.toString((int[])value);
        }
        if (Long.TYPE.isAssignableFrom(compType)) {
            return Arrays.toString((long[])value);
        }
        if (Short.TYPE.isAssignableFrom(compType)) {
            return Arrays.toString((short[])value);
        }
        return String.valueOf(value);
    }

    protected static String[] parse(String s) {
        int c;
        ArrayList<String> results = new ArrayList<String>();
        CharStream in = new CharStream(s);
        while ((c = in.read(false)) >= 0) {
            if (Character.isWhitespace(c)) continue;
            StringBuilder entry = new StringBuilder();
            if (c == 34) {
                in.readUntil('\"', entry, true);
                in.skipWhitespace();
                c = in.read(false);
                if (c >= 0 && c != 44) {
                    in.pushBack();
                }
            } else if (c != 44) {
                entry.append((char)c);
                in.readUntil(',', entry, false);
            }
            results.add(entry.toString());
        }
        return results.toArray(new String[results.size()]);
    }

    public static void main(String[] args) {
        String[] test;
        for (String s : test = new String[]{"\"Quoted string test.\"", "  extra whitespace test", "another extra whitespace test  ", "regular string", "string with a ','", "  string with other \\b escapes and escaped quote \\\""}) {
            System.out.println("test[" + s + "] escaped[" + ArrayUtils.escape(s) + "]");
        }
        System.out.println("Converting to whole test array to a string:");
        String encoded = ArrayUtils.encodeAsString(test);
        System.out.println("result[" + encoded + "]");
        String[] result = (String[])ArrayUtils.constructFromString(encoded, test.getClass());
        System.out.println("Decoded:");
        for (String s : result) {
            System.out.println("result[" + s + "]");
        }
        int[][] intTest = new int[][]{{1, 2, 3, 4}, {5, 6, 7, 8}, {9, 10, 11, 12}, {13, 14, 15, 16}};
        encoded = ArrayUtils.encodeAsString(intTest);
        System.out.println("4x4 int array:" + encoded);
        int[][] intResult = (int[][])ArrayUtils.constructFromString(encoded, intTest.getClass());
        System.out.println("Reconstructed:");
        int[][] arr$ = intResult;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int[] row;
            for (int val : row = arr$[i$]) {
                System.out.print("[" + val + "]");
            }
            System.out.println();
        }
    }

    static {
        A_PRIMS.put(boolean[].class.getName(), boolean[].class);
        A_PRIMS.put(char[].class.getName(), char[].class);
        A_PRIMS.put(byte[].class.getName(), byte[].class);
        A_PRIMS.put(short[].class.getName(), short[].class);
        A_PRIMS.put(int[].class.getName(), int[].class);
        A_PRIMS.put(long[].class.getName(), long[].class);
        A_PRIMS.put(float[].class.getName(), float[].class);
        A_PRIMS.put(double[].class.getName(), double[].class);
    }

    protected static class CharStream {
        private CharSequence original;
        private int pos;
        private int length;
        private boolean escaped;

        public CharStream(CharSequence seq) {
            this.original = seq;
            this.pos = 0;
            this.length = seq.length();
        }

        public int read(boolean handleEscapes) {
            if (this.pos >= this.length) {
                return -1;
            }
            this.escaped = false;
            char c = this.original.charAt(this.pos++);
            if (handleEscapes && c == '\\' && this.pos < this.length) {
                this.escaped = true;
                c = this.original.charAt(this.pos++);
            }
            return c;
        }

        public void pushBack() {
            --this.pos;
        }

        public void skipWhitespace() {
            int c;
            while ((c = this.read(false)) >= 0) {
                if (Character.isWhitespace((char)c)) continue;
                --this.pos;
                break;
            }
        }

        public StringBuilder readUntil(char stop, StringBuilder result, boolean handleEscapes) {
            int c;
            while ((c = this.read(handleEscapes)) >= 0) {
                if (!this.escaped && c == stop) {
                    return result;
                }
                result.append((char)c);
            }
            return result;
        }
    }
}

