/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BinaryDataInputStream
extends InputStream
implements DataInput {
    private DataInputStream in;
    private long bytesRead = 0L;
    private boolean littleEndian = true;

    public BinaryDataInputStream(InputStream in) {
        this.in = new DataInputStream(in);
    }

    public void setLittleEndian(boolean le) {
        this.littleEndian = le;
    }

    public boolean isLittleEndian() {
        return this.littleEndian;
    }

    public long getFilePosition() {
        return this.bytesRead;
    }

    public void gotoPosition(long pos) throws IOException {
        long skip = pos - this.bytesRead;
        if (skip < 0L) {
            throw new IOException("Cannot skip backwards.  At " + this.bytesRead + ", going to " + pos);
        }
        if (skip == 0L) {
            return;
        }
        long result = this.skip(skip);
        if (result < skip) {
            throw new IOException("Only skipped ahead " + result + " bytes instead of " + skip);
        }
    }

    public void close() throws IOException {
        this.in.close();
    }

    public void readFully(byte[] b) throws IOException {
        this.in.readFully(b);
        this.bytesRead += (long)b.length;
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.in.readFully(b, off, len);
        this.bytesRead += (long)len;
    }

    public int skipBytes(int n) throws IOException {
        return (int)this.skip(n);
    }

    public boolean readBoolean() throws IOException {
        boolean b = this.in.readBoolean();
        ++this.bytesRead;
        return b;
    }

    public byte readByte() throws IOException {
        byte b = this.in.readByte();
        ++this.bytesRead;
        return b;
    }

    public int readUnsignedByte() throws IOException {
        int i = this.in.readUnsignedByte();
        ++this.bytesRead;
        return i;
    }

    public short readShort() throws IOException {
        this.bytesRead += 2L;
        if (!this.littleEndian) {
            return this.in.readShort();
        }
        int low = this.in.readUnsignedByte();
        byte hi = this.in.readByte();
        short s = (short)(hi << 8 | low);
        return s;
    }

    public int readUnsignedShort() throws IOException {
        this.bytesRead += 2L;
        if (!this.littleEndian) {
            return this.in.readUnsignedShort();
        }
        int low = this.in.readUnsignedByte();
        int hi = this.in.readUnsignedByte();
        int s = hi << 8 | low;
        return s;
    }

    public char readChar() throws IOException {
        char c = this.in.readChar();
        this.bytesRead += 2L;
        return c;
    }

    public int readInt() throws IOException {
        this.bytesRead += 4L;
        if (!this.littleEndian) {
            return this.in.readInt();
        }
        int b1 = this.in.readUnsignedByte();
        int b2 = this.in.readUnsignedByte();
        int b3 = this.in.readUnsignedByte();
        int b4 = this.in.readUnsignedByte();
        int i = b4 << 24 | b3 << 16 | b2 << 8 | b1;
        return i;
    }

    public long readLong() throws IOException {
        if (!this.littleEndian) {
            this.bytesRead += 8L;
            return this.in.readLong();
        }
        int low = this.readInt();
        int hi = this.readInt();
        long l = (long)hi << 32 | (long)low & 0xFFFFFFFFL;
        return l;
    }

    public float readFloat() throws IOException {
        if (!this.littleEndian) {
            this.bytesRead += 4L;
            return this.in.readFloat();
        }
        int i = this.readInt();
        float f = Float.intBitsToFloat(i);
        return f;
    }

    public double readDouble() throws IOException {
        if (!this.littleEndian) {
            this.bytesRead += 8L;
            return this.in.readDouble();
        }
        long l = this.readLong();
        double d = Double.longBitsToDouble(l);
        return d;
    }

    public String readLine() throws IOException {
        throw new UnsupportedOperationException("readLine() not supported.");
    }

    public String readUTF() throws IOException {
        throw new UnsupportedOperationException("readUTF() not supported.");
    }

    public long skip(long skip) throws IOException {
        long result;
        long total = 0L;
        while ((result = this.in.skip(skip - total)) > 0L && (total += result) < skip) {
        }
        this.bytesRead += total;
        return total;
    }

    public int read() throws IOException {
        int val = this.in.read();
        if (val >= 0) {
            ++this.bytesRead;
        }
        return val;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.in.read(b, off, len);
        if (result > 0) {
            this.bytesRead += (long)result;
        }
        return result;
    }

    public static int swapBytes(int i) {
        int result = (i & 0xFF) << 24;
        result |= (i & 0xFF00) << 8;
        result |= (i & 0xFF0000) >> 8;
        return result |= (i & 0xFF000000) >> 24 & 0xFF;
    }
}

