/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.progeeks.util.log.Log;

public class Cache {
    static Log log = Log.getLog(Cache.class);
    private static ReferenceQueue<Object> refQueue = new ReferenceQueue();
    private static ReaperThread reaper = new ReaperThread();
    private Map<Object, CacheEntry> objects = new HashMap<Object, CacheEntry>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCachedObject(Object id) {
        Map<Object, CacheEntry> map = this.objects;
        synchronized (map) {
            CacheEntry entry = this.objects.get(id);
            if (entry == null) {
                return null;
            }
            return entry.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheObject(Object id, Object obj) {
        Map<Object, CacheEntry> map = this.objects;
        synchronized (map) {
            CacheEntry old;
            if (log.isDebugEnabled()) {
                log.debug("Caching object for ID:" + id);
            }
            if ((old = this.objects.put(id, new CacheEntry(id, obj, this))) != null) {
                old.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uncacheObject(Object id) {
        Map<Object, CacheEntry> map = this.objects;
        synchronized (map) {
            if (log.isDebugEnabled()) {
                log.debug("Uncaching object for ID:" + id);
            }
            return this.objects.remove(id) != null;
        }
    }

    static {
        reaper.start();
    }

    private static class ReaperThread
    extends Thread {
        public ReaperThread() {
            this.setDaemon(true);
            this.setName("Cache Reaper");
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        CacheEntry entry = (CacheEntry)refQueue.remove();
                        if (log.isDebugEnabled()) {
                            log.debug("Reaping entry for ID:" + entry.id);
                        }
                        entry.uncache();
                    }
                }
                catch (Throwable t) {
                    log.error("Error in reap iteration", t);
                    continue;
                }
                break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CacheEntry
    extends WeakReference<Object> {
        private Object id;
        private Cache cache;

        public CacheEntry(Object id, Object obj, Cache cache) {
            super(obj, refQueue);
            this.id = id;
            this.cache = cache;
        }

        @Override
        public void clear() {
            super.clear();
            this.cache = null;
            this.id = null;
        }

        private void uncache() {
            if (this.cache != null) {
                this.cache.uncacheObject(this.id);
            }
        }
    }
}

