/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeClassLoader
extends ClassLoader {
    private String parentOverrideRegex = "java\\..*";
    private Pattern parentOverridePattern = Pattern.compile(this.parentOverrideRegex);
    private ClassLoader[] loaders = new ClassLoader[0];
    private boolean deny = false;

    public CompositeClassLoader() {
    }

    public CompositeClassLoader(List<ClassLoader> classLoaders) {
        this.setClassLoaders(classLoaders);
    }

    public CompositeClassLoader(ClassLoader parent) {
        super(parent);
    }

    public CompositeClassLoader(ClassLoader parent, List<ClassLoader> classLoaders) {
        super(parent);
        this.setClassLoaders(classLoaders);
    }

    public void setClassLoaders(List<ClassLoader> classLoaders) {
        this.loaders = new ClassLoader[classLoaders.size()];
        this.loaders = classLoaders.toArray(this.loaders);
    }

    public List<ClassLoader> getClassLoaders() {
        return Arrays.asList(this.loaders);
    }

    public void setParentOverrideRegex(String regex) {
        this.parentOverrideRegex = regex;
        this.parentOverridePattern = Pattern.compile(this.parentOverrideRegex);
    }

    public String getParentOverrideRegex() {
        return this.parentOverrideRegex;
    }

    protected boolean shouldLoadClassFromParent(String name) {
        Matcher m = this.parentOverridePattern.matcher(name);
        return m.matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class getClass(String name) throws ClassNotFoundException {
        Class c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        if (this.shouldLoadClassFromParent(name)) {
            return super.loadClass(name, false);
        }
        if (this.deny) {
            return null;
        }
        this.deny = true;
        try {
            c = this.findClass(name);
            if (c != null) {
                Class clazz = c;
                return clazz;
            }
        }
        finally {
            this.deny = false;
        }
        return super.loadClass(name, false);
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class c = this.getClass(name);
        if (c == null) {
            throw new ClassNotFoundException(name);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        for (int i = 0; i < this.loaders.length; ++i) {
            try {
                Class<?> c = this.loaders[i].loadClass(name);
                return c;
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
        }
        return null;
    }

    @Override
    public URL getResource(String name) {
        return this.findResource(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected URL findResource(String name) {
        if (this.deny) {
            return null;
        }
        this.deny = true;
        try {
            int i = 0;
            if (i < this.loaders.length) {
                URL u;
                URL uRL = u = this.loaders[i].getResource(name);
                return uRL;
            }
        }
        finally {
            this.deny = false;
        }
        return super.findResource(name);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.out.println("Usage: CompositeClassLoader <classpath entry> [<classpath entry>...] <class name>");
            System.out.println("  Just a command line test version of the CompositeClassLoader class.");
            System.out.println("  Creates a ClassLoader with nested URLClassLoaders for each of the");
            System.out.println("  specified classpath entries and then tries to load a class... in");
            System.out.println("  addition to a few test classes.");
            return;
        }
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        System.out.println("System class loader:" + cl);
        cl = cl.getParent();
        System.out.println("Parent class loader:" + cl.getParent());
        CompositeClassLoader loader = new CompositeClassLoader();
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>();
        for (int i = 0; i < args.length - 1; ++i) {
            URL u = new URL(args[i]);
            URLClassLoader l = new URLClassLoader(new URL[]{u}, (ClassLoader)loader);
            loaders.add(l);
        }
        loader.setClassLoaders(loaders);
        Class<?> test = loader.loadClass("java.lang.String");
        System.out.println("Test class:" + test + "  classloader:" + test.getClassLoader());
        test = loader.loadClass("java.util.ArrayList");
        System.out.println("Test class:" + test + "  classloader:" + test.getClassLoader());
        test = loader.loadClass("javax.swing.JFrame");
        System.out.println("Test class:" + test + "  classloader:" + test.getClassLoader());
        test = loader.loadClass("javax.management.Attribute");
        System.out.println("Test class:" + test + "  classloader:" + test.getClassLoader());
        test = loader.loadClass("org.progeeks.util.Inspector");
        System.out.println("Test class:" + test + "  classloader:" + test.getClassLoader());
        System.out.println("Resource test:" + loader.getResource("LICENSE"));
        Enumeration<URL> en = loader.getResources("LICENSE");
        while (en.hasMoreElements()) {
            System.out.println("resource:" + en.nextElement());
        }
        String cname = args[args.length - 1];
        System.out.println("Loading user-defined class:" + cname);
        test = loader.loadClass(cname);
        System.out.println("User-defined class:" + test + "  classloader:" + test.getClassLoader());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.loaders.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.loaders[i]);
        }
        return "CompositeClassLoader[ overrideRegex=" + this.getParentOverrideRegex() + ", loaders=" + sb + "]";
    }
}

