/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.util.Collection;
import java.util.Map;
import org.progeeks.util.InspectionUtils;
import org.progeeks.util.ObjectConfigurator;
import org.progeeks.util.log.Log;

public class ConfiguratorUtils {
    static Log log = Log.getLog();

    public static Object resolveConfigurator(ObjectConfigurator factory, Map factoryCache) {
        Object result;
        if (log.isDebugEnabled()) {
            log.debug("resolveFactory(" + factory + ", " + factoryCache + ")");
        }
        if (factoryCache != null && factory.isReusable() && (result = factoryCache.get(factory)) != null) {
            if (log.isDebugEnabled()) {
                log.debug("Reusing result:" + result);
            }
            return result;
        }
        result = factory.createObject(factoryCache, new Object[0]);
        if (factoryCache != null && factory.isReusable()) {
            factoryCache.put(factory, result);
        }
        return result;
    }

    public static Collection resolveCollection(Collection values, Class targetType, Map factoryCache) {
        if (values == null) {
            return null;
        }
        boolean noFactories = true;
        for (Object o : values) {
            if (!(o instanceof ObjectConfigurator)) continue;
            noFactories = false;
            break;
        }
        if (noFactories) {
            return values;
        }
        if (targetType == null) {
            targetType = values.getClass();
        }
        Collection newValues = InspectionUtils.createCollection(values.getClass());
        for (Object o : values) {
            if (o instanceof ObjectConfigurator) {
                o = ConfiguratorUtils.resolveConfigurator((ObjectConfigurator)o, factoryCache);
                if (log.isDebugEnabled()) {
                    log.debug("   created:" + o);
                }
            }
            newValues.add(o);
        }
        return newValues;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void mergeConfiguratorValue(ObjectConfigurator source, ObjectConfigurator target, String key, Object value) {
        if (log.isDebugEnabled()) {
            log.debug("appendConfiguratorValue(" + key + ", " + value + ")");
        }
        boolean overwrite = source.getOverwriteExistingValues();
        boolean append = source.getAppendCollections();
        boolean appendFactories = source.getAppendFactories();
        Object existing = target.get(key);
        if (log.isDebugEnabled()) {
            log.debug("existing:" + existing);
        }
        if (existing == null) {
            target.put(key, value);
            return;
        }
        if (existing instanceof Collection) {
            Collection c = (Collection)existing;
            if (c.size() == 0) {
                target.put(key, value);
                return;
            }
            if (!overwrite && !append) {
                return;
            }
            if (overwrite && !append) {
                c.clear();
            }
            if (value instanceof Collection) {
                c.addAll((Collection)value);
                return;
            } else {
                c.add(value);
            }
            return;
        } else if (existing instanceof ObjectConfigurator) {
            ObjectConfigurator oc = (ObjectConfigurator)existing;
            if (oc.size() == 0 || overwrite && !appendFactories) {
                target.put(key, value);
                return;
            }
            if (!overwrite && !appendFactories) {
                return;
            }
            if (!(value instanceof ObjectConfigurator)) throw new RuntimeException("Cannot update factory value for key[" + key + "] with non-factory value:" + value);
            oc.appendFactory((ObjectConfigurator)value);
            return;
        } else if (existing instanceof Map) {
            Map m = (Map)existing;
            if (m.size() == 0) {
                target.put(key, value);
                return;
            }
            if (!overwrite && !append) {
                return;
            }
            if (overwrite && !append) {
                m.clear();
            }
            if (!(value instanceof Map)) throw new RuntimeException("Cannot update map for key[" + key + "] with non-map value:" + value);
            m.putAll((Map)value);
            return;
        } else {
            if (!overwrite) return;
            target.put(key, value);
        }
    }

    public static void mergeFactories(ObjectConfigurator target, ObjectConfigurator source) {
        for (Map.Entry e : source.entrySet()) {
            ConfiguratorUtils.mergeConfiguratorValue(source, target, (String)e.getKey(), e.getValue());
        }
    }
}

