/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.io.IOException;
import java.io.InputStream;

public class CountingInputStream
extends InputStream {
    private InputStream in;
    private long bytesRead = 0L;

    public CountingInputStream(InputStream in) {
        this.in = in;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    protected void updateBytesRead(long delta) {
        this.bytesRead += delta;
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
    }

    public int read() throws IOException {
        int i = this.in.read();
        if (i != -1) {
            this.updateBytesRead(1L);
        }
        return i;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.in.read(b, off, len);
        this.updateBytesRead(read);
        return read;
    }

    public long skip(long n) throws IOException {
        long skipped = this.in.skip(n);
        this.updateBytesRead(skipped);
        return skipped;
    }

    public void mark(int readlimit) {
    }

    public void reset() throws IOException {
        throw new IOException("reset() not supported.");
    }

    public boolean markSupported() {
        return false;
    }
}

